/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutGroupConfigurationRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, PutGroupConfigurationRequest> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(PutGroupConfigurationRequest.getter(PutGroupConfigurationRequest::group)).setter(PutGroupConfigurationRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<GroupConfigurationItem>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configuration").getter(PutGroupConfigurationRequest.getter(PutGroupConfigurationRequest::configuration)).setter(PutGroupConfigurationRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, CONFIGURATION_FIELD));
    private final String group;
    private final List<GroupConfigurationItem> configuration;

    private PutGroupConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.configuration = builder.configuration;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructList);
    }

    public final List<GroupConfigurationItem> configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGroupConfigurationRequest)) {
            return false;
        }
        PutGroupConfigurationRequest other = (PutGroupConfigurationRequest)((Object)obj);
        return Objects.equals(this.group(), other.group()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"PutGroupConfigurationRequest").add("Group", (Object)this.group()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutGroupConfigurationRequest, T> g) {
        return obj -> g.apply((PutGroupConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String group;
        private List<GroupConfigurationItem> configuration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGroupConfigurationRequest model) {
            super(model);
            this.group(model.group);
            this.configuration(model.configuration);
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final Collection<GroupConfigurationItem.Builder> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuration != null ? (Collection)this.configuration.stream().map(GroupConfigurationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configuration(Collection<GroupConfigurationItem> configuration) {
            this.configuration = GroupConfigurationListCopier.copy(configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(GroupConfigurationItem ... configuration) {
            this.configuration(Arrays.asList(configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(Consumer<GroupConfigurationItem.Builder> ... configuration) {
            this.configuration(Stream.of(configuration).map(c -> (GroupConfigurationItem)((GroupConfigurationItem.Builder)GroupConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfiguration(Collection<GroupConfigurationItem.BuilderImpl> configuration) {
            this.configuration = GroupConfigurationListCopier.copyFromBuilder(configuration);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGroupConfigurationRequest build() {
            return new PutGroupConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutGroupConfigurationRequest> {
        public Builder group(String var1);

        public Builder configuration(Collection<GroupConfigurationItem> var1);

        public Builder configuration(GroupConfigurationItem ... var1);

        public Builder configuration(Consumer<GroupConfigurationItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

