/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.services.resourcegroups.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, UntagResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UntagResponse.getter(UntagResponse::arn)).setter(UntagResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keys").getter(UntagResponse.getter(UntagResponse::keys)).setter(UntagResponse.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, KEYS_FIELD));
    private final String arn;
    private final List<String> keys;

    private UntagResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.keys = builder.keys;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public List<String> keys() {
        return this.keys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResponse)) {
            return false;
        }
        UntagResponse other = (UntagResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.keys(), other.keys());
    }

    public String toString() {
        return ToString.builder((String)"UntagResponse").add("Arn", (Object)this.arn()).add("Keys", this.keys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagResponse, T> g) {
        return obj -> g.apply((UntagResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResponse model) {
            super(model);
            this.arn(model.arn);
            this.keys(model.keys);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = TagKeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = TagKeyListCopier.copy(keys);
        }

        @Override
        public UntagResponse build() {
            return new UntagResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UntagResponse> {
        public Builder arn(String var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);
    }
}

