/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse;

public class ListGroupResourcesPublisher
implements SdkPublisher<ListGroupResourcesResponse> {
    private final ResourceGroupsAsyncClient client;
    private final ListGroupResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupResourcesPublisher(ResourceGroupsAsyncClient client, ListGroupResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupResourcesPublisher(ResourceGroupsAsyncClient client, ListGroupResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListGroupResourcesPublisher resume(ListGroupResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupResourcesPublisher(this.client, (ListGroupResourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListGroupResourcesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListGroupResourcesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListGroupResourcesResponseFetcher
    implements AsyncPageFetcher<ListGroupResourcesResponse> {
        private ListGroupResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupResourcesResponse> nextPage(ListGroupResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupResourcesPublisher.this.client.listGroupResources(ListGroupResourcesPublisher.this.firstRequest);
            }
            return ListGroupResourcesPublisher.this.client.listGroupResources((ListGroupResourcesRequest)((Object)ListGroupResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

