/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourceexplorer2.model.ErrorDetails;
import software.amazon.awssdk.services.resourceexplorer2.model.Index;
import software.amazon.awssdk.services.resourceexplorer2.model.OperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IndexStatus.getter(IndexStatus::statusAsString)).setter(IndexStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Index> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Index").getter(IndexStatus.getter(IndexStatus::index)).setter(IndexStatus.setter(Builder::index)).constructor(Index::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(IndexStatus.getter(IndexStatus::errorDetails)).setter(IndexStatus.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, INDEX_FIELD, ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndexStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Index index;
    private final ErrorDetails errorDetails;

    private IndexStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.index = builder.index;
        this.errorDetails = builder.errorDetails;
    }

    public final OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Index index() {
        return this.index;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexStatus)) {
            return false;
        }
        IndexStatus other = (IndexStatus)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.index(), other.index()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"IndexStatus").add("Status", (Object)this.statusAsString()).add("Index", (Object)this.index()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("Index", INDEX_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexStatus, T> g) {
        return obj -> g.apply((IndexStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Index index;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexStatus model) {
            this.status(model.status);
            this.index(model.index);
            this.errorDetails(model.errorDetails);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Index.Builder getIndex() {
            return this.index != null ? this.index.toBuilder() : null;
        }

        public final void setIndex(Index.BuilderImpl index) {
            this.index = index != null ? index.build() : null;
        }

        @Override
        public final Builder index(Index index) {
            this.index = index;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public IndexStatus build() {
            return new IndexStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexStatus> {
        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder index(Index var1);

        default public Builder index(Consumer<Index.Builder> index) {
            return this.index((Index)((Index.Builder)Index.builder().applyMutation(index)).build());
        }

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }
    }
}

