/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateResourceExplorerSetupInputAggregatorRegionsListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateResourceExplorerSetupInputRegionListListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceExplorerSetupRequest
extends ResourceExplorer2Request
implements ToCopyableBuilder<Builder, CreateResourceExplorerSetupRequest> {
    private static final SdkField<List<String>> REGION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionList").getter(CreateResourceExplorerSetupRequest.getter(CreateResourceExplorerSetupRequest::regionList)).setter(CreateResourceExplorerSetupRequest.setter(Builder::regionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AGGREGATOR_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregatorRegions").getter(CreateResourceExplorerSetupRequest.getter(CreateResourceExplorerSetupRequest::aggregatorRegions)).setter(CreateResourceExplorerSetupRequest.setter(Builder::aggregatorRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewName").getter(CreateResourceExplorerSetupRequest.getter(CreateResourceExplorerSetupRequest::viewName)).setter(CreateResourceExplorerSetupRequest.setter(Builder::viewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_LIST_FIELD, AGGREGATOR_REGIONS_FIELD, VIEW_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResourceExplorerSetupRequest.memberNameToFieldInitializer();
    private final List<String> regionList;
    private final List<String> aggregatorRegions;
    private final String viewName;

    private CreateResourceExplorerSetupRequest(BuilderImpl builder) {
        super(builder);
        this.regionList = builder.regionList;
        this.aggregatorRegions = builder.aggregatorRegions;
        this.viewName = builder.viewName;
    }

    public final boolean hasRegionList() {
        return this.regionList != null && !(this.regionList instanceof SdkAutoConstructList);
    }

    public final List<String> regionList() {
        return this.regionList;
    }

    public final boolean hasAggregatorRegions() {
        return this.aggregatorRegions != null && !(this.aggregatorRegions instanceof SdkAutoConstructList);
    }

    public final List<String> aggregatorRegions() {
        return this.aggregatorRegions;
    }

    public final String viewName() {
        return this.viewName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionList() ? this.regionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatorRegions() ? this.aggregatorRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.viewName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceExplorerSetupRequest)) {
            return false;
        }
        CreateResourceExplorerSetupRequest other = (CreateResourceExplorerSetupRequest)((Object)obj);
        return this.hasRegionList() == other.hasRegionList() && Objects.equals(this.regionList(), other.regionList()) && this.hasAggregatorRegions() == other.hasAggregatorRegions() && Objects.equals(this.aggregatorRegions(), other.aggregatorRegions()) && Objects.equals(this.viewName(), other.viewName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceExplorerSetupRequest").add("RegionList", this.hasRegionList() ? this.regionList() : null).add("AggregatorRegions", this.hasAggregatorRegions() ? this.aggregatorRegions() : null).add("ViewName", (Object)this.viewName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionList": {
                return Optional.ofNullable(clazz.cast(this.regionList()));
            }
            case "AggregatorRegions": {
                return Optional.ofNullable(clazz.cast(this.aggregatorRegions()));
            }
            case "ViewName": {
                return Optional.ofNullable(clazz.cast(this.viewName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionList", REGION_LIST_FIELD);
        map.put("AggregatorRegions", AGGREGATOR_REGIONS_FIELD);
        map.put("ViewName", VIEW_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceExplorerSetupRequest, T> g) {
        return obj -> g.apply((CreateResourceExplorerSetupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Request.BuilderImpl
    implements Builder {
        private List<String> regionList = DefaultSdkAutoConstructList.getInstance();
        private List<String> aggregatorRegions = DefaultSdkAutoConstructList.getInstance();
        private String viewName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceExplorerSetupRequest model) {
            super(model);
            this.regionList(model.regionList);
            this.aggregatorRegions(model.aggregatorRegions);
            this.viewName(model.viewName);
        }

        public final Collection<String> getRegionList() {
            if (this.regionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionList;
        }

        public final void setRegionList(Collection<String> regionList) {
            this.regionList = CreateResourceExplorerSetupInputRegionListListCopier.copy(regionList);
        }

        @Override
        public final Builder regionList(Collection<String> regionList) {
            this.regionList = CreateResourceExplorerSetupInputRegionListListCopier.copy(regionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionList(String ... regionList) {
            this.regionList(Arrays.asList(regionList));
            return this;
        }

        public final Collection<String> getAggregatorRegions() {
            if (this.aggregatorRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregatorRegions;
        }

        public final void setAggregatorRegions(Collection<String> aggregatorRegions) {
            this.aggregatorRegions = CreateResourceExplorerSetupInputAggregatorRegionsListCopier.copy(aggregatorRegions);
        }

        @Override
        public final Builder aggregatorRegions(Collection<String> aggregatorRegions) {
            this.aggregatorRegions = CreateResourceExplorerSetupInputAggregatorRegionsListCopier.copy(aggregatorRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatorRegions(String ... aggregatorRegions) {
            this.aggregatorRegions(Arrays.asList(aggregatorRegions));
            return this;
        }

        public final String getViewName() {
            return this.viewName;
        }

        public final void setViewName(String viewName) {
            this.viewName = viewName;
        }

        @Override
        public final Builder viewName(String viewName) {
            this.viewName = viewName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceExplorerSetupRequest build() {
            return new CreateResourceExplorerSetupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceExplorer2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceExplorerSetupRequest> {
        public Builder regionList(Collection<String> var1);

        public Builder regionList(String ... var1);

        public Builder aggregatorRegions(Collection<String> var1);

        public Builder aggregatorRegions(String ... var1);

        public Builder viewName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

