/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateResourceExplorerSetupRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateResourceExplorerSetupResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteResourceExplorerSetupRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteResourceExplorerSetupResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetManagedViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetManagedViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetServiceIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetServiceIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetServiceViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetServiceViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.paginators.GetResourceExplorerSetupPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesForMembersPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListManagedViewsPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListResourcesPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceIndexesPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceViewsPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListStreamingAccessForServicesPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsPublisher;
import software.amazon.awssdk.services.resourceexplorer2.paginators.SearchPublisher;

/**
 * Service client for accessing AWS Resource Explorer asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services Resource Explorer is a resource search and discovery service. By using Resource Explorer, you can
 * explore your resources using an internet search engine-like experience. Examples of resources include Amazon
 * Relational Database Service (Amazon RDS) instances, Amazon Simple Storage Service (Amazon S3) buckets, or Amazon
 * DynamoDB tables. You can search for your resources using resource metadata like names, tags, and IDs. Resource
 * Explorer can search across all of the Amazon Web Services Regions in your account in which you turn the service on,
 * to simplify your cross-Region workloads.
 * </p>
 * <p>
 * Resource Explorer scans the resources in each of the Amazon Web Services Regions in your Amazon Web Services account
 * in which you turn on Resource Explorer. Resource Explorer <a href=
 * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/getting-started-terms-and-concepts.html#term-index"
 * >creates and maintains an index</a> in each Region, with the details of that Region's resources.
 * </p>
 * <p>
 * You can <a href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">search
 * across all of the indexed Regions in your account</a> by designating one of your Amazon Web Services Regions to
 * contain the aggregator index for the account. When you <a
 * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region-turn-on.html">promote a
 * local index in a Region to become the aggregator index for the account</a>, Resource Explorer automatically
 * replicates the index information from all local indexes in the other Regions to the aggregator index. Therefore, the
 * Region with the aggregator index has a copy of all resource information for all Regions in the account where you
 * turned on Resource Explorer. As a result, views in the aggregator index Region include resources from all of the
 * indexed Regions in your account.
 * </p>
 * <p>
 * For more information about Amazon Web Services Resource Explorer, including how to enable and configure the service,
 * see the <a href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/">Amazon Web Services Resource
 * Explorer User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ResourceExplorer2AsyncClient extends AwsClient {
    String SERVICE_NAME = "resource-explorer-2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "resource-explorer-2";

    /**
     * <p>
     * Sets the specified view as the default for the Amazon Web Services Region in which you call this operation. When
     * a user performs a <a>Search</a> that doesn't explicitly specify which view to use, then Amazon Web Services
     * Resource Explorer automatically chooses this default view for searches performed in this Amazon Web Services
     * Region.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     *
     * @param associateDefaultViewRequest
     * @return A Java Future containing the result of the AssociateDefaultView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.AssociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDefaultViewResponse> associateDefaultView(
            AssociateDefaultViewRequest associateDefaultViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified view as the default for the Amazon Web Services Region in which you call this operation. When
     * a user performs a <a>Search</a> that doesn't explicitly specify which view to use, then Amazon Web Services
     * Resource Explorer automatically chooses this default view for searches performed in this Amazon Web Services
     * Region.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDefaultViewRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDefaultViewRequest#builder()}
     * </p>
     *
     * @param associateDefaultViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateDefaultView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.AssociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDefaultViewResponse> associateDefaultView(
            Consumer<AssociateDefaultViewRequest.Builder> associateDefaultViewRequest) {
        return associateDefaultView(AssociateDefaultViewRequest.builder().applyMutation(associateDefaultViewRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a list of views.
     * </p>
     *
     * @param batchGetViewRequest
     * @return A Java Future containing the result of the BatchGetView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.BatchGetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetViewResponse> batchGetView(BatchGetViewRequest batchGetViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a list of views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetViewRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetViewRequest#builder()}
     * </p>
     *
     * @param batchGetViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.BatchGetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetViewResponse> batchGetView(Consumer<BatchGetViewRequest.Builder> batchGetViewRequest) {
        return batchGetView(BatchGetViewRequest.builder().applyMutation(batchGetViewRequest).build());
    }

    /**
     * <p>
     * Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this
     * operation by creating an index. Resource Explorer begins discovering the resources in this Region and stores the
     * details about the resources in the index so that they can be queried by using the <a>Search</a> operation. You
     * can create only one index in a Region.
     * </p>
     * <note>
     * <p>
     * This operation creates only a <i>local</i> index. To promote the local index in one Amazon Web Services Region
     * into the aggregator index for the Amazon Web Services account, use the <a>UpdateIndexType</a> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more details about what happens when you turn on Resource Explorer in an Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-service-activate.html">Turn on
     * Resource Explorer to index your resources in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * If this is the first Amazon Web Services Region in which you've created an index for Resource Explorer, then this
     * operation also <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >creates a service-linked role</a> in your Amazon Web Services account that allows Resource Explorer to enumerate
     * your resources to populate the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Action</b>: <code>resource-explorer-2:CreateIndex</code>
     * </p>
     * <p>
     * <b>Resource</b>: The ARN of the index (as it will exist after the operation completes) in the Amazon Web Services
     * Region and account in which you're trying to create the index. Use the wildcard character (<code>*</code>) at the
     * end of the string to match the eventual UUID. For example, the following <code>Resource</code> element restricts
     * the role or user to creating an index in only the <code>us-east-2</code> Region of the specified account.
     * </p>
     * <p>
     * <code>"Resource": "arn:aws:resource-explorer-2:us-west-2:<i>&lt;account-id&gt;</i>:index/*"</code>
     * </p>
     * <p>
     * Alternatively, you can use <code>"Resource": "*"</code> to allow the role or user to create an index in any
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Action</b>: <code>iam:CreateServiceLinkedRole</code>
     * </p>
     * <p>
     * <b>Resource</b>: No specific resource (*).
     * </p>
     * <p>
     * This permission is required only the first time you create an index to turn on Resource Explorer in the account.
     * Resource Explorer uses this to create the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >service-linked role needed to index the resources in your account</a>. Resource Explorer uses the same
     * service-linked role for all additional indexes you create afterwards.
     * </p>
     * </li>
     * </ul>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this
     * operation by creating an index. Resource Explorer begins discovering the resources in this Region and stores the
     * details about the resources in the index so that they can be queried by using the <a>Search</a> operation. You
     * can create only one index in a Region.
     * </p>
     * <note>
     * <p>
     * This operation creates only a <i>local</i> index. To promote the local index in one Amazon Web Services Region
     * into the aggregator index for the Amazon Web Services account, use the <a>UpdateIndexType</a> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more details about what happens when you turn on Resource Explorer in an Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-service-activate.html">Turn on
     * Resource Explorer to index your resources in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * If this is the first Amazon Web Services Region in which you've created an index for Resource Explorer, then this
     * operation also <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >creates a service-linked role</a> in your Amazon Web Services account that allows Resource Explorer to enumerate
     * your resources to populate the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Action</b>: <code>resource-explorer-2:CreateIndex</code>
     * </p>
     * <p>
     * <b>Resource</b>: The ARN of the index (as it will exist after the operation completes) in the Amazon Web Services
     * Region and account in which you're trying to create the index. Use the wildcard character (<code>*</code>) at the
     * end of the string to match the eventual UUID. For example, the following <code>Resource</code> element restricts
     * the role or user to creating an index in only the <code>us-east-2</code> Region of the specified account.
     * </p>
     * <p>
     * <code>"Resource": "arn:aws:resource-explorer-2:us-west-2:<i>&lt;account-id&gt;</i>:index/*"</code>
     * </p>
     * <p>
     * Alternatively, you can use <code>"Resource": "*"</code> to allow the role or user to create an index in any
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Action</b>: <code>iam:CreateServiceLinkedRole</code>
     * </p>
     * <p>
     * <b>Resource</b>: No specific resource (*).
     * </p>
     * <p>
     * This permission is required only the first time you create an index to turn on Resource Explorer in the account.
     * Resource Explorer uses this to create the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >service-linked role needed to index the resources in your account</a>. Resource Explorer uses the same
     * service-linked role for all additional indexes you create afterwards.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates a Resource Explorer setup configuration across multiple Amazon Web Services Regions. This operation sets
     * up indexes and views in the specified Regions. This operation can also be used to set an aggregator Region for
     * cross-Region resource search.
     * </p>
     *
     * @param createResourceExplorerSetupRequest
     * @return A Java Future containing the result of the CreateResourceExplorerSetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.CreateResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceExplorerSetupResponse> createResourceExplorerSetup(
            CreateResourceExplorerSetupRequest createResourceExplorerSetupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resource Explorer setup configuration across multiple Amazon Web Services Regions. This operation sets
     * up indexes and views in the specified Regions. This operation can also be used to set an aggregator Region for
     * cross-Region resource search.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceExplorerSetupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourceExplorerSetupRequest#builder()}
     * </p>
     *
     * @param createResourceExplorerSetupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.CreateResourceExplorerSetupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateResourceExplorerSetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.CreateResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceExplorerSetupResponse> createResourceExplorerSetup(
            Consumer<CreateResourceExplorerSetupRequest.Builder> createResourceExplorerSetupRequest) {
        return createResourceExplorerSetup(CreateResourceExplorerSetupRequest.builder()
                .applyMutation(createResourceExplorerSetupRequest).build());
    }

    /**
     * <p>
     * Creates a view that users can query by using the <a>Search</a> operation. Results from queries that you make
     * using this view include only resources that match the view's <code>Filters</code>. For more information about
     * Amazon Web Services Resource Explorer views, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html">Managing views</a> in the
     * <i>Amazon Web Services Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * Only the principals with an IAM identity-based policy that grants <code>Allow</code> to the <code>Search</code>
     * action on a <code>Resource</code> with the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name (ARN)</a>
     * of this view can <a>Search</a> using views you create with this operation.
     * </p>
     *
     * @param createViewRequest
     * @return A Java Future containing the result of the CreateView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ServiceQuotaExceededException The request failed because it exceeds a service quota.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateViewResponse> createView(CreateViewRequest createViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a view that users can query by using the <a>Search</a> operation. Results from queries that you make
     * using this view include only resources that match the view's <code>Filters</code>. For more information about
     * Amazon Web Services Resource Explorer views, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html">Managing views</a> in the
     * <i>Amazon Web Services Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * Only the principals with an IAM identity-based policy that grants <code>Allow</code> to the <code>Search</code>
     * action on a <code>Resource</code> with the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name (ARN)</a>
     * of this view can <a>Search</a> using views you create with this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateViewRequest.Builder} avoiding the need to
     * create one manually via {@link CreateViewRequest#builder()}
     * </p>
     *
     * @param createViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ServiceQuotaExceededException The request failed because it exceeds a service quota.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateViewResponse> createView(Consumer<CreateViewRequest.Builder> createViewRequest) {
        return createView(CreateViewRequest.builder().applyMutation(createViewRequest).build());
    }

    /**
     * <p>
     * Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web
     * Services Region. When you delete an index, Resource Explorer stops discovering and indexing resources in that
     * Region. Resource Explorer also deletes all views in that Region. These actions occur as asynchronous background
     * tasks. You can check to see when the actions are complete by using the <a>GetIndex</a> operation and checking the
     * <code>Status</code> response value.
     * </p>
     * <note>
     * <p>
     * If the index you delete is the aggregator index for the Amazon Web Services account, you must wait 24 hours
     * before you can promote another local index to be the aggregator index for the account. Users can't perform
     * account-wide searches using Resource Explorer until another aggregator index is configured.
     * </p>
     * </note>
     *
     * @param deleteIndexRequest
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web
     * Services Region. When you delete an index, Resource Explorer stops discovering and indexing resources in that
     * Region. Resource Explorer also deletes all views in that Region. These actions occur as asynchronous background
     * tasks. You can check to see when the actions are complete by using the <a>GetIndex</a> operation and checking the
     * <code>Status</code> response value.
     * </p>
     * <note>
     * <p>
     * If the index you delete is the aggregator index for the Amazon Web Services account, you must wait 24 hours
     * before you can promote another local index to be the aggregator index for the account. Users can't perform
     * account-wide searches using Resource Explorer until another aggregator index is configured.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes a Resource Explorer setup configuration. This operation removes indexes and views from the specified
     * Regions or all Regions where Resource Explorer is configured.
     * </p>
     *
     * @param deleteResourceExplorerSetupRequest
     * @return A Java Future containing the result of the DeleteResourceExplorerSetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DeleteResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceExplorerSetupResponse> deleteResourceExplorerSetup(
            DeleteResourceExplorerSetupRequest deleteResourceExplorerSetupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resource Explorer setup configuration. This operation removes indexes and views from the specified
     * Regions or all Regions where Resource Explorer is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceExplorerSetupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourceExplorerSetupRequest#builder()}
     * </p>
     *
     * @param deleteResourceExplorerSetupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DeleteResourceExplorerSetupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteResourceExplorerSetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DeleteResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceExplorerSetupResponse> deleteResourceExplorerSetup(
            Consumer<DeleteResourceExplorerSetupRequest.Builder> deleteResourceExplorerSetupRequest) {
        return deleteResourceExplorerSetup(DeleteResourceExplorerSetupRequest.builder()
                .applyMutation(deleteResourceExplorerSetupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified view.
     * </p>
     * <p>
     * If the specified view is the default view for its Amazon Web Services Region, then all <a>Search</a> operations
     * in that Region must explicitly specify the view to use until you configure a new default by calling the
     * <a>AssociateDefaultView</a> operation.
     * </p>
     *
     * @param deleteViewRequest
     * @return A Java Future containing the result of the DeleteView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteViewResponse> deleteView(DeleteViewRequest deleteViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified view.
     * </p>
     * <p>
     * If the specified view is the default view for its Amazon Web Services Region, then all <a>Search</a> operations
     * in that Region must explicitly specify the view to use until you configure a new default by calling the
     * <a>AssociateDefaultView</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteViewRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteViewRequest#builder()}
     * </p>
     *
     * @param deleteViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteViewResponse> deleteView(Consumer<DeleteViewRequest.Builder> deleteViewRequest) {
        return deleteView(DeleteViewRequest.builder().applyMutation(deleteViewRequest).build());
    }

    /**
     * <p>
     * After you call this operation, the affected Amazon Web Services Region no longer has a default view. All
     * <a>Search</a> operations in that Region must explicitly specify a view or the operation fails. You can configure
     * a new default by calling the <a>AssociateDefaultView</a> operation.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     *
     * @param disassociateDefaultViewRequest
     * @return A Java Future containing the result of the DisassociateDefaultView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DisassociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDefaultViewResponse> disassociateDefaultView(
            DisassociateDefaultViewRequest disassociateDefaultViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * After you call this operation, the affected Amazon Web Services Region no longer has a default view. All
     * <a>Search</a> operations in that Region must explicitly specify a view or the operation fails. You can configure
     * a new default by calling the <a>AssociateDefaultView</a> operation.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDefaultViewRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDefaultViewRequest#builder()}
     * </p>
     *
     * @param disassociateDefaultViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateDefaultView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.DisassociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDefaultViewResponse> disassociateDefaultView(
            Consumer<DisassociateDefaultViewRequest.Builder> disassociateDefaultViewRequest) {
        return disassociateDefaultView(DisassociateDefaultViewRequest.builder().applyMutation(disassociateDefaultViewRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the status of your account's Amazon Web Services service access, and validates the service linked role
     * required to access the multi-account search feature. Only the management account can invoke this API call.
     * </p>
     *
     * @param getAccountLevelServiceConfigurationRequest
     * @return A Java Future containing the result of the GetAccountLevelServiceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetAccountLevelServiceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetAccountLevelServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountLevelServiceConfigurationResponse> getAccountLevelServiceConfiguration(
            GetAccountLevelServiceConfigurationRequest getAccountLevelServiceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of your account's Amazon Web Services service access, and validates the service linked role
     * required to access the multi-account search feature. Only the management account can invoke this API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountLevelServiceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetAccountLevelServiceConfigurationRequest#builder()}
     * </p>
     *
     * @param getAccountLevelServiceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAccountLevelServiceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetAccountLevelServiceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetAccountLevelServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountLevelServiceConfigurationResponse> getAccountLevelServiceConfiguration(
            Consumer<GetAccountLevelServiceConfigurationRequest.Builder> getAccountLevelServiceConfigurationRequest) {
        return getAccountLevelServiceConfiguration(GetAccountLevelServiceConfigurationRequest.builder()
                .applyMutation(getAccountLevelServiceConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in
     * which you call this operation. You can then call <a>GetView</a> to retrieve the details of that view.
     * </p>
     *
     * @param getDefaultViewRequest
     * @return A Java Future containing the result of the GetDefaultView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDefaultViewResponse> getDefaultView(GetDefaultViewRequest getDefaultViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in
     * which you call this operation. You can then call <a>GetView</a> to retrieve the details of that view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetDefaultViewRequest#builder()}
     * </p>
     *
     * @param getDefaultViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDefaultView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDefaultViewResponse> getDefaultView(Consumer<GetDefaultViewRequest.Builder> getDefaultViewRequest) {
        return getDefaultView(GetDefaultViewRequest.builder().applyMutation(getDefaultViewRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in
     * which you invoked the operation.
     * </p>
     *
     * @param getIndexRequest
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIndexResponse> getIndex(GetIndexRequest getIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in
     * which you invoked the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIndexResponse> getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * Retrieves details of the specified <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Amazon Web
     * Services-managed view</a>.
     * </p>
     *
     * @param getManagedViewRequest
     * @return A Java Future containing the result of the GetManagedView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetManagedView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetManagedView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedViewResponse> getManagedView(GetManagedViewRequest getManagedViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of the specified <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Amazon Web
     * Services-managed view</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetManagedViewRequest#builder()}
     * </p>
     *
     * @param getManagedViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetManagedViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetManagedView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetManagedView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetManagedView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedViewResponse> getManagedView(Consumer<GetManagedViewRequest.Builder> getManagedViewRequest) {
        return getManagedView(GetManagedViewRequest.builder().applyMutation(getManagedViewRequest).build());
    }

    /**
     * <p>
     * Retrieves the status and details of a Resource Explorer setup operation. This operation returns information about
     * the progress of creating or deleting Resource Explorer configurations across Regions.
     * </p>
     *
     * @param getResourceExplorerSetupRequest
     * @return A Java Future containing the result of the GetResourceExplorerSetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceExplorerSetupResponse> getResourceExplorerSetup(
            GetResourceExplorerSetupRequest getResourceExplorerSetupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status and details of a Resource Explorer setup operation. This operation returns information about
     * the progress of creating or deleting Resource Explorer configurations across Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceExplorerSetupRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceExplorerSetupRequest#builder()}
     * </p>
     *
     * @param getResourceExplorerSetupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourceExplorerSetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceExplorerSetupResponse> getResourceExplorerSetup(
            Consumer<GetResourceExplorerSetupRequest.Builder> getResourceExplorerSetupRequest) {
        return getResourceExplorerSetup(GetResourceExplorerSetupRequest.builder().applyMutation(getResourceExplorerSetupRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourceExplorerSetup(software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.GetResourceExplorerSetupPublisher publisher = client.getResourceExplorerSetupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.GetResourceExplorerSetupPublisher publisher = client.getResourceExplorerSetupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceExplorerSetup(software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceExplorerSetupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceExplorerSetupPublisher getResourceExplorerSetupPaginator(
            GetResourceExplorerSetupRequest getResourceExplorerSetupRequest) {
        return new GetResourceExplorerSetupPublisher(this, getResourceExplorerSetupRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourceExplorerSetup(software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.GetResourceExplorerSetupPublisher publisher = client.getResourceExplorerSetupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.GetResourceExplorerSetupPublisher publisher = client.getResourceExplorerSetupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceExplorerSetup(software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceExplorerSetupRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceExplorerSetupRequest#builder()}
     * </p>
     *
     * @param getResourceExplorerSetupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetResourceExplorerSetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetResourceExplorerSetup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceExplorerSetupPublisher getResourceExplorerSetupPaginator(
            Consumer<GetResourceExplorerSetupRequest.Builder> getResourceExplorerSetupRequest) {
        return getResourceExplorerSetupPaginator(GetResourceExplorerSetupRequest.builder()
                .applyMutation(getResourceExplorerSetupRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Resource Explorer index in the current Amazon Web Services Region. This operation
     * returns the ARN and type of the index if one exists.
     * </p>
     *
     * @param getServiceIndexRequest
     * @return A Java Future containing the result of the GetServiceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetServiceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetServiceIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceIndexResponse> getServiceIndex(GetServiceIndexRequest getServiceIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Resource Explorer index in the current Amazon Web Services Region. This operation
     * returns the ARN and type of the index if one exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceIndexRequest#builder()}
     * </p>
     *
     * @param getServiceIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetServiceIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetServiceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetServiceIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceIndexResponse> getServiceIndex(
            Consumer<GetServiceIndexRequest.Builder> getServiceIndexRequest) {
        return getServiceIndex(GetServiceIndexRequest.builder().applyMutation(getServiceIndexRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific Resource Explorer service view. This operation returns the configuration and
     * properties of the specified view.
     * </p>
     *
     * @param getServiceViewRequest
     * @return A Java Future containing the result of the GetServiceView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetServiceView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetServiceView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceViewResponse> getServiceView(GetServiceViewRequest getServiceViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific Resource Explorer service view. This operation returns the configuration and
     * properties of the specified view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetServiceViewRequest#builder()}
     * </p>
     *
     * @param getServiceViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetServiceViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetServiceView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetServiceView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceViewResponse> getServiceView(Consumer<GetServiceViewRequest.Builder> getServiceViewRequest) {
        return getServiceView(GetServiceViewRequest.builder().applyMutation(getServiceViewRequest).build());
    }

    /**
     * <p>
     * Retrieves details of the specified view.
     * </p>
     *
     * @param getViewRequest
     * @return A Java Future containing the result of the GetView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetViewResponse> getView(GetViewRequest getViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of the specified view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetViewRequest.Builder} avoiding the need to create
     * one manually via {@link GetViewRequest#builder()}
     * </p>
     *
     * @param getViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.GetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetViewResponse> getView(Consumer<GetViewRequest.Builder> getViewRequest) {
        return getView(GetViewRequest.builder().applyMutation(getViewRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     *
     * @param listIndexesRequest
     * @return A Java Future containing the result of the ListIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIndexesResponse> listIndexes(ListIndexesRequest listIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIndexesResponse> listIndexes(Consumer<ListIndexesRequest.Builder> listIndexesRequest) {
        return listIndexes(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of a member's indexes in all Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer. Only the management account or a delegated administrator
     * with service access enabled can invoke this API call.
     * </p>
     *
     * @param listIndexesForMembersRequest
     * @return A Java Future containing the result of the ListIndexesForMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexesForMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIndexesForMembersResponse> listIndexesForMembers(
            ListIndexesForMembersRequest listIndexesForMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of a member's indexes in all Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer. Only the management account or a delegated administrator
     * with service access enabled can invoke this API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesForMembersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIndexesForMembersRequest#builder()}
     * </p>
     *
     * @param listIndexesForMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListIndexesForMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexesForMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIndexesForMembersResponse> listIndexesForMembers(
            Consumer<ListIndexesForMembersRequest.Builder> listIndexesForMembersRequest) {
        return listIndexesForMembers(ListIndexesForMembersRequest.builder().applyMutation(listIndexesForMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIndexesForMembers(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesForMembersPublisher publisher = client.listIndexesForMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesForMembersPublisher publisher = client.listIndexesForMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexesForMembers(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIndexesForMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexesForMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesForMembersPublisher listIndexesForMembersPaginator(
            ListIndexesForMembersRequest listIndexesForMembersRequest) {
        return new ListIndexesForMembersPublisher(this, listIndexesForMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIndexesForMembers(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesForMembersPublisher publisher = client.listIndexesForMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesForMembersPublisher publisher = client.listIndexesForMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexesForMembers(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesForMembersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIndexesForMembersRequest#builder()}
     * </p>
     *
     * @param listIndexesForMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexesForMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesForMembersPublisher listIndexesForMembersPaginator(
            Consumer<ListIndexesForMembersRequest.Builder> listIndexesForMembersRequest) {
        return listIndexesForMembersPaginator(ListIndexesForMembersRequest.builder().applyMutation(listIndexesForMembersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation.</b>
     * </p>
     *
     * @param listIndexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesPublisher listIndexesPaginator(ListIndexesRequest listIndexesRequest) {
        return new ListIndexesPublisher(this, listIndexesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesPublisher listIndexesPaginator(Consumer<ListIndexesRequest.Builder> listIndexesRequest) {
        return listIndexesPaginator(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon resource names (ARNs) of the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Amazon Web
     * Services-managed views</a> available in the Amazon Web Services Region in which you call this operation.
     * </p>
     *
     * @param listManagedViewsRequest
     * @return A Java Future containing the result of the ListManagedViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListManagedViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListManagedViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedViewsResponse> listManagedViews(ListManagedViewsRequest listManagedViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon resource names (ARNs) of the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Amazon Web
     * Services-managed views</a> available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListManagedViewsRequest#builder()}
     * </p>
     *
     * @param listManagedViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListManagedViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListManagedViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListManagedViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedViewsResponse> listManagedViews(
            Consumer<ListManagedViewsRequest.Builder> listManagedViewsRequest) {
        return listManagedViews(ListManagedViewsRequest.builder().applyMutation(listManagedViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedViews(software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListManagedViewsPublisher publisher = client.listManagedViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListManagedViewsPublisher publisher = client.listManagedViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedViews(software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedViewsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListManagedViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListManagedViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedViewsPublisher listManagedViewsPaginator(ListManagedViewsRequest listManagedViewsRequest) {
        return new ListManagedViewsPublisher(this, listManagedViewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedViews(software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListManagedViewsPublisher publisher = client.listManagedViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListManagedViewsPublisher publisher = client.listManagedViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedViews(software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListManagedViewsRequest#builder()}
     * </p>
     *
     * @param listManagedViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListManagedViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListManagedViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedViewsPublisher listManagedViewsPaginator(Consumer<ListManagedViewsRequest.Builder> listManagedViewsRequest) {
        return listManagedViewsPaginator(ListManagedViewsRequest.builder().applyMutation(listManagedViewsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources and their details that match the specified criteria. This query must use a view. If
     * you don’t explicitly specify a view, then Resource Explorer uses the default view for the Amazon Web Services
     * Region in which you call this operation.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources and their details that match the specified criteria. This query must use a view. If
     * you don’t explicitly specify a view, then Resource Explorer uses the default view for the Amazon Web Services
     * Region in which you call this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResources(software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(ListResourcesRequest listResourcesRequest) {
        return new ListResourcesPublisher(this, listResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResources(software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all Resource Explorer indexes across the specified Amazon Web Services Regions. This operation returns
     * information about indexes including their ARNs, types, and Regions.
     * </p>
     *
     * @param listServiceIndexesRequest
     * @return A Java Future containing the result of the ListServiceIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceIndexesResponse> listServiceIndexes(ListServiceIndexesRequest listServiceIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Resource Explorer indexes across the specified Amazon Web Services Regions. This operation returns
     * information about indexes including their ARNs, types, and Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceIndexesRequest#builder()}
     * </p>
     *
     * @param listServiceIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListServiceIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceIndexesResponse> listServiceIndexes(
            Consumer<ListServiceIndexesRequest.Builder> listServiceIndexesRequest) {
        return listServiceIndexes(ListServiceIndexesRequest.builder().applyMutation(listServiceIndexesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceIndexesPublisher publisher = client.listServiceIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceIndexesPublisher publisher = client.listServiceIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceIndexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceIndexesPublisher listServiceIndexesPaginator(ListServiceIndexesRequest listServiceIndexesRequest) {
        return new ListServiceIndexesPublisher(this, listServiceIndexesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceIndexesPublisher publisher = client.listServiceIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceIndexesPublisher publisher = client.listServiceIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceIndexesRequest#builder()}
     * </p>
     *
     * @param listServiceIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceIndexesPublisher listServiceIndexesPaginator(
            Consumer<ListServiceIndexesRequest.Builder> listServiceIndexesRequest) {
        return listServiceIndexesPaginator(ListServiceIndexesRequest.builder().applyMutation(listServiceIndexesRequest).build());
    }

    /**
     * <p>
     * Lists all Resource Explorer service views available in the current Amazon Web Services account. This operation
     * returns the ARNs of available service views.
     * </p>
     *
     * @param listServiceViewsRequest
     * @return A Java Future containing the result of the ListServiceViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceViewsResponse> listServiceViews(ListServiceViewsRequest listServiceViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Resource Explorer service views available in the current Amazon Web Services account. This operation
     * returns the ARNs of available service views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceViewsRequest#builder()}
     * </p>
     *
     * @param listServiceViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListServiceViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceViewsResponse> listServiceViews(
            Consumer<ListServiceViewsRequest.Builder> listServiceViewsRequest) {
        return listServiceViews(ListServiceViewsRequest.builder().applyMutation(listServiceViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceViews(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceViewsPublisher publisher = client.listServiceViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceViewsPublisher publisher = client.listServiceViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceViews(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceViewsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceViewsPublisher listServiceViewsPaginator(ListServiceViewsRequest listServiceViewsRequest) {
        return new ListServiceViewsPublisher(this, listServiceViewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceViews(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceViewsPublisher publisher = client.listServiceViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListServiceViewsPublisher publisher = client.listServiceViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceViews(software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceViewsRequest#builder()}
     * </p>
     *
     * @param listServiceViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListServiceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListServiceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceViewsPublisher listServiceViewsPaginator(Consumer<ListServiceViewsRequest.Builder> listServiceViewsRequest) {
        return listServiceViewsPaginator(ListServiceViewsRequest.builder().applyMutation(listServiceViewsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Web Services services that have been granted streaming access to your Resource Explorer
     * data. Streaming access allows Amazon Web Services services to receive real-time updates about your resources as
     * they are indexed by Resource Explorer.
     * </p>
     *
     * @param listStreamingAccessForServicesRequest
     * @return A Java Future containing the result of the ListStreamingAccessForServices operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListStreamingAccessForServices
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListStreamingAccessForServices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingAccessForServicesResponse> listStreamingAccessForServices(
            ListStreamingAccessForServicesRequest listStreamingAccessForServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Web Services services that have been granted streaming access to your Resource Explorer
     * data. Streaming access allows Amazon Web Services services to receive real-time updates about your resources as
     * they are indexed by Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingAccessForServicesRequest.Builder}
     * avoiding the need to create one manually via {@link ListStreamingAccessForServicesRequest#builder()}
     * </p>
     *
     * @param listStreamingAccessForServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListStreamingAccessForServices operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListStreamingAccessForServices
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListStreamingAccessForServices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingAccessForServicesResponse> listStreamingAccessForServices(
            Consumer<ListStreamingAccessForServicesRequest.Builder> listStreamingAccessForServicesRequest) {
        return listStreamingAccessForServices(ListStreamingAccessForServicesRequest.builder()
                .applyMutation(listStreamingAccessForServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamingAccessForServices(software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListStreamingAccessForServicesPublisher publisher = client.listStreamingAccessForServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListStreamingAccessForServicesPublisher publisher = client.listStreamingAccessForServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingAccessForServices(software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamingAccessForServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListStreamingAccessForServices
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListStreamingAccessForServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingAccessForServicesPublisher listStreamingAccessForServicesPaginator(
            ListStreamingAccessForServicesRequest listStreamingAccessForServicesRequest) {
        return new ListStreamingAccessForServicesPublisher(this, listStreamingAccessForServicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamingAccessForServices(software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListStreamingAccessForServicesPublisher publisher = client.listStreamingAccessForServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListStreamingAccessForServicesPublisher publisher = client.listStreamingAccessForServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingAccessForServices(software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingAccessForServicesRequest.Builder}
     * avoiding the need to create one manually via {@link ListStreamingAccessForServicesRequest#builder()}
     * </p>
     *
     * @param listStreamingAccessForServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListStreamingAccessForServices
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListStreamingAccessForServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingAccessForServicesPublisher listStreamingAccessForServicesPaginator(
            Consumer<ListStreamingAccessForServicesRequest.Builder> listStreamingAccessForServicesRequest) {
        return listStreamingAccessForServicesPaginator(ListStreamingAccessForServicesRequest.builder()
                .applyMutation(listStreamingAccessForServicesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     * @return A Java Future containing the result of the ListSupportedResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSupportedResourceTypesResponse> listSupportedResourceTypes(
            ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListSupportedResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSupportedResourceTypesResponse> listSupportedResourceTypes(
            Consumer<ListSupportedResourceTypesRequest.Builder> listSupportedResourceTypesRequest) {
        return listSupportedResourceTypes(ListSupportedResourceTypesRequest.builder()
                .applyMutation(listSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesPublisher publisher = client.listSupportedResourceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesPublisher publisher = client.listSupportedResourceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupportedResourceTypesPublisher listSupportedResourceTypesPaginator(
            ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) {
        return new ListSupportedResourceTypesPublisher(this, listSupportedResourceTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesPublisher publisher = client.listSupportedResourceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesPublisher publisher = client.listSupportedResourceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupportedResourceTypesPublisher listSupportedResourceTypesPaginator(
            Consumer<ListSupportedResourceTypesRequest.Builder> listSupportedResourceTypesRequest) {
        return listSupportedResourceTypesPaginator(ListSupportedResourceTypesRequest.builder()
                .applyMutation(listSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note>
     *
     * @param listViewsRequest
     * @return A Java Future containing the result of the ListViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListViewsResponse> listViews(ListViewsRequest listViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListViewsRequest#builder()}
     * </p>
     *
     * @param listViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListViewsResponse> listViews(Consumer<ListViewsRequest.Builder> listViewsRequest) {
        return listViews(ListViewsRequest.builder().applyMutation(listViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsPublisher publisher = client.listViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsPublisher publisher = client.listViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)} operation.</b>
     * </p>
     *
     * @param listViewsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default ListViewsPublisher listViewsPaginator(ListViewsRequest listViewsRequest) {
        return new ListViewsPublisher(this, listViewsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsPublisher publisher = client.listViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsPublisher publisher = client.listViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListViewsRequest#builder()}
     * </p>
     *
     * @param listViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default ListViewsPublisher listViewsPaginator(Consumer<ListViewsRequest.Builder> listViewsRequest) {
        return listViewsPaginator(ListViewsRequest.builder().applyMutation(listViewsRequest).build());
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     *
     * @param searchRequest
     * @return A Java Future containing the result of the Search operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchResponse> search(SearchRequest searchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Search operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchResponse> search(Consumer<SearchRequest.Builder> searchRequest) {
        return search(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)} operation.</b>
     * </p>
     *
     * @param searchRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchPublisher searchPaginator(SearchRequest searchRequest) {
        return new SearchPublisher(this, searchRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchPublisher searchPaginator(Consumer<SearchRequest.Builder> searchRequest) {
        return searchPaginator(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the type of the index from one of the following types to the other. For more information about indexes
     * and the role they perform in Amazon Web Services Resource Explorer, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>AGGREGATOR</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources from all Amazon Web Services Regions in the Amazon Web Services
     * account in which you've created a Resource Explorer index. Resource information from all other Regions is
     * replicated to this Region's index.
     * </p>
     * <p>
     * When you change the index type to <code>AGGREGATOR</code>, Resource Explorer turns on replication of all
     * discovered resource information from the other Amazon Web Services Regions in your account to this index. You can
     * then, from this Region only, perform resource search queries that span all Amazon Web Services Regions in the
     * Amazon Web Services account. Turning on replication from all other Regions is performed by asynchronous
     * background tasks. You can check the status of the asynchronous tasks by using the <a>GetIndex</a> operation. When
     * the asynchronous tasks complete, the <code>Status</code> response of that operation changes from
     * <code>UPDATING</code> to <code>ACTIVE</code>. After that, you can start to see results from other Amazon Web
     * Services Regions in query results. However, it can take several hours for replication from all other Regions to
     * complete.
     * </p>
     * <important>
     * <p>
     * You can have only one aggregator index per Amazon Web Services account. Before you can promote a different index
     * to be the aggregator index for the account, you must first demote the existing aggregator index to type
     * <code>LOCAL</code>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b> <code>LOCAL</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources in only the Amazon Web Services Region in which the index exists.
     * If an aggregator index in another Region exists, then information in this local index is replicated to the
     * aggregator index.
     * </p>
     * <p>
     * When you change the index type to <code>LOCAL</code>, Resource Explorer turns off the replication of resource
     * information from all other Amazon Web Services Regions in the Amazon Web Services account to this Region. The
     * aggregator index remains in the <code>UPDATING</code> state until all replication with other Regions successfully
     * stops. You can check the status of the asynchronous task by using the <a>GetIndex</a> operation. When Resource
     * Explorer successfully stops all replication with other Regions, the <code>Status</code> response of that
     * operation changes from <code>UPDATING</code> to <code>ACTIVE</code>. Separately, the resource information from
     * other Regions that was previously stored in the index is deleted within 30 days by another background task. Until
     * that asynchronous task completes, some results from other Regions can continue to appear in search results.
     * </p>
     * <important>
     * <p>
     * After you demote an aggregator index to a local index, you must wait 24 hours before you can promote another
     * index to be the new aggregator index for the account.
     * </p>
     * </important></li>
     * </ul>
     *
     * @param updateIndexTypeRequest
     * @return A Java Future containing the result of the UpdateIndexType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ServiceQuotaExceededException The request failed because it exceeds a service quota.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.UpdateIndexType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIndexTypeResponse> updateIndexType(UpdateIndexTypeRequest updateIndexTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the type of the index from one of the following types to the other. For more information about indexes
     * and the role they perform in Amazon Web Services Resource Explorer, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>AGGREGATOR</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources from all Amazon Web Services Regions in the Amazon Web Services
     * account in which you've created a Resource Explorer index. Resource information from all other Regions is
     * replicated to this Region's index.
     * </p>
     * <p>
     * When you change the index type to <code>AGGREGATOR</code>, Resource Explorer turns on replication of all
     * discovered resource information from the other Amazon Web Services Regions in your account to this index. You can
     * then, from this Region only, perform resource search queries that span all Amazon Web Services Regions in the
     * Amazon Web Services account. Turning on replication from all other Regions is performed by asynchronous
     * background tasks. You can check the status of the asynchronous tasks by using the <a>GetIndex</a> operation. When
     * the asynchronous tasks complete, the <code>Status</code> response of that operation changes from
     * <code>UPDATING</code> to <code>ACTIVE</code>. After that, you can start to see results from other Amazon Web
     * Services Regions in query results. However, it can take several hours for replication from all other Regions to
     * complete.
     * </p>
     * <important>
     * <p>
     * You can have only one aggregator index per Amazon Web Services account. Before you can promote a different index
     * to be the aggregator index for the account, you must first demote the existing aggregator index to type
     * <code>LOCAL</code>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b> <code>LOCAL</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources in only the Amazon Web Services Region in which the index exists.
     * If an aggregator index in another Region exists, then information in this local index is replicated to the
     * aggregator index.
     * </p>
     * <p>
     * When you change the index type to <code>LOCAL</code>, Resource Explorer turns off the replication of resource
     * information from all other Amazon Web Services Regions in the Amazon Web Services account to this Region. The
     * aggregator index remains in the <code>UPDATING</code> state until all replication with other Regions successfully
     * stops. You can check the status of the asynchronous task by using the <a>GetIndex</a> operation. When Resource
     * Explorer successfully stops all replication with other Regions, the <code>Status</code> response of that
     * operation changes from <code>UPDATING</code> to <code>ACTIVE</code>. Separately, the resource information from
     * other Regions that was previously stored in the index is deleted within 30 days by another background task. Until
     * that asynchronous task completes, some results from other Regions can continue to appear in search results.
     * </p>
     * <important>
     * <p>
     * After you demote an aggregator index to a local index, you must wait 24 hours before you can promote another
     * index to be the new aggregator index for the account.
     * </p>
     * </important></li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexTypeRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateIndexTypeRequest#builder()}
     * </p>
     *
     * @param updateIndexTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateIndexType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException You specified a resource that doesn't exist. Check the ID or ARN that you
     *         used to identity the resource, and try again.</li>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ConflictException If you attempted to create a view, then the request failed because either you
     *         specified parameters that didn’t match the original request, or you attempted to create a view with a
     *         name that already exists in this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.</li>
     *         <li>ServiceQuotaExceededException The request failed because it exceeds a service quota.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.UpdateIndexType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIndexTypeResponse> updateIndexType(
            Consumer<UpdateIndexTypeRequest.Builder> updateIndexTypeRequest) {
        return updateIndexType(UpdateIndexTypeRequest.builder().applyMutation(updateIndexTypeRequest).build());
    }

    /**
     * <p>
     * Modifies some of the details of a view. You can change the filter string and the list of included properties. You
     * can't change the name of the view.
     * </p>
     *
     * @param updateViewRequest
     * @return A Java Future containing the result of the UpdateView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ServiceQuotaExceededException The request failed because it exceeds a service quota.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.UpdateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateViewResponse> updateView(UpdateViewRequest updateViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some of the details of a view. You can change the filter string and the list of included properties. You
     * can't change the name of the view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateViewRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateViewRequest#builder()}
     * </p>
     *
     * @param updateViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request failed because of internal service error. Try your request again
     *         later.</li>
     *         <li>ValidationException You provided an invalid value for one of the operation's parameters. Check the
     *         syntax for the operation, and try again.</li>
     *         <li>ServiceQuotaExceededException The request failed because it exceeds a service quota.</li>
     *         <li>UnauthorizedException The principal making the request isn't permitted to perform the operation.</li>
     *         <li>ThrottlingException The request failed because you exceeded a rate limit for this operation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.</li>
     *         <li>AccessDeniedException The credentials that you used to call this operation don't have the minimum
     *         required permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceExplorer2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ResourceExplorer2AsyncClient.UpdateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateViewResponse> updateView(Consumer<UpdateViewRequest.Builder> updateViewRequest) {
        return updateView(UpdateViewRequest.builder().applyMutation(updateViewRequest).build());
    }

    @Override
    default ResourceExplorer2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ResourceExplorer2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ResourceExplorer2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ResourceExplorer2AsyncClient}.
     */
    static ResourceExplorer2AsyncClientBuilder builder() {
        return new DefaultResourceExplorer2AsyncClientBuilder();
    }
}
