/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.release;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import software.amazon.awssdk.release.Cli;
import software.amazon.awssdk.release.PomTransformer;
import software.amazon.awssdk.utils.Validate;

public class FinalizeNewServiceModuleMain
extends Cli {
    private FinalizeNewServiceModuleMain() {
        super(FinalizeNewServiceModuleMain.requiredOption("service-module-names", "A comma-separated list containing the name of the service modules to be created."), FinalizeNewServiceModuleMain.requiredOption("maven-project-root", "The root directory for the maven project."));
    }

    public static void main(String[] args) {
        new FinalizeNewServiceModuleMain().run(args);
    }

    @Override
    protected void run(CommandLine commandLine) throws Exception {
        new NewServiceCreator(commandLine).run();
    }

    private static class NewServiceCreator {
        private final Path mavenProjectRoot;
        private final List<String> serviceModuleNames;

        private NewServiceCreator(CommandLine commandLine) {
            this.mavenProjectRoot = Paths.get(commandLine.getOptionValue("maven-project-root").trim(), new String[0]);
            this.serviceModuleNames = Stream.of(commandLine.getOptionValue("service-module-names").split(",")).map(String::trim).collect(Collectors.toList());
            Validate.isTrue((boolean)Files.exists(this.mavenProjectRoot, new LinkOption[0]), (String)("Project root does not exist: " + this.mavenProjectRoot), (Object[])new Object[0]);
        }

        public void run() throws Exception {
            for (String serviceModuleName : this.serviceModuleNames) {
                Path servicesPomPath = this.mavenProjectRoot.resolve("services").resolve("pom.xml");
                Path aggregatePomPath = this.mavenProjectRoot.resolve("aws-sdk-java").resolve("pom.xml");
                Path bomPomPath = this.mavenProjectRoot.resolve("bom").resolve("pom.xml");
                new AddSubmoduleTransformer(serviceModuleName).transform(servicesPomPath);
                new AddDependencyTransformer(serviceModuleName).transform(aggregatePomPath);
                new AddDependencyManagementDependencyTransformer(serviceModuleName).transform(bomPomPath);
            }
        }

        private static class AddDependencyManagementDependencyTransformer
        extends PomTransformer {
            private final String serviceModuleName;

            private AddDependencyManagementDependencyTransformer(String serviceModuleName) {
                this.serviceModuleName = serviceModuleName;
            }

            @Override
            protected void updateDocument(Document doc) {
                Node project = this.findChild(doc, "project");
                Node dependencyManagement = this.findChild(project, "dependencyManagement");
                Node dependencies = this.findChild(dependencyManagement, "dependencies");
                this.addChild(dependencies, this.sdkDependencyElement(doc, this.serviceModuleName));
            }
        }

        private static class AddDependencyTransformer
        extends PomTransformer {
            private final String serviceModuleName;

            private AddDependencyTransformer(String serviceModuleName) {
                this.serviceModuleName = serviceModuleName;
            }

            @Override
            protected void updateDocument(Document doc) {
                Node project = this.findChild(doc, "project");
                Node dependencies = this.findChild(project, "dependencies");
                this.addChild(dependencies, this.sdkDependencyElement(doc, this.serviceModuleName));
            }
        }

        private static class AddSubmoduleTransformer
        extends PomTransformer {
            private final String serviceModuleName;

            private AddSubmoduleTransformer(String serviceModuleName) {
                this.serviceModuleName = serviceModuleName;
            }

            @Override
            protected void updateDocument(Document doc) {
                Node project = this.findChild(doc, "project");
                Node modules = this.findChild(project, "modules");
                this.addChild(modules, this.textElement(doc, "module", this.serviceModuleName));
            }
        }
    }
}

