/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetChanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetChanges> {
    private static final SdkField<SdkBytes> GROUND_TRUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("GroundTruth").getter(DatasetChanges.getter(DatasetChanges::groundTruth)).setter(DatasetChanges.setter(Builder::groundTruth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_TRUTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetChanges.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes groundTruth;

    private DatasetChanges(BuilderImpl builder) {
        this.groundTruth = builder.groundTruth;
    }

    public final SdkBytes groundTruth() {
        return this.groundTruth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groundTruth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetChanges)) {
            return false;
        }
        DatasetChanges other = (DatasetChanges)obj;
        return Objects.equals(this.groundTruth(), other.groundTruth());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetChanges").add("GroundTruth", (Object)this.groundTruth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroundTruth": {
                return Optional.ofNullable(clazz.cast(this.groundTruth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkBytes>> map = new HashMap<String, SdkField<SdkBytes>>();
        map.put("GroundTruth", GROUND_TRUTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetChanges, T> g) {
        return obj -> g.apply((DatasetChanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes groundTruth;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetChanges model) {
            this.groundTruth(model.groundTruth);
        }

        public final ByteBuffer getGroundTruth() {
            return this.groundTruth == null ? null : this.groundTruth.asByteBuffer();
        }

        public final void setGroundTruth(ByteBuffer groundTruth) {
            this.groundTruth(groundTruth == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)groundTruth));
        }

        @Override
        public final Builder groundTruth(SdkBytes groundTruth) {
            this.groundTruth = groundTruth;
            return this;
        }

        public DatasetChanges build() {
            return new DatasetChanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetChanges> {
        public Builder groundTruth(SdkBytes var1);
    }
}

