/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A track that you can switch the current track to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTarget implements SdkPojo, Serializable, ToCopyableBuilder<UpdateTarget.Builder, UpdateTarget> {
    private static final SdkField<String> TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackName").getter(getter(UpdateTarget::trackName)).setter(setter(Builder::trackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackName").build()).build();

    private static final SdkField<String> WORKGROUP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupVersion").getter(getter(UpdateTarget::workgroupVersion))
            .setter(setter(Builder::workgroupVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACK_NAME_FIELD,
            WORKGROUP_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trackName;

    private final String workgroupVersion;

    private UpdateTarget(BuilderImpl builder) {
        this.trackName = builder.trackName;
        this.workgroupVersion = builder.workgroupVersion;
    }

    /**
     * <p>
     * The name of the new track.
     * </p>
     * 
     * @return The name of the new track.
     */
    public final String trackName() {
        return trackName;
    }

    /**
     * <p>
     * The workgroup version for the new track.
     * </p>
     * 
     * @return The workgroup version for the new track.
     */
    public final String workgroupVersion() {
        return workgroupVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trackName());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTarget)) {
            return false;
        }
        UpdateTarget other = (UpdateTarget) obj;
        return Objects.equals(trackName(), other.trackName()) && Objects.equals(workgroupVersion(), other.workgroupVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTarget").add("TrackName", trackName()).add("WorkgroupVersion", workgroupVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trackName":
            return Optional.ofNullable(clazz.cast(trackName()));
        case "workgroupVersion":
            return Optional.ofNullable(clazz.cast(workgroupVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trackName", TRACK_NAME_FIELD);
        map.put("workgroupVersion", WORKGROUP_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTarget, T> g) {
        return obj -> g.apply((UpdateTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateTarget> {
        /**
         * <p>
         * The name of the new track.
         * </p>
         * 
         * @param trackName
         *        The name of the new track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackName(String trackName);

        /**
         * <p>
         * The workgroup version for the new track.
         * </p>
         * 
         * @param workgroupVersion
         *        The workgroup version for the new track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupVersion(String workgroupVersion);
    }

    static final class BuilderImpl implements Builder {
        private String trackName;

        private String workgroupVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTarget model) {
            trackName(model.trackName);
            workgroupVersion(model.workgroupVersion);
        }

        public final String getTrackName() {
            return trackName;
        }

        public final void setTrackName(String trackName) {
            this.trackName = trackName;
        }

        @Override
        public final Builder trackName(String trackName) {
            this.trackName = trackName;
            return this;
        }

        public final String getWorkgroupVersion() {
            return workgroupVersion;
        }

        public final void setWorkgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
        }

        @Override
        public final Builder workgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
            return this;
        }

        @Override
        public UpdateTarget build() {
            return new UpdateTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
