/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReservationOfferingsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<ListReservationOfferingsResponse.Builder, ListReservationOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReservationOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ReservationOffering>> RESERVATION_OFFERINGS_LIST_FIELD = SdkField
            .<List<ReservationOffering>> builder(MarshallingType.LIST)
            .memberName("reservationOfferingsList")
            .getter(getter(ListReservationOfferingsResponse::reservationOfferingsList))
            .setter(setter(Builder::reservationOfferingsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationOfferingsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservationOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservationOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVATION_OFFERINGS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ReservationOffering> reservationOfferingsList;

    private ListReservationOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservationOfferingsList = builder.reservationOfferingsList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items.
     * </p>
     * 
     * @return The token to use when requesting the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservationOfferingsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservationOfferingsList() {
        return reservationOfferingsList != null && !(reservationOfferingsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of reservation offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservationOfferingsList} method.
     * </p>
     * 
     * @return The returned list of reservation offerings.
     */
    public final List<ReservationOffering> reservationOfferingsList() {
        return reservationOfferingsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservationOfferingsList() ? reservationOfferingsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationOfferingsResponse)) {
            return false;
        }
        ListReservationOfferingsResponse other = (ListReservationOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasReservationOfferingsList() == other.hasReservationOfferingsList()
                && Objects.equals(reservationOfferingsList(), other.reservationOfferingsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReservationOfferingsResponse").add("NextToken", nextToken())
                .add("ReservationOfferingsList", hasReservationOfferingsList() ? reservationOfferingsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "reservationOfferingsList":
            return Optional.ofNullable(clazz.cast(reservationOfferingsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("reservationOfferingsList", RESERVATION_OFFERINGS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReservationOfferingsResponse, T> g) {
        return obj -> g.apply((ListReservationOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReservationOfferingsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned list of reservation offerings.
         * </p>
         * 
         * @param reservationOfferingsList
         *        The returned list of reservation offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationOfferingsList(Collection<ReservationOffering> reservationOfferingsList);

        /**
         * <p>
         * The returned list of reservation offerings.
         * </p>
         * 
         * @param reservationOfferingsList
         *        The returned list of reservation offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationOfferingsList(ReservationOffering... reservationOfferingsList);

        /**
         * <p>
         * The returned list of reservation offerings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering.Builder#build()} is
         * called immediately and its result is passed to {@link #reservationOfferingsList(List<ReservationOffering>)}.
         * 
         * @param reservationOfferingsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationOfferingsList(java.util.Collection<ReservationOffering>)
         */
        Builder reservationOfferingsList(Consumer<ReservationOffering.Builder>... reservationOfferingsList);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservationOffering> reservationOfferingsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReservationOfferingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservationOfferingsList(model.reservationOfferingsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservationOffering.Builder> getReservationOfferingsList() {
            List<ReservationOffering.Builder> result = ReservationOfferingsListCopier
                    .copyToBuilder(this.reservationOfferingsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservationOfferingsList(Collection<ReservationOffering.BuilderImpl> reservationOfferingsList) {
            this.reservationOfferingsList = ReservationOfferingsListCopier.copyFromBuilder(reservationOfferingsList);
        }

        @Override
        public final Builder reservationOfferingsList(Collection<ReservationOffering> reservationOfferingsList) {
            this.reservationOfferingsList = ReservationOfferingsListCopier.copy(reservationOfferingsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservationOfferingsList(ReservationOffering... reservationOfferingsList) {
            reservationOfferingsList(Arrays.asList(reservationOfferingsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservationOfferingsList(Consumer<ReservationOffering.Builder>... reservationOfferingsList) {
            reservationOfferingsList(Stream.of(reservationOfferingsList)
                    .map(c -> ReservationOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReservationOfferingsResponse build() {
            return new ListReservationOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
