/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUsageLimitRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<CreateUsageLimitRequest.Builder, CreateUsageLimitRequest> {
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("amount")
            .getter(getter(CreateUsageLimitRequest::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("breachAction").getter(getter(CreateUsageLimitRequest::breachActionAsString))
            .setter(setter(Builder::breachAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breachAction").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(CreateUsageLimitRequest::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(CreateUsageLimitRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(CreateUsageLimitRequest::usageTypeAsString))
            .setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD,
            BREACH_ACTION_FIELD, PERIOD_FIELD, RESOURCE_ARN_FIELD, USAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long amount;

    private final String breachAction;

    private final String period;

    private final String resourceArn;

    private final String usageType;

    private CreateUsageLimitRequest(BuilderImpl builder) {
        super(builder);
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
        this.period = builder.period;
        this.resourceArn = builder.resourceArn;
        this.usageType = builder.usageType;
    }

    /**
     * <p>
     * The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If
     * data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The
     * value must be a positive number.
     * </p>
     * 
     * @return The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If
     *         data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account
     *         sharing. The value must be a positive number.
     */
    public final Long amount() {
        return amount;
    }

    /**
     * <p>
     * The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
     * @see UsageLimitBreachAction
     */
    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(breachAction);
    }

    /**
     * <p>
     * The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
     * @see UsageLimitBreachAction
     */
    public final String breachActionAsString() {
        return breachAction;
    }

    /**
     * <p>
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link UsageLimitPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * @see UsageLimitPeriod
     */
    public final UsageLimitPeriod period() {
        return UsageLimitPeriod.fromValue(period);
    }

    /**
     * <p>
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link UsageLimitPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * @see UsageLimitPeriod
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of Amazon Redshift Serverless usage to create a usage limit for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageType} will
     * return {@link UsageLimitUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #usageTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Redshift Serverless usage to create a usage limit for.
     * @see UsageLimitUsageType
     */
    public final UsageLimitUsageType usageType() {
        return UsageLimitUsageType.fromValue(usageType);
    }

    /**
     * <p>
     * The type of Amazon Redshift Serverless usage to create a usage limit for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageType} will
     * return {@link UsageLimitUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #usageTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Redshift Serverless usage to create a usage limit for.
     * @see UsageLimitUsageType
     */
    public final String usageTypeAsString() {
        return usageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(usageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsageLimitRequest)) {
            return false;
        }
        CreateUsageLimitRequest other = (CreateUsageLimitRequest) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(breachActionAsString(), other.breachActionAsString())
                && Objects.equals(periodAsString(), other.periodAsString()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(usageTypeAsString(), other.usageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUsageLimitRequest").add("Amount", amount()).add("BreachAction", breachActionAsString())
                .add("Period", periodAsString()).add("ResourceArn", resourceArn()).add("UsageType", usageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "breachAction":
            return Optional.ofNullable(clazz.cast(breachActionAsString()));
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amount", AMOUNT_FIELD);
        map.put("breachAction", BREACH_ACTION_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUsageLimitRequest, T> g) {
        return obj -> g.apply((CreateUsageLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUsageLimitRequest> {
        /**
         * <p>
         * The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If
         * data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing.
         * The value must be a positive number.
         * </p>
         * 
         * @param amount
         *        The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour.
         *        If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account
         *        sharing. The value must be a positive number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Long amount);

        /**
         * <p>
         * The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
         * </p>
         * 
         * @param breachAction
         *        The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(String breachAction);

        /**
         * <p>
         * The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
         * </p>
         * 
         * @param breachAction
         *        The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(UsageLimitBreachAction breachAction);

        /**
         * <p>
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * </p>
         * 
         * @param period
         *        The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * @see UsageLimitPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitPeriod
         */
        Builder period(String period);

        /**
         * <p>
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * </p>
         * 
         * @param period
         *        The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * @see UsageLimitPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitPeriod
         */
        Builder period(UsageLimitPeriod period);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit
         *        for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of Amazon Redshift Serverless usage to create a usage limit for.
         * </p>
         * 
         * @param usageType
         *        The type of Amazon Redshift Serverless usage to create a usage limit for.
         * @see UsageLimitUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitUsageType
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The type of Amazon Redshift Serverless usage to create a usage limit for.
         * </p>
         * 
         * @param usageType
         *        The type of Amazon Redshift Serverless usage to create a usage limit for.
         * @see UsageLimitUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitUsageType
         */
        Builder usageType(UsageLimitUsageType usageType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Long amount;

        private String breachAction;

        private String period;

        private String resourceArn;

        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsageLimitRequest model) {
            super(model);
            amount(model.amount);
            breachAction(model.breachAction);
            period(model.period);
            resourceArn(model.resourceArn);
            usageType(model.usageType);
        }

        public final Long getAmount() {
            return amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(UsageLimitPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public final Builder usageType(UsageLimitUsageType usageType) {
            this.usageType(usageType == null ? null : usageType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUsageLimitRequest build() {
            return new CreateUsageLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
