/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReservationRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<CreateReservationRequest.Builder, CreateReservationRequest> {
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("capacity").getter(getter(CreateReservationRequest::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateReservationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(CreateReservationRequest::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            CLIENT_TOKEN_FIELD, OFFERING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer capacity;

    private final String clientToken;

    private final String offeringId;

    private CreateReservationRequest(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.clientToken = builder.clientToken;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The number of Redshift Processing Units (RPUs) to reserve.
     * </p>
     * 
     * @return The number of Redshift Processing Units (RPUs) to reserve.
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. This token must be a valid UUIDv4 value. For more information
     * about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"> Making retries safe
     * with idempotent APIs </a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. This token must be a valid UUIDv4 value. For
     *         more information about idempotency, see <a
     *         href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"> Making retries
     *         safe with idempotent APIs </a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the offering associated with the reservation. The offering determines the payment schedule for the
     * reservation.
     * </p>
     * 
     * @return The ID of the offering associated with the reservation. The offering determines the payment schedule for
     *         the reservation.
     */
    public final String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservationRequest)) {
            return false;
        }
        CreateReservationRequest other = (CreateReservationRequest) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(offeringId(), other.offeringId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReservationRequest").add("Capacity", capacity()).add("ClientToken", clientToken())
                .add("OfferingId", offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("offeringId", OFFERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReservationRequest, T> g) {
        return obj -> g.apply((CreateReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReservationRequest> {
        /**
         * <p>
         * The number of Redshift Processing Units (RPUs) to reserve.
         * </p>
         * 
         * @param capacity
         *        The number of Redshift Processing Units (RPUs) to reserve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. This token must be a valid UUIDv4 value. For more
         * information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"> Making retries safe
         * with idempotent APIs </a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. This token must be a valid UUIDv4 value.
         *        For more information about idempotency, see <a
         *        href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/"> Making
         *        retries safe with idempotent APIs </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the offering associated with the reservation. The offering determines the payment schedule for the
         * reservation.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering associated with the reservation. The offering determines the payment schedule
         *        for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Integer capacity;

        private String clientToken;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservationRequest model) {
            super(model);
            capacity(model.capacity);
            clientToken(model.clientToken);
            offeringId(model.offeringId);
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReservationRequest build() {
            return new CreateReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
