/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateReservationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateReservationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotCopyConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotCopyConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationOfferingRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationOfferingResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTrackRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTrackResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateLakehouseConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateLakehouseConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListManagedWorkgroupsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationOfferingsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListScheduledActionsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotCopyConfigurationsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListTracksPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher;

/**
 * Service client for accessing Redshift Serverless asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming
 * or command line interfaces you can use to manage Amazon Redshift Serverless.
 * </p>
 * <p>
 * Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying
 * resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently
 * high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift
 * Serverless lets you focus on using your data to acquire new insights for your business and customers.
 * </p>
 * <p>
 * To learn more about Amazon Redshift Serverless, see <a
 * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html">What is Amazon Redshift
 * Serverless?</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RedshiftServerlessAsyncClient extends AwsClient {
    String SERVICE_NAME = "redshift-serverless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "redshift-serverless";

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery-points.html">Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     * @return A Java Future containing the result of the ConvertRecoveryPointToSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConvertRecoveryPointToSnapshotResponse> convertRecoveryPointToSnapshot(
            ConvertRecoveryPointToSnapshotRequest convertRecoveryPointToSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery-points.html">Working with
     * snapshots and recovery points</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConvertRecoveryPointToSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link ConvertRecoveryPointToSnapshotRequest#builder()}
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ConvertRecoveryPointToSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConvertRecoveryPointToSnapshotResponse> convertRecoveryPointToSnapshot(
            Consumer<ConvertRecoveryPointToSnapshotRequest.Builder> convertRecoveryPointToSnapshotRequest) {
        return convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest.builder()
                .applyMutation(convertRecoveryPointToSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a custom domain association for Amazon Redshift Serverless.
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     * @return A Java Future containing the result of the CreateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(
            CreateCustomDomainAssociationRequest createCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom domain association for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(
            Consumer<CreateCustomDomainAssociationRequest.Builder> createCustomDomainAssociationRequest) {
        return createCustomDomainAssociation(CreateCustomDomainAssociationRequest.builder()
                .applyMutation(createCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            CreateEndpointAccessRequest createEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param createEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            Consumer<CreateEndpointAccessRequest.Builder> createEndpointAccessRequest) {
        return createEndpointAccess(CreateEndpointAccessRequest.builder().applyMutation(createEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param createNamespaceRequest
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest createNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamespaceRequest#builder()}
     * </p>
     *
     * @param createNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNamespaceResponse> createNamespace(
            Consumer<CreateNamespaceRequest.Builder> createNamespaceRequest) {
        return createNamespace(CreateNamespaceRequest.builder().applyMutation(createNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless reservation, which gives you the option to commit to a specified number of
     * Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
     * </p>
     *
     * @param createReservationRequest
     * @return A Java Future containing the result of the CreateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReservationResponse> createReservation(CreateReservationRequest createReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless reservation, which gives you the option to commit to a specified number of
     * Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReservationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReservationRequest#builder()}
     * </p>
     *
     * @param createReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateReservationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReservationResponse> createReservation(
            Consumer<CreateReservationRequest.Builder> createReservationRequest) {
        return createReservation(CreateReservationRequest.builder().applyMutation(createReservationRequest).build());
    }

    /**
     * <p>
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For
     * example, you can create a schedule of when to run the <code>CreateSnapshot</code> API operation.
     * </p>
     *
     * @param createScheduledActionRequest
     * @return A Java Future containing the result of the CreateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScheduledActionResponse> createScheduledAction(
            CreateScheduledActionRequest createScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For
     * example, you can create a schedule of when to run the <code>CreateSnapshot</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateScheduledActionRequest#builder()}
     * </p>
     *
     * @param createScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateScheduledActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScheduledActionResponse> createScheduledAction(
            Consumer<CreateScheduledActionRequest.Builder> createScheduledActionRequest) {
        return createScheduledAction(CreateScheduledActionRequest.builder().applyMutation(createScheduledActionRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery-points.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery-points.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.
     * </p>
     *
     * @param createSnapshotCopyConfigurationRequest
     * @return A Java Future containing the result of the CreateSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotCopyConfigurationResponse> createSnapshotCopyConfiguration(
            CreateSnapshotCopyConfigurationRequest createSnapshotCopyConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotCopyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSnapshotCopyConfigurationRequest#builder()}
     * </p>
     *
     * @param createSnapshotCopyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotCopyConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotCopyConfigurationResponse> createSnapshotCopyConfiguration(
            Consumer<CreateSnapshotCopyConfigurationRequest.Builder> createSnapshotCopyConfigurationRequest) {
        return createSnapshotCopyConfiguration(CreateSnapshotCopyConfigurationRequest.builder()
                .applyMutation(createSnapshotCopyConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUsageLimitRequest#builder()}
     * </p>
     *
     * @param createUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUsageLimitResponse> createUsageLimit(
            Consumer<CreateUsageLimitRequest.Builder> createUsageLimitRequest) {
        return createUsageLimit(CreateUsageLimitRequest.builder().applyMutation(createUsageLimitRequest).build());
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     * <p>
     * VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
     * reaching or being reached from the internet through internet gateways and egress-only internet gateways. If a
     * workgroup is in an account with VPC BPA turned on, the following capabilities are blocked:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating a public access workgroup
     * </p>
     * </li>
     * <li>
     * <p>
     * Modifying a private workgroup to public
     * </p>
     * </li>
     * <li>
     * <p>
     * Adding a subnet with VPC BPA turned on to the workgroup when the workgroup is public
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createWorkgroupRequest
     * @return A Java Future containing the result of the CreateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkgroupResponse> createWorkgroup(CreateWorkgroupRequest createWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     * <p>
     * VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
     * reaching or being reached from the internet through internet gateways and egress-only internet gateways. If a
     * workgroup is in an account with VPC BPA turned on, the following capabilities are blocked:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating a public access workgroup
     * </p>
     * </li>
     * <li>
     * <p>
     * Modifying a private workgroup to public
     * </p>
     * </li>
     * <li>
     * <p>
     * Adding a subnet with VPC BPA turned on to the workgroup when the workgroup is public
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkgroupRequest#builder()}
     * </p>
     *
     * @param createWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkgroupResponse> createWorkgroup(
            Consumer<CreateWorkgroupRequest.Builder> createWorkgroupRequest) {
        return createWorkgroup(CreateWorkgroupRequest.builder().applyMutation(createWorkgroupRequest).build());
    }

    /**
     * <p>
     * Deletes a custom domain association for Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     * @return A Java Future containing the result of the DeleteCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(
            DeleteCustomDomainAssociationRequest deleteCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom domain association for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(
            Consumer<DeleteCustomDomainAssociationRequest.Builder> deleteCustomDomainAssociationRequest) {
        return deleteCustomDomainAssociation(DeleteCustomDomainAssociationRequest.builder()
                .applyMutation(deleteCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            DeleteEndpointAccessRequest deleteEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointAccessRequest#builder()}
     * </p>
     *
     * @param deleteEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            Consumer<DeleteEndpointAccessRequest.Builder> deleteEndpointAccessRequest) {
        return deleteEndpointAccess(DeleteEndpointAccessRequest.builder().applyMutation(deleteEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(
            Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scheduled action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param deleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteScheduledActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            Consumer<DeleteScheduledActionRequest.Builder> deleteScheduledActionRequest) {
        return deleteScheduledAction(DeleteScheduledActionRequest.builder().applyMutation(deleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest) {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot copy configuration
     * </p>
     *
     * @param deleteSnapshotCopyConfigurationRequest
     * @return A Java Future containing the result of the DeleteSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotCopyConfigurationResponse> deleteSnapshotCopyConfiguration(
            DeleteSnapshotCopyConfigurationRequest deleteSnapshotCopyConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot copy configuration
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotCopyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSnapshotCopyConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotCopyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotCopyConfigurationResponse> deleteSnapshotCopyConfiguration(
            Consumer<DeleteSnapshotCopyConfigurationRequest.Builder> deleteSnapshotCopyConfigurationRequest) {
        return deleteSnapshotCopyConfiguration(DeleteSnapshotCopyConfigurationRequest.builder()
                .applyMutation(deleteSnapshotCopyConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUsageLimitRequest#builder()}
     * </p>
     *
     * @param deleteUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(
            Consumer<DeleteUsageLimitRequest.Builder> deleteUsageLimitRequest) {
        return deleteUsageLimit(DeleteUsageLimitRequest.builder().applyMutation(deleteUsageLimitRequest).build());
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     *
     * @param deleteWorkgroupRequest
     * @return A Java Future containing the result of the DeleteWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkgroupResponse> deleteWorkgroup(DeleteWorkgroupRequest deleteWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkgroupRequest#builder()}
     * </p>
     *
     * @param deleteWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkgroupResponse> deleteWorkgroup(
            Consumer<DeleteWorkgroupRequest.Builder> deleteWorkgroupRequest) {
        return deleteWorkgroup(DeleteWorkgroupRequest.builder().applyMutation(deleteWorkgroupRequest).build());
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached
     * that allows access to all necessary actions and resources.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource dbname for
     * the specified database name.
     * </p>
     *
     * @param getCredentialsRequest
     * @return A Java Future containing the result of the GetCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialsResponse> getCredentials(GetCredentialsRequest getCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached
     * that allows access to all necessary actions and resources.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource dbname for
     * the specified database name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialsRequest.Builder} avoiding the need to
     * create one manually via {@link GetCredentialsRequest#builder()}
     * </p>
     *
     * @param getCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialsResponse> getCredentials(Consumer<GetCredentialsRequest.Builder> getCredentialsRequest) {
        return getCredentials(GetCredentialsRequest.builder().applyMutation(getCredentialsRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific custom domain association.
     * </p>
     *
     * @param getCustomDomainAssociationRequest
     * @return A Java Future containing the result of the GetCustomDomainAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomDomainAssociationResponse> getCustomDomainAssociation(
            GetCustomDomainAssociationRequest getCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific custom domain association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomDomainAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param getCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetCustomDomainAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomDomainAssociationResponse> getCustomDomainAssociation(
            Consumer<GetCustomDomainAssociationRequest.Builder> getCustomDomainAssociationRequest) {
        return getCustomDomainAssociation(GetCustomDomainAssociationRequest.builder()
                .applyMutation(getCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     *
     * @param getEndpointAccessRequest
     * @return A Java Future containing the result of the GetEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEndpointAccessResponse> getEndpointAccess(GetEndpointAccessRequest getEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetEndpointAccessRequest#builder()}
     * </p>
     *
     * @param getEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEndpointAccessResponse> getEndpointAccess(
            Consumer<GetEndpointAccessRequest.Builder> getEndpointAccessRequest) {
        return getEndpointAccess(GetEndpointAccessRequest.builder().applyMutation(getEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param getNamespaceRequest
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest getNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamespaceRequest#builder()}
     * </p>
     *
     * @param getNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest) {
        return getNamespace(GetNamespaceRequest.builder().applyMutation(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     *
     * @param getRecoveryPointRequest
     * @return A Java Future containing the result of the GetRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryPointResponse> getRecoveryPoint(GetRecoveryPointRequest getRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryPointRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecoveryPointRequest#builder()}
     * </p>
     *
     * @param getRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryPointResponse> getRecoveryPoint(
            Consumer<GetRecoveryPointRequest.Builder> getRecoveryPointRequest) {
        return getRecoveryPoint(GetRecoveryPointRequest.builder().applyMutation(getRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon Redshift Serverless reservation. A reservation gives you the option to commit to a specified
     * number of Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
     * </p>
     *
     * @param getReservationRequest
     * @return A Java Future containing the result of the GetReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservationResponse> getReservation(GetReservationRequest getReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon Redshift Serverless reservation. A reservation gives you the option to commit to a specified
     * number of Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservationRequest.Builder} avoiding the need to
     * create one manually via {@link GetReservationRequest#builder()}
     * </p>
     *
     * @param getReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservationResponse> getReservation(Consumer<GetReservationRequest.Builder> getReservationRequest) {
        return getReservation(GetReservationRequest.builder().applyMutation(getReservationRequest).build());
    }

    /**
     * <p>
     * Returns the reservation offering. The offering determines the payment schedule for the reservation.
     * </p>
     *
     * @param getReservationOfferingRequest
     * @return A Java Future containing the result of the GetReservationOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetReservationOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetReservationOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservationOfferingResponse> getReservationOffering(
            GetReservationOfferingRequest getReservationOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the reservation offering. The offering determines the payment schedule for the reservation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservationOfferingRequest.Builder} avoiding the
     * need to create one manually via {@link GetReservationOfferingRequest#builder()}
     * </p>
     *
     * @param getReservationOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetReservationOfferingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetReservationOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetReservationOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetReservationOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservationOfferingResponse> getReservationOffering(
            Consumer<GetReservationOfferingRequest.Builder> getReservationOfferingRequest) {
        return getReservationOffering(GetReservationOfferingRequest.builder().applyMutation(getReservationOfferingRequest)
                .build());
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a scheduled action.
     * </p>
     *
     * @param getScheduledActionRequest
     * @return A Java Future containing the result of the GetScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetScheduledActionResponse> getScheduledAction(GetScheduledActionRequest getScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a scheduled action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link GetScheduledActionRequest#builder()}
     * </p>
     *
     * @param getScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetScheduledActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetScheduledActionResponse> getScheduledAction(
            Consumer<GetScheduledActionRequest.Builder> getScheduledActionRequest) {
        return getScheduledAction(GetScheduledActionRequest.builder().applyMutation(getScheduledActionRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSnapshotResponse> getSnapshot(GetSnapshotRequest getSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotRequest#builder()}
     * </p>
     *
     * @param getSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSnapshotResponse> getSnapshot(Consumer<GetSnapshotRequest.Builder> getSnapshotRequest) {
        return getSnapshot(GetSnapshotRequest.builder().applyMutation(getSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     *
     * @param getTableRestoreStatusRequest
     * @return A Java Future containing the result of the GetTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableRestoreStatusResponse> getTableRestoreStatus(
            GetTableRestoreStatusRequest getTableRestoreStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param getTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableRestoreStatusResponse> getTableRestoreStatus(
            Consumer<GetTableRestoreStatusRequest.Builder> getTableRestoreStatusRequest) {
        return getTableRestoreStatus(GetTableRestoreStatusRequest.builder().applyMutation(getTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Get the Redshift Serverless version for a specified track.
     * </p>
     *
     * @param getTrackRequest
     * @return A Java Future containing the result of the GetTrack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTrack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTrack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrackResponse> getTrack(GetTrackRequest getTrackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the Redshift Serverless version for a specified track.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrackRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrackRequest#builder()}
     * </p>
     *
     * @param getTrackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetTrackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTrack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTrack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrackResponse> getTrack(Consumer<GetTrackRequest.Builder> getTrackRequest) {
        return getTrack(GetTrackRequest.builder().applyMutation(getTrackRequest).build());
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     *
     * @param getUsageLimitRequest
     * @return A Java Future containing the result of the GetUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUsageLimitResponse> getUsageLimit(GetUsageLimitRequest getUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageLimitRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageLimitRequest#builder()}
     * </p>
     *
     * @param getUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUsageLimitResponse> getUsageLimit(Consumer<GetUsageLimitRequest.Builder> getUsageLimitRequest) {
        return getUsageLimit(GetUsageLimitRequest.builder().applyMutation(getUsageLimitRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     *
     * @param getWorkgroupRequest
     * @return A Java Future containing the result of the GetWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkgroupResponse> getWorkgroup(GetWorkgroupRequest getWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkgroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkgroupRequest#builder()}
     * </p>
     *
     * @param getWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkgroupResponse> getWorkgroup(Consumer<GetWorkgroupRequest.Builder> getWorkgroupRequest) {
        return getWorkgroup(GetWorkgroupRequest.builder().applyMutation(getWorkgroupRequest).build());
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     * @return A Java Future containing the result of the ListCustomDomainAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomDomainAssociationsResponse> listCustomDomainAssociations(
            ListCustomDomainAssociationsRequest listCustomDomainAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomDomainAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCustomDomainAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomDomainAssociationsResponse> listCustomDomainAssociations(
            Consumer<ListCustomDomainAssociationsRequest.Builder> listCustomDomainAssociationsRequest) {
        return listCustomDomainAssociations(ListCustomDomainAssociationsRequest.builder()
                .applyMutation(listCustomDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsPublisher publisher = client.listCustomDomainAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsPublisher publisher = client.listCustomDomainAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDomainAssociationsPublisher listCustomDomainAssociationsPaginator(
            ListCustomDomainAssociationsRequest listCustomDomainAssociationsRequest) {
        return new ListCustomDomainAssociationsPublisher(this, listCustomDomainAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsPublisher publisher = client.listCustomDomainAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListCustomDomainAssociationsPublisher publisher = client.listCustomDomainAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDomainAssociations(software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomDomainAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDomainAssociationsPublisher listCustomDomainAssociationsPaginator(
            Consumer<ListCustomDomainAssociationsRequest.Builder> listCustomDomainAssociationsRequest) {
        return listCustomDomainAssociationsPaginator(ListCustomDomainAssociationsRequest.builder()
                .applyMutation(listCustomDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return A Java Future containing the result of the ListEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointAccessResponse> listEndpointAccess(ListEndpointAccessRequest listEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointAccessResponse> listEndpointAccess(
            Consumer<ListEndpointAccessRequest.Builder> listEndpointAccessRequest) {
        return listEndpointAccess(ListEndpointAccessRequest.builder().applyMutation(listEndpointAccessRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessPublisher listEndpointAccessPaginator(ListEndpointAccessRequest listEndpointAccessRequest) {
        return new ListEndpointAccessPublisher(this, listEndpointAccessRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessPublisher listEndpointAccessPaginator(
            Consumer<ListEndpointAccessRequest.Builder> listEndpointAccessRequest) {
        return listEndpointAccessPaginator(ListEndpointAccessRequest.builder().applyMutation(listEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified managed workgroups in your account.
     * </p>
     *
     * @param listManagedWorkgroupsRequest
     * @return A Java Future containing the result of the ListManagedWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListManagedWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListManagedWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedWorkgroupsResponse> listManagedWorkgroups(
            ListManagedWorkgroupsRequest listManagedWorkgroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified managed workgroups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedWorkgroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listManagedWorkgroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListManagedWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListManagedWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListManagedWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedWorkgroupsResponse> listManagedWorkgroups(
            Consumer<ListManagedWorkgroupsRequest.Builder> listManagedWorkgroupsRequest) {
        return listManagedWorkgroups(ListManagedWorkgroupsRequest.builder().applyMutation(listManagedWorkgroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListManagedWorkgroupsPublisher publisher = client.listManagedWorkgroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListManagedWorkgroupsPublisher publisher = client.listManagedWorkgroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedWorkgroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListManagedWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListManagedWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedWorkgroupsPublisher listManagedWorkgroupsPaginator(
            ListManagedWorkgroupsRequest listManagedWorkgroupsRequest) {
        return new ListManagedWorkgroupsPublisher(this, listManagedWorkgroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListManagedWorkgroupsPublisher publisher = client.listManagedWorkgroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListManagedWorkgroupsPublisher publisher = client.listManagedWorkgroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedWorkgroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listManagedWorkgroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListManagedWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListManagedWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedWorkgroupsPublisher listManagedWorkgroupsPaginator(
            Consumer<ListManagedWorkgroupsRequest.Builder> listManagedWorkgroupsRequest) {
        return listManagedWorkgroupsPaginator(ListManagedWorkgroupsRequest.builder().applyMutation(listManagedWorkgroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespaces(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesPublisher listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest) {
        return new ListNamespacesPublisher(this, listNamespacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesPublisher listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespacesPaginator(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return A Java Future containing the result of the ListRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsResponse> listRecoveryPoints(ListRecoveryPointsRequest listRecoveryPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsResponse> listRecoveryPoints(
            Consumer<ListRecoveryPointsRequest.Builder> listRecoveryPointsRequest) {
        return listRecoveryPoints(ListRecoveryPointsRequest.builder().applyMutation(listRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsPublisher listRecoveryPointsPaginator(ListRecoveryPointsRequest listRecoveryPointsRequest) {
        return new ListRecoveryPointsPublisher(this, listRecoveryPointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsPublisher listRecoveryPointsPaginator(
            Consumer<ListRecoveryPointsRequest.Builder> listRecoveryPointsRequest) {
        return listRecoveryPointsPaginator(ListRecoveryPointsRequest.builder().applyMutation(listRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns the current reservation offerings in your account.
     * </p>
     *
     * @param listReservationOfferingsRequest
     * @return A Java Future containing the result of the ListReservationOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservationOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReservationOfferingsResponse> listReservationOfferings(
            ListReservationOfferingsRequest listReservationOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current reservation offerings in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationOfferingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReservationOfferingsRequest#builder()}
     * </p>
     *
     * @param listReservationOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListReservationOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservationOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReservationOfferingsResponse> listReservationOfferings(
            Consumer<ListReservationOfferingsRequest.Builder> listReservationOfferingsRequest) {
        return listReservationOfferings(ListReservationOfferingsRequest.builder().applyMutation(listReservationOfferingsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservationOfferings(software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationOfferingsPublisher publisher = client.listReservationOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationOfferingsPublisher publisher = client.listReservationOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservationOfferings(software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReservationOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservationOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReservationOfferingsPublisher listReservationOfferingsPaginator(
            ListReservationOfferingsRequest listReservationOfferingsRequest) {
        return new ListReservationOfferingsPublisher(this, listReservationOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservationOfferings(software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationOfferingsPublisher publisher = client.listReservationOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationOfferingsPublisher publisher = client.listReservationOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservationOfferings(software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationOfferingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReservationOfferingsRequest#builder()}
     * </p>
     *
     * @param listReservationOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservationOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReservationOfferingsPublisher listReservationOfferingsPaginator(
            Consumer<ListReservationOfferingsRequest.Builder> listReservationOfferingsRequest) {
        return listReservationOfferingsPaginator(ListReservationOfferingsRequest.builder()
                .applyMutation(listReservationOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Reservation objects.
     * </p>
     *
     * @param listReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Reservation objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(
            Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(ListReservationsRequest listReservationsRequest) {
        return new ListReservationsPublisher(this, listReservationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.
     * </p>
     *
     * @param listScheduledActionsRequest
     * @return A Java Future containing the result of the ListScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListScheduledActionsResponse> listScheduledActions(
            ListScheduledActionsRequest listScheduledActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduledActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduledActionsRequest#builder()}
     * </p>
     *
     * @param listScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListScheduledActionsResponse> listScheduledActions(
            Consumer<ListScheduledActionsRequest.Builder> listScheduledActionsRequest) {
        return listScheduledActions(ListScheduledActionsRequest.builder().applyMutation(listScheduledActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScheduledActions(software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScheduledActions(software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listScheduledActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListScheduledActionsPublisher listScheduledActionsPaginator(ListScheduledActionsRequest listScheduledActionsRequest) {
        return new ListScheduledActionsPublisher(this, listScheduledActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScheduledActions(software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScheduledActions(software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduledActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduledActionsRequest#builder()}
     * </p>
     *
     * @param listScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListScheduledActionsPublisher listScheduledActionsPaginator(
            Consumer<ListScheduledActionsRequest.Builder> listScheduledActionsRequest) {
        return listScheduledActionsPaginator(ListScheduledActionsRequest.builder().applyMutation(listScheduledActionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy configurations.
     * </p>
     *
     * @param listSnapshotCopyConfigurationsRequest
     * @return A Java Future containing the result of the ListSnapshotCopyConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshotCopyConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSnapshotCopyConfigurationsResponse> listSnapshotCopyConfigurations(
            ListSnapshotCopyConfigurationsRequest listSnapshotCopyConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshot copy configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotCopyConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSnapshotCopyConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSnapshotCopyConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListSnapshotCopyConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshotCopyConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSnapshotCopyConfigurationsResponse> listSnapshotCopyConfigurations(
            Consumer<ListSnapshotCopyConfigurationsRequest.Builder> listSnapshotCopyConfigurationsRequest) {
        return listSnapshotCopyConfigurations(ListSnapshotCopyConfigurationsRequest.builder()
                .applyMutation(listSnapshotCopyConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSnapshotCopyConfigurations(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotCopyConfigurationsPublisher publisher = client.listSnapshotCopyConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotCopyConfigurationsPublisher publisher = client.listSnapshotCopyConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshotCopyConfigurations(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSnapshotCopyConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshotCopyConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotCopyConfigurationsPublisher listSnapshotCopyConfigurationsPaginator(
            ListSnapshotCopyConfigurationsRequest listSnapshotCopyConfigurationsRequest) {
        return new ListSnapshotCopyConfigurationsPublisher(this, listSnapshotCopyConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSnapshotCopyConfigurations(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotCopyConfigurationsPublisher publisher = client.listSnapshotCopyConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotCopyConfigurationsPublisher publisher = client.listSnapshotCopyConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshotCopyConfigurations(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotCopyConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSnapshotCopyConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSnapshotCopyConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshotCopyConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotCopyConfigurationsPublisher listSnapshotCopyConfigurationsPaginator(
            Consumer<ListSnapshotCopyConfigurationsRequest.Builder> listSnapshotCopyConfigurationsRequest) {
        return listSnapshotCopyConfigurationsPaginator(ListSnapshotCopyConfigurationsRequest.builder()
                .applyMutation(listSnapshotCopyConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSnapshotsResponse> listSnapshots(ListSnapshotsRequest listSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSnapshotsResponse> listSnapshots(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest) {
        return listSnapshots(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsPublisher listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest) {
        return new ListSnapshotsPublisher(this, listSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsPublisher listSnapshotsPaginator(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest) {
        return listSnapshotsPaginator(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return A Java Future containing the result of the ListTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTableRestoreStatusResponse> listTableRestoreStatus(
            ListTableRestoreStatusRequest listTableRestoreStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param listTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTableRestoreStatusResponse> listTableRestoreStatus(
            Consumer<ListTableRestoreStatusRequest.Builder> listTableRestoreStatusRequest) {
        return listTableRestoreStatus(ListTableRestoreStatusRequest.builder().applyMutation(listTableRestoreStatusRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusPublisher listTableRestoreStatusPaginator(
            ListTableRestoreStatusRequest listTableRestoreStatusRequest) {
        return new ListTableRestoreStatusPublisher(this, listTableRestoreStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param listTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusPublisher listTableRestoreStatusPaginator(
            Consumer<ListTableRestoreStatusRequest.Builder> listTableRestoreStatusRequest) {
        return listTableRestoreStatusPaginator(ListTableRestoreStatusRequest.builder()
                .applyMutation(listTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List the Amazon Redshift Serverless versions.
     * </p>
     *
     * @param listTracksRequest
     * @return A Java Future containing the result of the ListTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTracksResponse> listTracks(ListTracksRequest listTracksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Amazon Redshift Serverless versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTracksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTracksRequest#builder()}
     * </p>
     *
     * @param listTracksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTracksResponse> listTracks(Consumer<ListTracksRequest.Builder> listTracksRequest) {
        return listTracks(ListTracksRequest.builder().applyMutation(listTracksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTracks(software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTracksPublisher publisher = client.listTracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTracksPublisher publisher = client.listTracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTracks(software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest)} operation.</b>
     * </p>
     *
     * @param listTracksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTracksPublisher listTracksPaginator(ListTracksRequest listTracksRequest) {
        return new ListTracksPublisher(this, listTracksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTracks(software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTracksPublisher publisher = client.listTracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTracksPublisher publisher = client.listTracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTracks(software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTracksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTracksRequest#builder()}
     * </p>
     *
     * @param listTracksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTracksPublisher listTracksPaginator(Consumer<ListTracksRequest.Builder> listTracksRequest) {
        return listTracksPaginator(ListTracksRequest.builder().applyMutation(listTracksRequest).build());
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return A Java Future containing the result of the ListUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageLimitsResponse> listUsageLimits(ListUsageLimitsRequest listUsageLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageLimitsRequest#builder()}
     * </p>
     *
     * @param listUsageLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageLimitsResponse> listUsageLimits(
            Consumer<ListUsageLimitsRequest.Builder> listUsageLimitsRequest) {
        return listUsageLimits(ListUsageLimitsRequest.builder().applyMutation(listUsageLimitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsPublisher listUsageLimitsPaginator(ListUsageLimitsRequest listUsageLimitsRequest) {
        return new ListUsageLimitsPublisher(this, listUsageLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageLimitsRequest#builder()}
     * </p>
     *
     * @param listUsageLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsPublisher listUsageLimitsPaginator(Consumer<ListUsageLimitsRequest.Builder> listUsageLimitsRequest) {
        return listUsageLimitsPaginator(ListUsageLimitsRequest.builder().applyMutation(listUsageLimitsRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return A Java Future containing the result of the ListWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkgroupsResponse> listWorkgroups(ListWorkgroupsRequest listWorkgroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkgroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listWorkgroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkgroupsResponse> listWorkgroups(Consumer<ListWorkgroupsRequest.Builder> listWorkgroupsRequest) {
        return listWorkgroups(ListWorkgroupsRequest.builder().applyMutation(listWorkgroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsPublisher listWorkgroupsPaginator(ListWorkgroupsRequest listWorkgroupsRequest) {
        return new ListWorkgroupsPublisher(this, listWorkgroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkgroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listWorkgroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsPublisher listWorkgroupsPaginator(Consumer<ListWorkgroupsRequest.Builder> listWorkgroupsRequest) {
        return listWorkgroupsPaginator(ListWorkgroupsRequest.builder().applyMutation(listWorkgroupsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     * @return A Java Future containing the result of the RestoreFromRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromRecoveryPointResponse> restoreFromRecoveryPoint(
            RestoreFromRecoveryPointRequest restoreFromRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromRecoveryPointRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreFromRecoveryPointRequest#builder()}
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RestoreFromRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromRecoveryPointResponse> restoreFromRecoveryPoint(
            Consumer<RestoreFromRecoveryPointRequest.Builder> restoreFromRecoveryPointRequest) {
        return restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest.builder().applyMutation(restoreFromRecoveryPointRequest)
                .build());
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            Consumer<RestoreFromSnapshotRequest.Builder> restoreFromSnapshotRequest) {
        return restoreFromSnapshot(RestoreFromSnapshotRequest.builder().applyMutation(restoreFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation
     * to restore tables with interleaved sort keys.
     * </p>
     *
     * @param restoreTableFromRecoveryPointRequest
     * @return A Java Future containing the result of the RestoreTableFromRecoveryPoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromRecoveryPoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromRecoveryPointResponse> restoreTableFromRecoveryPoint(
            RestoreTableFromRecoveryPointRequest restoreTableFromRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation
     * to restore tables with interleaved sort keys.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableFromRecoveryPointRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreTableFromRecoveryPointRequest#builder()}
     * </p>
     *
     * @param restoreTableFromRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromRecoveryPointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RestoreTableFromRecoveryPoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromRecoveryPoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromRecoveryPointResponse> restoreTableFromRecoveryPoint(
            Consumer<RestoreTableFromRecoveryPointRequest.Builder> restoreTableFromRecoveryPointRequest) {
        return restoreTableFromRecoveryPoint(RestoreTableFromRecoveryPointRequest.builder()
                .applyMutation(restoreTableFromRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreTableFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromSnapshotResponse> restoreTableFromSnapshot(
            RestoreTableFromSnapshotRequest restoreTableFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreTableFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RestoreTableFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromSnapshotResponse> restoreTableFromSnapshot(
            Consumer<RestoreTableFromSnapshotRequest.Builder> restoreTableFromSnapshotRequest) {
        return restoreTableFromSnapshot(RestoreTableFromSnapshotRequest.builder().applyMutation(restoreTableFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
     * </p>
     *
     * @param updateCustomDomainAssociationRequest
     * @return A Java Future containing the result of the UpdateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomDomainAssociationResponse> updateCustomDomainAssociation(
            UpdateCustomDomainAssociationRequest updateCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param updateCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomDomainAssociationResponse> updateCustomDomainAssociation(
            Consumer<UpdateCustomDomainAssociationRequest.Builder> updateCustomDomainAssociationRequest) {
        return updateCustomDomainAssociation(UpdateCustomDomainAssociationRequest.builder()
                .applyMutation(updateCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     *
     * @param updateEndpointAccessRequest
     * @return A Java Future containing the result of the UpdateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointAccessResponse> updateEndpointAccess(
            UpdateEndpointAccessRequest updateEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param updateEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointAccessResponse> updateEndpointAccess(
            Consumer<UpdateEndpointAccessRequest.Builder> updateEndpointAccessRequest) {
        return updateEndpointAccess(UpdateEndpointAccessRequest.builder().applyMutation(updateEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Modifies the lakehouse configuration for a namespace. This operation allows you to manage Amazon Redshift
     * federated permissions and Amazon Web Services IAM Identity Center trusted identity propagation.
     * </p>
     *
     * @param updateLakehouseConfigurationRequest
     * @return A Java Future containing the result of the UpdateLakehouseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DryRunException This exception is thrown when the request was successful, but dry run was enabled so
     *         no action was taken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateLakehouseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateLakehouseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLakehouseConfigurationResponse> updateLakehouseConfiguration(
            UpdateLakehouseConfigurationRequest updateLakehouseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the lakehouse configuration for a namespace. This operation allows you to manage Amazon Redshift
     * federated permissions and Amazon Web Services IAM Identity Center trusted identity propagation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLakehouseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLakehouseConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLakehouseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateLakehouseConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateLakehouseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DryRunException This exception is thrown when the request was successful, but dry run was enabled so
     *         no action was taken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateLakehouseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateLakehouseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLakehouseConfigurationResponse> updateLakehouseConfiguration(
            Consumer<UpdateLakehouseConfigurationRequest.Builder> updateLakehouseConfigurationRequest) {
        return updateLakehouseConfiguration(UpdateLakehouseConfigurationRequest.builder()
                .applyMutation(updateLakehouseConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     *
     * @param updateNamespaceRequest
     * @return A Java Future containing the result of the UpdateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNamespaceResponse> updateNamespace(UpdateNamespaceRequest updateNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNamespaceRequest#builder()}
     * </p>
     *
     * @param updateNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNamespaceResponse> updateNamespace(
            Consumer<UpdateNamespaceRequest.Builder> updateNamespaceRequest) {
        return updateNamespace(UpdateNamespaceRequest.builder().applyMutation(updateNamespaceRequest).build());
    }

    /**
     * <p>
     * Updates a scheduled action.
     * </p>
     *
     * @param updateScheduledActionRequest
     * @return A Java Future containing the result of the UpdateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateScheduledActionResponse> updateScheduledAction(
            UpdateScheduledActionRequest updateScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a scheduled action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateScheduledActionRequest#builder()}
     * </p>
     *
     * @param updateScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateScheduledActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateScheduledActionResponse> updateScheduledAction(
            Consumer<UpdateScheduledActionRequest.Builder> updateScheduledActionRequest) {
        return updateScheduledAction(UpdateScheduledActionRequest.builder().applyMutation(updateScheduledActionRequest).build());
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSnapshotRequest#builder()}
     * </p>
     *
     * @param updateSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotResponse> updateSnapshot(Consumer<UpdateSnapshotRequest.Builder> updateSnapshotRequest) {
        return updateSnapshot(UpdateSnapshotRequest.builder().applyMutation(updateSnapshotRequest).build());
    }

    /**
     * <p>
     * Updates a snapshot copy configuration.
     * </p>
     *
     * @param updateSnapshotCopyConfigurationRequest
     * @return A Java Future containing the result of the UpdateSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotCopyConfigurationResponse> updateSnapshotCopyConfiguration(
            UpdateSnapshotCopyConfigurationRequest updateSnapshotCopyConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a snapshot copy configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotCopyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSnapshotCopyConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSnapshotCopyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotCopyConfigurationResponse> updateSnapshotCopyConfiguration(
            Consumer<UpdateSnapshotCopyConfigurationRequest.Builder> updateSnapshotCopyConfigurationRequest) {
        return updateSnapshotCopyConfiguration(UpdateSnapshotCopyConfigurationRequest.builder()
                .applyMutation(updateSnapshotCopyConfigurationRequest).build());
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     *
     * @param updateUsageLimitRequest
     * @return A Java Future containing the result of the UpdateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUsageLimitResponse> updateUsageLimit(UpdateUsageLimitRequest updateUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateUsageLimitRequest#builder()}
     * </p>
     *
     * @param updateUsageLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUsageLimitResponse> updateUsageLimit(
            Consumer<UpdateUsageLimitRequest.Builder> updateUsageLimitRequest) {
        return updateUsageLimit(UpdateUsageLimitRequest.builder().applyMutation(updateUsageLimitRequest).build());
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     * <p>
     * VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
     * reaching or being reached from the internet through internet gateways and egress-only internet gateways. If a
     * workgroup is in an account with VPC BPA turned on, the following capabilities are blocked:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating a public access workgroup
     * </p>
     * </li>
     * <li>
     * <p>
     * Modifying a private workgroup to public
     * </p>
     * </li>
     * <li>
     * <p>
     * Adding a subnet with VPC BPA turned on to the workgroup when the workgroup is public
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param updateWorkgroupRequest
     * @return A Java Future containing the result of the UpdateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkgroupResponse> updateWorkgroup(UpdateWorkgroupRequest updateWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     * <p>
     * VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
     * reaching or being reached from the internet through internet gateways and egress-only internet gateways. If a
     * workgroup is in an account with VPC BPA turned on, the following capabilities are blocked:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating a public access workgroup
     * </p>
     * </li>
     * <li>
     * <p>
     * Modifying a private workgroup to public
     * </p>
     * </li>
     * <li>
     * <p>
     * Adding a subnet with VPC BPA turned on to the workgroup when the workgroup is public
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkgroupRequest#builder()}
     * </p>
     *
     * @param updateWorkgroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkgroupResponse> updateWorkgroup(
            Consumer<UpdateWorkgroupRequest.Builder> updateWorkgroupRequest) {
        return updateWorkgroup(UpdateWorkgroupRequest.builder().applyMutation(updateWorkgroupRequest).build());
    }

    @Override
    default RedshiftServerlessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link RedshiftServerlessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RedshiftServerlessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RedshiftServerlessAsyncClient}.
     */
    static RedshiftServerlessAsyncClientBuilder builder() {
        return new DefaultRedshiftServerlessAsyncClientBuilder();
    }
}
