/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.AccountIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Snapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Snapshot> {
    private static final SdkField<List<String>> ACCOUNTS_WITH_PROVISIONED_RESTORE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountsWithProvisionedRestoreAccess").getter(Snapshot.getter(Snapshot::accountsWithProvisionedRestoreAccess)).setter(Snapshot.setter(Builder::accountsWithProvisionedRestoreAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountsWithProvisionedRestoreAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNTS_WITH_RESTORE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountsWithRestoreAccess").getter(Snapshot.getter(Snapshot::accountsWithRestoreAccess)).setter(Snapshot.setter(Builder::accountsWithRestoreAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountsWithRestoreAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("actualIncrementalBackupSizeInMegaBytes").getter(Snapshot.getter(Snapshot::actualIncrementalBackupSizeInMegaBytes)).setter(Snapshot.setter(Builder::actualIncrementalBackupSizeInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualIncrementalBackupSizeInMegaBytes").build()}).build();
    private static final SdkField<String> ADMIN_PASSWORD_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminPasswordSecretArn").getter(Snapshot.getter(Snapshot::adminPasswordSecretArn)).setter(Snapshot.setter(Builder::adminPasswordSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretArn").build()}).build();
    private static final SdkField<String> ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminPasswordSecretKmsKeyId").getter(Snapshot.getter(Snapshot::adminPasswordSecretKmsKeyId)).setter(Snapshot.setter(Builder::adminPasswordSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretKmsKeyId").build()}).build();
    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUsername").getter(Snapshot.getter(Snapshot::adminUsername)).setter(Snapshot.setter(Builder::adminUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()}).build();
    private static final SdkField<Double> BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("backupProgressInMegaBytes").getter(Snapshot.getter(Snapshot::backupProgressInMegaBytes)).setter(Snapshot.setter(Builder::backupProgressInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupProgressInMegaBytes").build()}).build();
    private static final SdkField<Double> CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("currentBackupRateInMegaBytesPerSecond").getter(Snapshot.getter(Snapshot::currentBackupRateInMegaBytesPerSecond)).setter(Snapshot.setter(Builder::currentBackupRateInMegaBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBackupRateInMegaBytesPerSecond").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("elapsedTimeInSeconds").getter(Snapshot.getter(Snapshot::elapsedTimeInSeconds)).setter(Snapshot.setter(Builder::elapsedTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsedTimeInSeconds").build()}).build();
    private static final SdkField<Long> ESTIMATED_SECONDS_TO_COMPLETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("estimatedSecondsToCompletion").getter(Snapshot.getter(Snapshot::estimatedSecondsToCompletion)).setter(Snapshot.setter(Builder::estimatedSecondsToCompletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedSecondsToCompletion").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(Snapshot.getter(Snapshot::kmsKeyId)).setter(Snapshot.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(Snapshot.getter(Snapshot::namespaceArn)).setter(Snapshot.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(Snapshot.getter(Snapshot::namespaceName)).setter(Snapshot.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(Snapshot.getter(Snapshot::ownerAccount)).setter(Snapshot.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotArn").getter(Snapshot.getter(Snapshot::snapshotArn)).setter(Snapshot.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("snapshotCreateTime").getter(Snapshot.getter(Snapshot::snapshotCreateTime)).setter(Snapshot.setter(Builder::snapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(Snapshot.getter(Snapshot::snapshotName)).setter(Snapshot.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_REMAINING_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("snapshotRemainingDays").getter(Snapshot.getter(Snapshot::snapshotRemainingDays)).setter(Snapshot.setter(Builder::snapshotRemainingDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRemainingDays").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("snapshotRetentionPeriod").getter(Snapshot.getter(Snapshot::snapshotRetentionPeriod)).setter(Snapshot.setter(Builder::snapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriod").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_RETENTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("snapshotRetentionStartTime").getter(Snapshot.getter(Snapshot::snapshotRetentionStartTime)).setter(Snapshot.setter(Builder::snapshotRetentionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Snapshot.getter(Snapshot::statusAsString)).setter(Snapshot.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Double> TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("totalBackupSizeInMegaBytes").getter(Snapshot.getter(Snapshot::totalBackupSizeInMegaBytes)).setter(Snapshot.setter(Builder::totalBackupSizeInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBackupSizeInMegaBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_WITH_PROVISIONED_RESTORE_ACCESS_FIELD, ACCOUNTS_WITH_RESTORE_ACCESS_FIELD, ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD, ADMIN_PASSWORD_SECRET_ARN_FIELD, ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD, ADMIN_USERNAME_FIELD, BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD, CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD, ESTIMATED_SECONDS_TO_COMPLETION_FIELD, KMS_KEY_ID_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, OWNER_ACCOUNT_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CREATE_TIME_FIELD, SNAPSHOT_NAME_FIELD, SNAPSHOT_REMAINING_DAYS_FIELD, SNAPSHOT_RETENTION_PERIOD_FIELD, SNAPSHOT_RETENTION_START_TIME_FIELD, STATUS_FIELD, TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Snapshot.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> accountsWithProvisionedRestoreAccess;
    private final List<String> accountsWithRestoreAccess;
    private final Double actualIncrementalBackupSizeInMegaBytes;
    private final String adminPasswordSecretArn;
    private final String adminPasswordSecretKmsKeyId;
    private final String adminUsername;
    private final Double backupProgressInMegaBytes;
    private final Double currentBackupRateInMegaBytesPerSecond;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedSecondsToCompletion;
    private final String kmsKeyId;
    private final String namespaceArn;
    private final String namespaceName;
    private final String ownerAccount;
    private final String snapshotArn;
    private final Instant snapshotCreateTime;
    private final String snapshotName;
    private final Integer snapshotRemainingDays;
    private final Integer snapshotRetentionPeriod;
    private final Instant snapshotRetentionStartTime;
    private final String status;
    private final Double totalBackupSizeInMegaBytes;

    private Snapshot(BuilderImpl builder) {
        this.accountsWithProvisionedRestoreAccess = builder.accountsWithProvisionedRestoreAccess;
        this.accountsWithRestoreAccess = builder.accountsWithRestoreAccess;
        this.actualIncrementalBackupSizeInMegaBytes = builder.actualIncrementalBackupSizeInMegaBytes;
        this.adminPasswordSecretArn = builder.adminPasswordSecretArn;
        this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
        this.adminUsername = builder.adminUsername;
        this.backupProgressInMegaBytes = builder.backupProgressInMegaBytes;
        this.currentBackupRateInMegaBytesPerSecond = builder.currentBackupRateInMegaBytesPerSecond;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedSecondsToCompletion = builder.estimatedSecondsToCompletion;
        this.kmsKeyId = builder.kmsKeyId;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.ownerAccount = builder.ownerAccount;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.snapshotName = builder.snapshotName;
        this.snapshotRemainingDays = builder.snapshotRemainingDays;
        this.snapshotRetentionPeriod = builder.snapshotRetentionPeriod;
        this.snapshotRetentionStartTime = builder.snapshotRetentionStartTime;
        this.status = builder.status;
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
    }

    public final boolean hasAccountsWithProvisionedRestoreAccess() {
        return this.accountsWithProvisionedRestoreAccess != null && !(this.accountsWithProvisionedRestoreAccess instanceof SdkAutoConstructList);
    }

    public final List<String> accountsWithProvisionedRestoreAccess() {
        return this.accountsWithProvisionedRestoreAccess;
    }

    public final boolean hasAccountsWithRestoreAccess() {
        return this.accountsWithRestoreAccess != null && !(this.accountsWithRestoreAccess instanceof SdkAutoConstructList);
    }

    public final List<String> accountsWithRestoreAccess() {
        return this.accountsWithRestoreAccess;
    }

    public final Double actualIncrementalBackupSizeInMegaBytes() {
        return this.actualIncrementalBackupSizeInMegaBytes;
    }

    public final String adminPasswordSecretArn() {
        return this.adminPasswordSecretArn;
    }

    public final String adminPasswordSecretKmsKeyId() {
        return this.adminPasswordSecretKmsKeyId;
    }

    public final String adminUsername() {
        return this.adminUsername;
    }

    public final Double backupProgressInMegaBytes() {
        return this.backupProgressInMegaBytes;
    }

    public final Double currentBackupRateInMegaBytesPerSecond() {
        return this.currentBackupRateInMegaBytesPerSecond;
    }

    public final Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public final Long estimatedSecondsToCompletion() {
        return this.estimatedSecondsToCompletion;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final Integer snapshotRemainingDays() {
        return this.snapshotRemainingDays;
    }

    public final Integer snapshotRetentionPeriod() {
        return this.snapshotRetentionPeriod;
    }

    public final Instant snapshotRetentionStartTime() {
        return this.snapshotRetentionStartTime;
    }

    public final SnapshotStatus status() {
        return SnapshotStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Double totalBackupSizeInMegaBytes() {
        return this.totalBackupSizeInMegaBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountsWithProvisionedRestoreAccess() ? this.accountsWithProvisionedRestoreAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountsWithRestoreAccess() ? this.accountsWithRestoreAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.actualIncrementalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPasswordSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupProgressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBackupRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSecondsToCompletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRemainingDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBackupSizeInMegaBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return this.hasAccountsWithProvisionedRestoreAccess() == other.hasAccountsWithProvisionedRestoreAccess() && Objects.equals(this.accountsWithProvisionedRestoreAccess(), other.accountsWithProvisionedRestoreAccess()) && this.hasAccountsWithRestoreAccess() == other.hasAccountsWithRestoreAccess() && Objects.equals(this.accountsWithRestoreAccess(), other.accountsWithRestoreAccess()) && Objects.equals(this.actualIncrementalBackupSizeInMegaBytes(), other.actualIncrementalBackupSizeInMegaBytes()) && Objects.equals(this.adminPasswordSecretArn(), other.adminPasswordSecretArn()) && Objects.equals(this.adminPasswordSecretKmsKeyId(), other.adminPasswordSecretKmsKeyId()) && Objects.equals(this.adminUsername(), other.adminUsername()) && Objects.equals(this.backupProgressInMegaBytes(), other.backupProgressInMegaBytes()) && Objects.equals(this.currentBackupRateInMegaBytesPerSecond(), other.currentBackupRateInMegaBytesPerSecond()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.estimatedSecondsToCompletion(), other.estimatedSecondsToCompletion()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.snapshotRemainingDays(), other.snapshotRemainingDays()) && Objects.equals(this.snapshotRetentionPeriod(), other.snapshotRetentionPeriod()) && Objects.equals(this.snapshotRetentionStartTime(), other.snapshotRetentionStartTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes());
    }

    public final String toString() {
        return ToString.builder((String)"Snapshot").add("AccountsWithProvisionedRestoreAccess", this.hasAccountsWithProvisionedRestoreAccess() ? this.accountsWithProvisionedRestoreAccess() : null).add("AccountsWithRestoreAccess", this.hasAccountsWithRestoreAccess() ? this.accountsWithRestoreAccess() : null).add("ActualIncrementalBackupSizeInMegaBytes", (Object)this.actualIncrementalBackupSizeInMegaBytes()).add("AdminPasswordSecretArn", (Object)this.adminPasswordSecretArn()).add("AdminPasswordSecretKmsKeyId", (Object)this.adminPasswordSecretKmsKeyId()).add("AdminUsername", (Object)this.adminUsername()).add("BackupProgressInMegaBytes", (Object)this.backupProgressInMegaBytes()).add("CurrentBackupRateInMegaBytesPerSecond", (Object)this.currentBackupRateInMegaBytesPerSecond()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).add("EstimatedSecondsToCompletion", (Object)this.estimatedSecondsToCompletion()).add("KmsKeyId", (Object)this.kmsKeyId()).add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).add("OwnerAccount", (Object)this.ownerAccount()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("SnapshotName", (Object)this.snapshotName()).add("SnapshotRemainingDays", (Object)this.snapshotRemainingDays()).add("SnapshotRetentionPeriod", (Object)this.snapshotRetentionPeriod()).add("SnapshotRetentionStartTime", (Object)this.snapshotRetentionStartTime()).add("Status", (Object)this.statusAsString()).add("TotalBackupSizeInMegaBytes", (Object)this.totalBackupSizeInMegaBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountsWithProvisionedRestoreAccess": {
                return Optional.ofNullable(clazz.cast(this.accountsWithProvisionedRestoreAccess()));
            }
            case "accountsWithRestoreAccess": {
                return Optional.ofNullable(clazz.cast(this.accountsWithRestoreAccess()));
            }
            case "actualIncrementalBackupSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.actualIncrementalBackupSizeInMegaBytes()));
            }
            case "adminPasswordSecretArn": {
                return Optional.ofNullable(clazz.cast(this.adminPasswordSecretArn()));
            }
            case "adminPasswordSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.adminPasswordSecretKmsKeyId()));
            }
            case "adminUsername": {
                return Optional.ofNullable(clazz.cast(this.adminUsername()));
            }
            case "backupProgressInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.backupProgressInMegaBytes()));
            }
            case "currentBackupRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.currentBackupRateInMegaBytesPerSecond()));
            }
            case "elapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "estimatedSecondsToCompletion": {
                return Optional.ofNullable(clazz.cast(this.estimatedSecondsToCompletion()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "snapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "snapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "snapshotRemainingDays": {
                return Optional.ofNullable(clazz.cast(this.snapshotRemainingDays()));
            }
            case "snapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionPeriod()));
            }
            case "snapshotRetentionStartTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionStartTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "totalBackupSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalBackupSizeInMegaBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountsWithProvisionedRestoreAccess", ACCOUNTS_WITH_PROVISIONED_RESTORE_ACCESS_FIELD);
        map.put("accountsWithRestoreAccess", ACCOUNTS_WITH_RESTORE_ACCESS_FIELD);
        map.put("actualIncrementalBackupSizeInMegaBytes", ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD);
        map.put("adminPasswordSecretArn", ADMIN_PASSWORD_SECRET_ARN_FIELD);
        map.put("adminPasswordSecretKmsKeyId", ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD);
        map.put("adminUsername", ADMIN_USERNAME_FIELD);
        map.put("backupProgressInMegaBytes", BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD);
        map.put("currentBackupRateInMegaBytesPerSecond", CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD);
        map.put("elapsedTimeInSeconds", ELAPSED_TIME_IN_SECONDS_FIELD);
        map.put("estimatedSecondsToCompletion", ESTIMATED_SECONDS_TO_COMPLETION_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("namespaceArn", NAMESPACE_ARN_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("snapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("snapshotCreateTime", SNAPSHOT_CREATE_TIME_FIELD);
        map.put("snapshotName", SNAPSHOT_NAME_FIELD);
        map.put("snapshotRemainingDays", SNAPSHOT_REMAINING_DAYS_FIELD);
        map.put("snapshotRetentionPeriod", SNAPSHOT_RETENTION_PERIOD_FIELD);
        map.put("snapshotRetentionStartTime", SNAPSHOT_RETENTION_START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("totalBackupSizeInMegaBytes", TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountsWithProvisionedRestoreAccess = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountsWithRestoreAccess = DefaultSdkAutoConstructList.getInstance();
        private Double actualIncrementalBackupSizeInMegaBytes;
        private String adminPasswordSecretArn;
        private String adminPasswordSecretKmsKeyId;
        private String adminUsername;
        private Double backupProgressInMegaBytes;
        private Double currentBackupRateInMegaBytesPerSecond;
        private Long elapsedTimeInSeconds;
        private Long estimatedSecondsToCompletion;
        private String kmsKeyId;
        private String namespaceArn;
        private String namespaceName;
        private String ownerAccount;
        private String snapshotArn;
        private Instant snapshotCreateTime;
        private String snapshotName;
        private Integer snapshotRemainingDays;
        private Integer snapshotRetentionPeriod;
        private Instant snapshotRetentionStartTime;
        private String status;
        private Double totalBackupSizeInMegaBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.accountsWithProvisionedRestoreAccess(model.accountsWithProvisionedRestoreAccess);
            this.accountsWithRestoreAccess(model.accountsWithRestoreAccess);
            this.actualIncrementalBackupSizeInMegaBytes(model.actualIncrementalBackupSizeInMegaBytes);
            this.adminPasswordSecretArn(model.adminPasswordSecretArn);
            this.adminPasswordSecretKmsKeyId(model.adminPasswordSecretKmsKeyId);
            this.adminUsername(model.adminUsername);
            this.backupProgressInMegaBytes(model.backupProgressInMegaBytes);
            this.currentBackupRateInMegaBytesPerSecond(model.currentBackupRateInMegaBytesPerSecond);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedSecondsToCompletion(model.estimatedSecondsToCompletion);
            this.kmsKeyId(model.kmsKeyId);
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
            this.ownerAccount(model.ownerAccount);
            this.snapshotArn(model.snapshotArn);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.snapshotName(model.snapshotName);
            this.snapshotRemainingDays(model.snapshotRemainingDays);
            this.snapshotRetentionPeriod(model.snapshotRetentionPeriod);
            this.snapshotRetentionStartTime(model.snapshotRetentionStartTime);
            this.status(model.status);
            this.totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
        }

        public final Collection<String> getAccountsWithProvisionedRestoreAccess() {
            if (this.accountsWithProvisionedRestoreAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountsWithProvisionedRestoreAccess;
        }

        public final void setAccountsWithProvisionedRestoreAccess(Collection<String> accountsWithProvisionedRestoreAccess) {
            this.accountsWithProvisionedRestoreAccess = AccountIdListCopier.copy(accountsWithProvisionedRestoreAccess);
        }

        @Override
        public final Builder accountsWithProvisionedRestoreAccess(Collection<String> accountsWithProvisionedRestoreAccess) {
            this.accountsWithProvisionedRestoreAccess = AccountIdListCopier.copy(accountsWithProvisionedRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithProvisionedRestoreAccess(String ... accountsWithProvisionedRestoreAccess) {
            this.accountsWithProvisionedRestoreAccess(Arrays.asList(accountsWithProvisionedRestoreAccess));
            return this;
        }

        public final Collection<String> getAccountsWithRestoreAccess() {
            if (this.accountsWithRestoreAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountsWithRestoreAccess;
        }

        public final void setAccountsWithRestoreAccess(Collection<String> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountIdListCopier.copy(accountsWithRestoreAccess);
        }

        @Override
        public final Builder accountsWithRestoreAccess(Collection<String> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountIdListCopier.copy(accountsWithRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(String ... accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess(Arrays.asList(accountsWithRestoreAccess));
            return this;
        }

        public final Double getActualIncrementalBackupSizeInMegaBytes() {
            return this.actualIncrementalBackupSizeInMegaBytes;
        }

        public final void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
            return this;
        }

        public final String getAdminPasswordSecretArn() {
            return this.adminPasswordSecretArn;
        }

        public final void setAdminPasswordSecretArn(String adminPasswordSecretArn) {
            this.adminPasswordSecretArn = adminPasswordSecretArn;
        }

        @Override
        public final Builder adminPasswordSecretArn(String adminPasswordSecretArn) {
            this.adminPasswordSecretArn = adminPasswordSecretArn;
            return this;
        }

        public final String getAdminPasswordSecretKmsKeyId() {
            return this.adminPasswordSecretKmsKeyId;
        }

        public final void setAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
            return this;
        }

        public final String getAdminUsername() {
            return this.adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final Double getBackupProgressInMegaBytes() {
            return this.backupProgressInMegaBytes;
        }

        public final void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        }

        @Override
        public final Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
            return this;
        }

        public final Double getCurrentBackupRateInMegaBytesPerSecond() {
            return this.currentBackupRateInMegaBytesPerSecond;
        }

        public final void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final Long getEstimatedSecondsToCompletion() {
            return this.estimatedSecondsToCompletion;
        }

        public final void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        }

        @Override
        public final Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final Integer getSnapshotRemainingDays() {
            return this.snapshotRemainingDays;
        }

        public final void setSnapshotRemainingDays(Integer snapshotRemainingDays) {
            this.snapshotRemainingDays = snapshotRemainingDays;
        }

        @Override
        public final Builder snapshotRemainingDays(Integer snapshotRemainingDays) {
            this.snapshotRemainingDays = snapshotRemainingDays;
            return this;
        }

        public final Integer getSnapshotRetentionPeriod() {
            return this.snapshotRetentionPeriod;
        }

        public final void setSnapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
        }

        @Override
        public final Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
            return this;
        }

        public final Instant getSnapshotRetentionStartTime() {
            return this.snapshotRetentionStartTime;
        }

        public final void setSnapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
        }

        @Override
        public final Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return this.totalBackupSizeInMegaBytes;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Snapshot> {
        public Builder accountsWithProvisionedRestoreAccess(Collection<String> var1);

        public Builder accountsWithProvisionedRestoreAccess(String ... var1);

        public Builder accountsWithRestoreAccess(Collection<String> var1);

        public Builder accountsWithRestoreAccess(String ... var1);

        public Builder actualIncrementalBackupSizeInMegaBytes(Double var1);

        public Builder adminPasswordSecretArn(String var1);

        public Builder adminPasswordSecretKmsKeyId(String var1);

        public Builder adminUsername(String var1);

        public Builder backupProgressInMegaBytes(Double var1);

        public Builder currentBackupRateInMegaBytesPerSecond(Double var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedSecondsToCompletion(Long var1);

        public Builder kmsKeyId(String var1);

        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);

        public Builder ownerAccount(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder snapshotName(String var1);

        public Builder snapshotRemainingDays(Integer var1);

        public Builder snapshotRetentionPeriod(Integer var1);

        public Builder snapshotRetentionStartTime(Instant var1);

        public Builder status(String var1);

        public Builder status(SnapshotStatus var1);

        public Builder totalBackupSizeInMegaBytes(Double var1);
    }
}

