/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUsageLimitRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, UpdateUsageLimitRequest> {
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("amount").getter(UpdateUsageLimitRequest.getter(UpdateUsageLimitRequest::amount)).setter(UpdateUsageLimitRequest.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()}).build();
    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("breachAction").getter(UpdateUsageLimitRequest.getter(UpdateUsageLimitRequest::breachActionAsString)).setter(UpdateUsageLimitRequest.setter(Builder::breachAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breachAction").build()}).build();
    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageLimitId").getter(UpdateUsageLimitRequest.getter(UpdateUsageLimitRequest::usageLimitId)).setter(UpdateUsageLimitRequest.setter(Builder::usageLimitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, BREACH_ACTION_FIELD, USAGE_LIMIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUsageLimitRequest.memberNameToFieldInitializer();
    private final Long amount;
    private final String breachAction;
    private final String usageLimitId;

    private UpdateUsageLimitRequest(BuilderImpl builder) {
        super(builder);
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
        this.usageLimitId = builder.usageLimitId;
    }

    public final Long amount() {
        return this.amount;
    }

    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(this.breachAction);
    }

    public final String breachActionAsString() {
        return this.breachAction;
    }

    public final String usageLimitId() {
        return this.usageLimitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageLimitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUsageLimitRequest)) {
            return false;
        }
        UpdateUsageLimitRequest other = (UpdateUsageLimitRequest)((Object)obj);
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.breachActionAsString(), other.breachActionAsString()) && Objects.equals(this.usageLimitId(), other.usageLimitId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUsageLimitRequest").add("Amount", (Object)this.amount()).add("BreachAction", (Object)this.breachActionAsString()).add("UsageLimitId", (Object)this.usageLimitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "breachAction": {
                return Optional.ofNullable(clazz.cast(this.breachActionAsString()));
            }
            case "usageLimitId": {
                return Optional.ofNullable(clazz.cast(this.usageLimitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", AMOUNT_FIELD);
        map.put("breachAction", BREACH_ACTION_FIELD);
        map.put("usageLimitId", USAGE_LIMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUsageLimitRequest, T> g) {
        return obj -> g.apply((UpdateUsageLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private Long amount;
        private String breachAction;
        private String usageLimitId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUsageLimitRequest model) {
            super(model);
            this.amount(model.amount);
            this.breachAction(model.breachAction);
            this.usageLimitId(model.usageLimitId);
        }

        public final Long getAmount() {
            return this.amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return this.breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final String getUsageLimitId() {
            return this.usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUsageLimitRequest build() {
            return new UpdateUsageLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUsageLimitRequest> {
        public Builder amount(Long var1);

        public Builder breachAction(String var1);

        public Builder breachAction(UsageLimitBreachAction var1);

        public Builder usageLimitId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

