/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateTarget;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateTargetsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerlessTrack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerlessTrack> {
    private static final SdkField<String> TRACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackName").getter(ServerlessTrack.getter(ServerlessTrack::trackName)).setter(ServerlessTrack.setter(Builder::trackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackName").build()}).build();
    private static final SdkField<List<UpdateTarget>> UPDATE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("updateTargets").getter(ServerlessTrack.getter(ServerlessTrack::updateTargets)).setter(ServerlessTrack.setter(Builder::updateTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKGROUP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupVersion").getter(ServerlessTrack.getter(ServerlessTrack::workgroupVersion)).setter(ServerlessTrack.setter(Builder::workgroupVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACK_NAME_FIELD, UPDATE_TARGETS_FIELD, WORKGROUP_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerlessTrack.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trackName;
    private final List<UpdateTarget> updateTargets;
    private final String workgroupVersion;

    private ServerlessTrack(BuilderImpl builder) {
        this.trackName = builder.trackName;
        this.updateTargets = builder.updateTargets;
        this.workgroupVersion = builder.workgroupVersion;
    }

    public final String trackName() {
        return this.trackName;
    }

    public final boolean hasUpdateTargets() {
        return this.updateTargets != null && !(this.updateTargets instanceof SdkAutoConstructList);
    }

    public final List<UpdateTarget> updateTargets() {
        return this.updateTargets;
    }

    public final String workgroupVersion() {
        return this.workgroupVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateTargets() ? this.updateTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessTrack)) {
            return false;
        }
        ServerlessTrack other = (ServerlessTrack)obj;
        return Objects.equals(this.trackName(), other.trackName()) && this.hasUpdateTargets() == other.hasUpdateTargets() && Objects.equals(this.updateTargets(), other.updateTargets()) && Objects.equals(this.workgroupVersion(), other.workgroupVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ServerlessTrack").add("TrackName", (Object)this.trackName()).add("UpdateTargets", this.hasUpdateTargets() ? this.updateTargets() : null).add("WorkgroupVersion", (Object)this.workgroupVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trackName": {
                return Optional.ofNullable(clazz.cast(this.trackName()));
            }
            case "updateTargets": {
                return Optional.ofNullable(clazz.cast(this.updateTargets()));
            }
            case "workgroupVersion": {
                return Optional.ofNullable(clazz.cast(this.workgroupVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trackName", TRACK_NAME_FIELD);
        map.put("updateTargets", UPDATE_TARGETS_FIELD);
        map.put("workgroupVersion", WORKGROUP_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessTrack, T> g) {
        return obj -> g.apply((ServerlessTrack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trackName;
        private List<UpdateTarget> updateTargets = DefaultSdkAutoConstructList.getInstance();
        private String workgroupVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessTrack model) {
            this.trackName(model.trackName);
            this.updateTargets(model.updateTargets);
            this.workgroupVersion(model.workgroupVersion);
        }

        public final String getTrackName() {
            return this.trackName;
        }

        public final void setTrackName(String trackName) {
            this.trackName = trackName;
        }

        @Override
        public final Builder trackName(String trackName) {
            this.trackName = trackName;
            return this;
        }

        public final List<UpdateTarget.Builder> getUpdateTargets() {
            List<UpdateTarget.Builder> result = UpdateTargetsListCopier.copyToBuilder(this.updateTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateTargets(Collection<UpdateTarget.BuilderImpl> updateTargets) {
            this.updateTargets = UpdateTargetsListCopier.copyFromBuilder(updateTargets);
        }

        @Override
        public final Builder updateTargets(Collection<UpdateTarget> updateTargets) {
            this.updateTargets = UpdateTargetsListCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(UpdateTarget ... updateTargets) {
            this.updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(Consumer<UpdateTarget.Builder> ... updateTargets) {
            this.updateTargets(Stream.of(updateTargets).map(c -> (UpdateTarget)((UpdateTarget.Builder)UpdateTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkgroupVersion() {
            return this.workgroupVersion;
        }

        public final void setWorkgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
        }

        @Override
        public final Builder workgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
            return this;
        }

        public ServerlessTrack build() {
            return new ServerlessTrack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerlessTrack> {
        public Builder trackName(String var1);

        public Builder updateTargets(Collection<UpdateTarget> var1);

        public Builder updateTargets(UpdateTarget ... var1);

        public Builder updateTargets(Consumer<UpdateTarget.Builder> ... var1);

        public Builder workgroupVersion(String var1);
    }
}

