/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitPeriod;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUsageLimitRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, CreateUsageLimitRequest> {
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("amount").getter(CreateUsageLimitRequest.getter(CreateUsageLimitRequest::amount)).setter(CreateUsageLimitRequest.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()}).build();
    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("breachAction").getter(CreateUsageLimitRequest.getter(CreateUsageLimitRequest::breachActionAsString)).setter(CreateUsageLimitRequest.setter(Builder::breachAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breachAction").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(CreateUsageLimitRequest.getter(CreateUsageLimitRequest::periodAsString)).setter(CreateUsageLimitRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(CreateUsageLimitRequest.getter(CreateUsageLimitRequest::resourceArn)).setter(CreateUsageLimitRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(CreateUsageLimitRequest.getter(CreateUsageLimitRequest::usageTypeAsString)).setter(CreateUsageLimitRequest.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, BREACH_ACTION_FIELD, PERIOD_FIELD, RESOURCE_ARN_FIELD, USAGE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateUsageLimitRequest.memberNameToFieldInitializer();
    private final Long amount;
    private final String breachAction;
    private final String period;
    private final String resourceArn;
    private final String usageType;

    private CreateUsageLimitRequest(BuilderImpl builder) {
        super(builder);
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
        this.period = builder.period;
        this.resourceArn = builder.resourceArn;
        this.usageType = builder.usageType;
    }

    public final Long amount() {
        return this.amount;
    }

    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(this.breachAction);
    }

    public final String breachActionAsString() {
        return this.breachAction;
    }

    public final UsageLimitPeriod period() {
        return UsageLimitPeriod.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final UsageLimitUsageType usageType() {
        return UsageLimitUsageType.fromValue(this.usageType);
    }

    public final String usageTypeAsString() {
        return this.usageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsageLimitRequest)) {
            return false;
        }
        CreateUsageLimitRequest other = (CreateUsageLimitRequest)((Object)obj);
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.breachActionAsString(), other.breachActionAsString()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.usageTypeAsString(), other.usageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUsageLimitRequest").add("Amount", (Object)this.amount()).add("BreachAction", (Object)this.breachActionAsString()).add("Period", (Object)this.periodAsString()).add("ResourceArn", (Object)this.resourceArn()).add("UsageType", (Object)this.usageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "breachAction": {
                return Optional.ofNullable(clazz.cast(this.breachActionAsString()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", AMOUNT_FIELD);
        map.put("breachAction", BREACH_ACTION_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUsageLimitRequest, T> g) {
        return obj -> g.apply((CreateUsageLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private Long amount;
        private String breachAction;
        private String period;
        private String resourceArn;
        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsageLimitRequest model) {
            super(model);
            this.amount(model.amount);
            this.breachAction(model.breachAction);
            this.period(model.period);
            this.resourceArn(model.resourceArn);
            this.usageType(model.usageType);
        }

        public final Long getAmount() {
            return this.amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return this.breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(UsageLimitPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public final Builder usageType(UsageLimitUsageType usageType) {
            this.usageType(usageType == null ? null : usageType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUsageLimitRequest build() {
            return new CreateUsageLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUsageLimitRequest> {
        public Builder amount(Long var1);

        public Builder breachAction(String var1);

        public Builder breachAction(UsageLimitBreachAction var1);

        public Builder period(String var1);

        public Builder period(UsageLimitPeriod var1);

        public Builder resourceArn(String var1);

        public Builder usageType(String var1);

        public Builder usageType(UsageLimitUsageType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

