/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServerlessTrack;

public class ListTracksIterable
implements SdkIterable<ListTracksResponse> {
    private final RedshiftServerlessClient client;
    private final ListTracksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTracksIterable(RedshiftServerlessClient client, ListTracksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTracksResponseFetcher();
    }

    public Iterator<ListTracksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServerlessTrack> tracks() {
        Function<ListTracksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tracks() != null) {
                return response.tracks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTracksResponseFetcher
    implements SyncPageFetcher<ListTracksResponse> {
        private ListTracksResponseFetcher() {
        }

        public boolean hasNextPage(ListTracksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTracksResponse nextPage(ListTracksResponse previousPage) {
            if (previousPage == null) {
                return ListTracksIterable.this.client.listTracks(ListTracksIterable.this.firstRequest);
            }
            return ListTracksIterable.this.client.listTracks((ListTracksRequest)((Object)ListTracksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

