/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ManagedWorkgroupListItem;

public class ListManagedWorkgroupsPublisher
implements SdkPublisher<ListManagedWorkgroupsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListManagedWorkgroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedWorkgroupsPublisher(RedshiftServerlessAsyncClient client, ListManagedWorkgroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedWorkgroupsPublisher(RedshiftServerlessAsyncClient client, ListManagedWorkgroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedWorkgroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedWorkgroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedWorkgroupListItem> managedWorkgroups() {
        Function<ListManagedWorkgroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedWorkgroups() != null) {
                return response.managedWorkgroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedWorkgroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedWorkgroupsResponseFetcher
    implements AsyncPageFetcher<ListManagedWorkgroupsResponse> {
        private ListManagedWorkgroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedWorkgroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedWorkgroupsResponse> nextPage(ListManagedWorkgroupsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedWorkgroupsPublisher.this.client.listManagedWorkgroups(ListManagedWorkgroupsPublisher.this.firstRequest);
            }
            return ListManagedWorkgroupsPublisher.this.client.listManagedWorkgroups((ListManagedWorkgroupsRequest)((Object)ListManagedWorkgroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

