/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServerlessTrack;

public class ListTracksPublisher
implements SdkPublisher<ListTracksResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListTracksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTracksPublisher(RedshiftServerlessAsyncClient client, ListTracksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTracksPublisher(RedshiftServerlessAsyncClient client, ListTracksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTracksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTracksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServerlessTrack> tracks() {
        Function<ListTracksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tracks() != null) {
                return response.tracks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTracksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTracksResponseFetcher
    implements AsyncPageFetcher<ListTracksResponse> {
        private ListTracksResponseFetcher() {
        }

        public boolean hasNextPage(ListTracksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTracksResponse> nextPage(ListTracksResponse previousPage) {
            if (previousPage == null) {
                return ListTracksPublisher.this.client.listTracks(ListTracksPublisher.this.firstRequest);
            }
            return ListTracksPublisher.this.client.listTracks((ListTracksRequest)((Object)ListTracksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

