/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionAssociation;

public class ListScheduledActionsPublisher
implements SdkPublisher<ListScheduledActionsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListScheduledActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScheduledActionsPublisher(RedshiftServerlessAsyncClient client, ListScheduledActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScheduledActionsPublisher(RedshiftServerlessAsyncClient client, ListScheduledActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScheduledActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScheduledActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledActionAssociation> scheduledActions() {
        Function<ListScheduledActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledActions() != null) {
                return response.scheduledActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScheduledActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScheduledActionsResponseFetcher
    implements AsyncPageFetcher<ListScheduledActionsResponse> {
        private ListScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScheduledActionsResponse> nextPage(ListScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledActionsPublisher.this.client.listScheduledActions(ListScheduledActionsPublisher.this.firstRequest);
            }
            return ListScheduledActionsPublisher.this.client.listScheduledActions((ListScheduledActionsRequest)((Object)ListScheduledActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

