/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.ManagedWorkgroupListItem;
import software.amazon.awssdk.services.redshiftserverless.model.ManagedWorkgroupsCopier;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedWorkgroupsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListManagedWorkgroupsResponse> {
    private static final SdkField<List<ManagedWorkgroupListItem>> MANAGED_WORKGROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedWorkgroups").getter(ListManagedWorkgroupsResponse.getter(ListManagedWorkgroupsResponse::managedWorkgroups)).setter(ListManagedWorkgroupsResponse.setter(Builder::managedWorkgroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWorkgroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedWorkgroupListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedWorkgroupsResponse.getter(ListManagedWorkgroupsResponse::nextToken)).setter(ListManagedWorkgroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_WORKGROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedWorkgroupsResponse.memberNameToFieldInitializer();
    private final List<ManagedWorkgroupListItem> managedWorkgroups;
    private final String nextToken;

    private ListManagedWorkgroupsResponse(BuilderImpl builder) {
        super(builder);
        this.managedWorkgroups = builder.managedWorkgroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasManagedWorkgroups() {
        return this.managedWorkgroups != null && !(this.managedWorkgroups instanceof SdkAutoConstructList);
    }

    public final List<ManagedWorkgroupListItem> managedWorkgroups() {
        return this.managedWorkgroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedWorkgroups() ? this.managedWorkgroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedWorkgroupsResponse)) {
            return false;
        }
        ListManagedWorkgroupsResponse other = (ListManagedWorkgroupsResponse)((Object)obj);
        return this.hasManagedWorkgroups() == other.hasManagedWorkgroups() && Objects.equals(this.managedWorkgroups(), other.managedWorkgroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedWorkgroupsResponse").add("ManagedWorkgroups", this.hasManagedWorkgroups() ? this.managedWorkgroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managedWorkgroups": {
                return Optional.ofNullable(clazz.cast(this.managedWorkgroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("managedWorkgroups", MANAGED_WORKGROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedWorkgroupsResponse, T> g) {
        return obj -> g.apply((ListManagedWorkgroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private List<ManagedWorkgroupListItem> managedWorkgroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedWorkgroupsResponse model) {
            super(model);
            this.managedWorkgroups(model.managedWorkgroups);
            this.nextToken(model.nextToken);
        }

        public final List<ManagedWorkgroupListItem.Builder> getManagedWorkgroups() {
            List<ManagedWorkgroupListItem.Builder> result = ManagedWorkgroupsCopier.copyToBuilder(this.managedWorkgroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedWorkgroups(Collection<ManagedWorkgroupListItem.BuilderImpl> managedWorkgroups) {
            this.managedWorkgroups = ManagedWorkgroupsCopier.copyFromBuilder(managedWorkgroups);
        }

        @Override
        public final Builder managedWorkgroups(Collection<ManagedWorkgroupListItem> managedWorkgroups) {
            this.managedWorkgroups = ManagedWorkgroupsCopier.copy(managedWorkgroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWorkgroups(ManagedWorkgroupListItem ... managedWorkgroups) {
            this.managedWorkgroups(Arrays.asList(managedWorkgroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWorkgroups(Consumer<ManagedWorkgroupListItem.Builder> ... managedWorkgroups) {
            this.managedWorkgroups(Stream.of(managedWorkgroups).map(c -> (ManagedWorkgroupListItem)((ManagedWorkgroupListItem.Builder)ManagedWorkgroupListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListManagedWorkgroupsResponse build() {
            return new ListManagedWorkgroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedWorkgroupsResponse> {
        public Builder managedWorkgroups(Collection<ManagedWorkgroupListItem> var1);

        public Builder managedWorkgroups(ManagedWorkgroupListItem ... var1);

        public Builder managedWorkgroups(Consumer<ManagedWorkgroupListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

