/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter;
import software.amazon.awssdk.services.redshiftserverless.model.ConfigParameterListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.PerformanceTarget;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.SubnetIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.Tag;
import software.amazon.awssdk.services.redshiftserverless.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkgroupRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, CreateWorkgroupRequest> {
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseCapacity").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::baseCapacity)).setter(CreateWorkgroupRequest.setter(Builder::baseCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()}).build();
    private static final SdkField<List<ConfigParameter>> CONFIG_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configParameters").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::configParameters)).setter(CreateWorkgroupRequest.setter(Builder::configParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedVpcRouting").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::enhancedVpcRouting)).setter(CreateWorkgroupRequest.setter(Builder::enhancedVpcRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedVpcRouting").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::ipAddressType)).setter(CreateWorkgroupRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCapacity").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::maxCapacity)).setter(CreateWorkgroupRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::namespaceName)).setter(CreateWorkgroupRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::port)).setter(CreateWorkgroupRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<PerformanceTarget> PRICE_PERFORMANCE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pricePerformanceTarget").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::pricePerformanceTarget)).setter(CreateWorkgroupRequest.setter(Builder::pricePerformanceTarget)).constructor(PerformanceTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricePerformanceTarget").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::publiclyAccessible)).setter(CreateWorkgroupRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::securityGroupIds)).setter(CreateWorkgroupRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::subnetIds)).setter(CreateWorkgroupRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::tags)).setter(CreateWorkgroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(CreateWorkgroupRequest.getter(CreateWorkgroupRequest::workgroupName)).setter(CreateWorkgroupRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CAPACITY_FIELD, CONFIG_PARAMETERS_FIELD, ENHANCED_VPC_ROUTING_FIELD, IP_ADDRESS_TYPE_FIELD, MAX_CAPACITY_FIELD, NAMESPACE_NAME_FIELD, PORT_FIELD, PRICE_PERFORMANCE_TARGET_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkgroupRequest.memberNameToFieldInitializer();
    private final Integer baseCapacity;
    private final List<ConfigParameter> configParameters;
    private final Boolean enhancedVpcRouting;
    private final String ipAddressType;
    private final Integer maxCapacity;
    private final String namespaceName;
    private final Integer port;
    private final PerformanceTarget pricePerformanceTarget;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;
    private final List<Tag> tags;
    private final String workgroupName;

    private CreateWorkgroupRequest(BuilderImpl builder) {
        super(builder);
        this.baseCapacity = builder.baseCapacity;
        this.configParameters = builder.configParameters;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.ipAddressType = builder.ipAddressType;
        this.maxCapacity = builder.maxCapacity;
        this.namespaceName = builder.namespaceName;
        this.port = builder.port;
        this.pricePerformanceTarget = builder.pricePerformanceTarget;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.workgroupName = builder.workgroupName;
    }

    public final Integer baseCapacity() {
        return this.baseCapacity;
    }

    public final boolean hasConfigParameters() {
        return this.configParameters != null && !(this.configParameters instanceof SdkAutoConstructList);
    }

    public final List<ConfigParameter> configParameters() {
        return this.configParameters;
    }

    public final Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public final String ipAddressType() {
        return this.ipAddressType;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final Integer port() {
        return this.port;
    }

    public final PerformanceTarget pricePerformanceTarget() {
        return this.pricePerformanceTarget;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigParameters() ? this.configParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricePerformanceTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkgroupRequest)) {
            return false;
        }
        CreateWorkgroupRequest other = (CreateWorkgroupRequest)((Object)obj);
        return Objects.equals(this.baseCapacity(), other.baseCapacity()) && this.hasConfigParameters() == other.hasConfigParameters() && Objects.equals(this.configParameters(), other.configParameters()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.ipAddressType(), other.ipAddressType()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.pricePerformanceTarget(), other.pricePerformanceTarget()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkgroupRequest").add("BaseCapacity", (Object)this.baseCapacity()).add("ConfigParameters", this.hasConfigParameters() ? this.configParameters() : null).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("IpAddressType", (Object)this.ipAddressType()).add("MaxCapacity", (Object)this.maxCapacity()).add("NamespaceName", (Object)this.namespaceName()).add("Port", (Object)this.port()).add("PricePerformanceTarget", (Object)this.pricePerformanceTarget()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseCapacity": {
                return Optional.ofNullable(clazz.cast(this.baseCapacity()));
            }
            case "configParameters": {
                return Optional.ofNullable(clazz.cast(this.configParameters()));
            }
            case "enhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressType()));
            }
            case "maxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "pricePerformanceTarget": {
                return Optional.ofNullable(clazz.cast(this.pricePerformanceTarget()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("baseCapacity", BASE_CAPACITY_FIELD);
        map.put("configParameters", CONFIG_PARAMETERS_FIELD);
        map.put("enhancedVpcRouting", ENHANCED_VPC_ROUTING_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("maxCapacity", MAX_CAPACITY_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("pricePerformanceTarget", PRICE_PERFORMANCE_TARGET_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkgroupRequest, T> g) {
        return obj -> g.apply((CreateWorkgroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private Integer baseCapacity;
        private List<ConfigParameter> configParameters = DefaultSdkAutoConstructList.getInstance();
        private Boolean enhancedVpcRouting;
        private String ipAddressType;
        private Integer maxCapacity;
        private String namespaceName;
        private Integer port;
        private PerformanceTarget pricePerformanceTarget;
        private Boolean publiclyAccessible;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkgroupRequest model) {
            super(model);
            this.baseCapacity(model.baseCapacity);
            this.configParameters(model.configParameters);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.ipAddressType(model.ipAddressType);
            this.maxCapacity(model.maxCapacity);
            this.namespaceName(model.namespaceName);
            this.port(model.port);
            this.pricePerformanceTarget(model.pricePerformanceTarget);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.workgroupName(model.workgroupName);
        }

        public final Integer getBaseCapacity() {
            return this.baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final List<ConfigParameter.Builder> getConfigParameters() {
            List<ConfigParameter.Builder> result = ConfigParameterListCopier.copyToBuilder(this.configParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigParameters(Collection<ConfigParameter.BuilderImpl> configParameters) {
            this.configParameters = ConfigParameterListCopier.copyFromBuilder(configParameters);
        }

        @Override
        public final Builder configParameters(Collection<ConfigParameter> configParameters) {
            this.configParameters = ConfigParameterListCopier.copy(configParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(ConfigParameter ... configParameters) {
            this.configParameters(Arrays.asList(configParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(Consumer<ConfigParameter.Builder> ... configParameters) {
            this.configParameters(Stream.of(configParameters).map(c -> (ConfigParameter)((ConfigParameter.Builder)ConfigParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final PerformanceTarget.Builder getPricePerformanceTarget() {
            return this.pricePerformanceTarget != null ? this.pricePerformanceTarget.toBuilder() : null;
        }

        public final void setPricePerformanceTarget(PerformanceTarget.BuilderImpl pricePerformanceTarget) {
            this.pricePerformanceTarget = pricePerformanceTarget != null ? pricePerformanceTarget.build() : null;
        }

        @Override
        public final Builder pricePerformanceTarget(PerformanceTarget pricePerformanceTarget) {
            this.pricePerformanceTarget = pricePerformanceTarget;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkgroupRequest build() {
            return new CreateWorkgroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkgroupRequest> {
        public Builder baseCapacity(Integer var1);

        public Builder configParameters(Collection<ConfigParameter> var1);

        public Builder configParameters(ConfigParameter ... var1);

        public Builder configParameters(Consumer<ConfigParameter.Builder> ... var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder ipAddressType(String var1);

        public Builder maxCapacity(Integer var1);

        public Builder namespaceName(String var1);

        public Builder port(Integer var1);

        public Builder pricePerformanceTarget(PerformanceTarget var1);

        default public Builder pricePerformanceTarget(Consumer<PerformanceTarget.Builder> pricePerformanceTarget) {
            return this.pricePerformanceTarget((PerformanceTarget)((PerformanceTarget.Builder)PerformanceTarget.builder().applyMutation(pricePerformanceTarget)).build());
        }

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder workgroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

