/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.Tag;
import software.amazon.awssdk.services.redshiftserverless.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotScheduleActionParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateSnapshotScheduleActionParameters> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(CreateSnapshotScheduleActionParameters.getter(CreateSnapshotScheduleActionParameters::namespaceName)).setter(CreateSnapshotScheduleActionParameters.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionPeriod").getter(CreateSnapshotScheduleActionParameters.getter(CreateSnapshotScheduleActionParameters::retentionPeriod)).setter(CreateSnapshotScheduleActionParameters.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotNamePrefix").getter(CreateSnapshotScheduleActionParameters.getter(CreateSnapshotScheduleActionParameters::snapshotNamePrefix)).setter(CreateSnapshotScheduleActionParameters.setter(Builder::snapshotNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotNamePrefix").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateSnapshotScheduleActionParameters.getter(CreateSnapshotScheduleActionParameters::tags)).setter(CreateSnapshotScheduleActionParameters.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD, RETENTION_PERIOD_FIELD, SNAPSHOT_NAME_PREFIX_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("namespaceName", NAMESPACE_NAME_FIELD);
            this.put("retentionPeriod", RETENTION_PERIOD_FIELD);
            this.put("snapshotNamePrefix", SNAPSHOT_NAME_PREFIX_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String namespaceName;
    private final Integer retentionPeriod;
    private final String snapshotNamePrefix;
    private final List<Tag> tags;

    private CreateSnapshotScheduleActionParameters(BuilderImpl builder) {
        this.namespaceName = builder.namespaceName;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotNamePrefix = builder.snapshotNamePrefix;
        this.tags = builder.tags;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final String snapshotNamePrefix() {
        return this.snapshotNamePrefix;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotScheduleActionParameters)) {
            return false;
        }
        CreateSnapshotScheduleActionParameters other = (CreateSnapshotScheduleActionParameters)obj;
        return Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.snapshotNamePrefix(), other.snapshotNamePrefix()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotScheduleActionParameters").add("NamespaceName", (Object)this.namespaceName()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("SnapshotNamePrefix", (Object)this.snapshotNamePrefix()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "snapshotNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.snapshotNamePrefix()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotScheduleActionParameters, T> g) {
        return obj -> g.apply((CreateSnapshotScheduleActionParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespaceName;
        private Integer retentionPeriod;
        private String snapshotNamePrefix;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotScheduleActionParameters model) {
            this.namespaceName(model.namespaceName);
            this.retentionPeriod(model.retentionPeriod);
            this.snapshotNamePrefix(model.snapshotNamePrefix);
            this.tags(model.tags);
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotNamePrefix() {
            return this.snapshotNamePrefix;
        }

        public final void setSnapshotNamePrefix(String snapshotNamePrefix) {
            this.snapshotNamePrefix = snapshotNamePrefix;
        }

        @Override
        public final Builder snapshotNamePrefix(String snapshotNamePrefix) {
            this.snapshotNamePrefix = snapshotNamePrefix;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateSnapshotScheduleActionParameters build() {
            return new CreateSnapshotScheduleActionParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotScheduleActionParameters> {
        public Builder namespaceName(String var1);

        public Builder retentionPeriod(Integer var1);

        public Builder snapshotNamePrefix(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

