/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.Workgroup;
import software.amazon.awssdk.services.redshiftserverless.model.WorkgroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkgroupsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListWorkgroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkgroupsResponse.getter(ListWorkgroupsResponse::nextToken)).setter(ListWorkgroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Workgroup>> WORKGROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workgroups").getter(ListWorkgroupsResponse.getter(ListWorkgroupsResponse::workgroups)).setter(ListWorkgroupsResponse.setter(Builder::workgroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workgroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKGROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("workgroups", WORKGROUPS_FIELD);
        }
    });
    private final String nextToken;
    private final List<Workgroup> workgroups;

    private ListWorkgroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workgroups = builder.workgroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkgroups() {
        return this.workgroups != null && !(this.workgroups instanceof SdkAutoConstructList);
    }

    public final List<Workgroup> workgroups() {
        return this.workgroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkgroups() ? this.workgroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkgroupsResponse)) {
            return false;
        }
        ListWorkgroupsResponse other = (ListWorkgroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkgroups() == other.hasWorkgroups() && Objects.equals(this.workgroups(), other.workgroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkgroupsResponse").add("NextToken", (Object)this.nextToken()).add("Workgroups", this.hasWorkgroups() ? this.workgroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workgroups": {
                return Optional.ofNullable(clazz.cast(this.workgroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkgroupsResponse, T> g) {
        return obj -> g.apply((ListWorkgroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Workgroup> workgroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkgroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workgroups(model.workgroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Workgroup.Builder> getWorkgroups() {
            List<Workgroup.Builder> result = WorkgroupListCopier.copyToBuilder(this.workgroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkgroups(Collection<Workgroup.BuilderImpl> workgroups) {
            this.workgroups = WorkgroupListCopier.copyFromBuilder(workgroups);
        }

        @Override
        public final Builder workgroups(Collection<Workgroup> workgroups) {
            this.workgroups = WorkgroupListCopier.copy(workgroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workgroups(Workgroup ... workgroups) {
            this.workgroups(Arrays.asList(workgroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workgroups(Consumer<Workgroup.Builder> ... workgroups) {
            this.workgroups(Stream.of(workgroups).map(c -> (Workgroup)((Workgroup.Builder)Workgroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkgroupsResponse build() {
            return new ListWorkgroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkgroupsResponse> {
        public Builder nextToken(String var1);

        public Builder workgroups(Collection<Workgroup> var1);

        public Builder workgroups(Workgroup ... var1);

        public Builder workgroups(Consumer<Workgroup.Builder> ... var1);
    }
}

