/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableFromSnapshotRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<RestoreTableFromSnapshotRequest.Builder, RestoreTableFromSnapshotRequest> {
    private static final SdkField<Boolean> ACTIVATE_CASE_SENSITIVE_IDENTIFIER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("activateCaseSensitiveIdentifier")
            .getter(getter(RestoreTableFromSnapshotRequest::activateCaseSensitiveIdentifier))
            .setter(setter(Builder::activateCaseSensitiveIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activateCaseSensitiveIdentifier")
                    .build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(RestoreTableFromSnapshotRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> NEW_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newTableName").getter(getter(RestoreTableFromSnapshotRequest::newTableName))
            .setter(setter(Builder::newTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newTableName").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(RestoreTableFromSnapshotRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<String> SOURCE_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceDatabaseName").getter(getter(RestoreTableFromSnapshotRequest::sourceDatabaseName))
            .setter(setter(Builder::sourceDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDatabaseName").build())
            .build();

    private static final SdkField<String> SOURCE_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSchemaName").getter(getter(RestoreTableFromSnapshotRequest::sourceSchemaName))
            .setter(setter(Builder::sourceSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSchemaName").build()).build();

    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceTableName").getter(getter(RestoreTableFromSnapshotRequest::sourceTableName))
            .setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTableName").build()).build();

    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetDatabaseName").getter(getter(RestoreTableFromSnapshotRequest::targetDatabaseName))
            .setter(setter(Builder::targetDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDatabaseName").build())
            .build();

    private static final SdkField<String> TARGET_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetSchemaName").getter(getter(RestoreTableFromSnapshotRequest::targetSchemaName))
            .setter(setter(Builder::targetSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSchemaName").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(RestoreTableFromSnapshotRequest::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVATE_CASE_SENSITIVE_IDENTIFIER_FIELD, NAMESPACE_NAME_FIELD, NEW_TABLE_NAME_FIELD, SNAPSHOT_NAME_FIELD,
            SOURCE_DATABASE_NAME_FIELD, SOURCE_SCHEMA_NAME_FIELD, SOURCE_TABLE_NAME_FIELD, TARGET_DATABASE_NAME_FIELD,
            TARGET_SCHEMA_NAME_FIELD, WORKGROUP_NAME_FIELD));

    private final Boolean activateCaseSensitiveIdentifier;

    private final String namespaceName;

    private final String newTableName;

    private final String snapshotName;

    private final String sourceDatabaseName;

    private final String sourceSchemaName;

    private final String sourceTableName;

    private final String targetDatabaseName;

    private final String targetSchemaName;

    private final String workgroupName;

    private RestoreTableFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.activateCaseSensitiveIdentifier = builder.activateCaseSensitiveIdentifier;
        this.namespaceName = builder.namespaceName;
        this.newTableName = builder.newTableName;
        this.snapshotName = builder.snapshotName;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the names are
     * case sensitive. If false, the names are not case sensitive. The default is false.
     * </p>
     * 
     * @return Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the names
     *         are case sensitive. If false, the names are not case sensitive. The default is false.
     */
    public final Boolean activateCaseSensitiveIdentifier() {
        return activateCaseSensitiveIdentifier;
    }

    /**
     * <p>
     * The namespace of the snapshot to restore from.
     * </p>
     * 
     * @return The namespace of the snapshot to restore from.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The name of the table to create from the restore operation.
     * </p>
     * 
     * @return The name of the table to create from the restore operation.
     */
    public final String newTableName() {
        return newTableName;
    }

    /**
     * <p>
     * The name of the snapshot to restore the table from.
     * </p>
     * 
     * @return The name of the snapshot to restore the table from.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The name of the source database that contains the table being restored.
     * </p>
     * 
     * @return The name of the source database that contains the table being restored.
     */
    public final String sourceDatabaseName() {
        return sourceDatabaseName;
    }

    /**
     * <p>
     * The name of the source schema that contains the table being restored.
     * </p>
     * 
     * @return The name of the source schema that contains the table being restored.
     */
    public final String sourceSchemaName() {
        return sourceSchemaName;
    }

    /**
     * <p>
     * The name of the source table being restored.
     * </p>
     * 
     * @return The name of the source table being restored.
     */
    public final String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * The name of the database to restore the table to.
     * </p>
     * 
     * @return The name of the database to restore the table to.
     */
    public final String targetDatabaseName() {
        return targetDatabaseName;
    }

    /**
     * <p>
     * The name of the schema to restore the table to.
     * </p>
     * 
     * @return The name of the schema to restore the table to.
     */
    public final String targetSchemaName() {
        return targetSchemaName;
    }

    /**
     * <p>
     * The workgroup to restore the table to.
     * </p>
     * 
     * @return The workgroup to restore the table to.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activateCaseSensitiveIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(newTableName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromSnapshotRequest)) {
            return false;
        }
        RestoreTableFromSnapshotRequest other = (RestoreTableFromSnapshotRequest) obj;
        return Objects.equals(activateCaseSensitiveIdentifier(), other.activateCaseSensitiveIdentifier())
                && Objects.equals(namespaceName(), other.namespaceName()) && Objects.equals(newTableName(), other.newTableName())
                && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(sourceDatabaseName(), other.sourceDatabaseName())
                && Objects.equals(sourceSchemaName(), other.sourceSchemaName())
                && Objects.equals(sourceTableName(), other.sourceTableName())
                && Objects.equals(targetDatabaseName(), other.targetDatabaseName())
                && Objects.equals(targetSchemaName(), other.targetSchemaName())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTableFromSnapshotRequest")
                .add("ActivateCaseSensitiveIdentifier", activateCaseSensitiveIdentifier()).add("NamespaceName", namespaceName())
                .add("NewTableName", newTableName()).add("SnapshotName", snapshotName())
                .add("SourceDatabaseName", sourceDatabaseName()).add("SourceSchemaName", sourceSchemaName())
                .add("SourceTableName", sourceTableName()).add("TargetDatabaseName", targetDatabaseName())
                .add("TargetSchemaName", targetSchemaName()).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activateCaseSensitiveIdentifier":
            return Optional.ofNullable(clazz.cast(activateCaseSensitiveIdentifier()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "newTableName":
            return Optional.ofNullable(clazz.cast(newTableName()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "sourceDatabaseName":
            return Optional.ofNullable(clazz.cast(sourceDatabaseName()));
        case "sourceSchemaName":
            return Optional.ofNullable(clazz.cast(sourceSchemaName()));
        case "sourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "targetDatabaseName":
            return Optional.ofNullable(clazz.cast(targetDatabaseName()));
        case "targetSchemaName":
            return Optional.ofNullable(clazz.cast(targetSchemaName()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreTableFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreTableFromSnapshotRequest> {
        /**
         * <p>
         * Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the names are
         * case sensitive. If false, the names are not case sensitive. The default is false.
         * </p>
         * 
         * @param activateCaseSensitiveIdentifier
         *        Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the
         *        names are case sensitive. If false, the names are not case sensitive. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activateCaseSensitiveIdentifier(Boolean activateCaseSensitiveIdentifier);

        /**
         * <p>
         * The namespace of the snapshot to restore from.
         * </p>
         * 
         * @param namespaceName
         *        The namespace of the snapshot to restore from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The name of the table to create from the restore operation.
         * </p>
         * 
         * @param newTableName
         *        The name of the table to create from the restore operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTableName(String newTableName);

        /**
         * <p>
         * The name of the snapshot to restore the table from.
         * </p>
         * 
         * @param snapshotName
         *        The name of the snapshot to restore the table from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The name of the source database that contains the table being restored.
         * </p>
         * 
         * @param sourceDatabaseName
         *        The name of the source database that contains the table being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDatabaseName(String sourceDatabaseName);

        /**
         * <p>
         * The name of the source schema that contains the table being restored.
         * </p>
         * 
         * @param sourceSchemaName
         *        The name of the source schema that contains the table being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSchemaName(String sourceSchemaName);

        /**
         * <p>
         * The name of the source table being restored.
         * </p>
         * 
         * @param sourceTableName
         *        The name of the source table being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * The name of the database to restore the table to.
         * </p>
         * 
         * @param targetDatabaseName
         *        The name of the database to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseName(String targetDatabaseName);

        /**
         * <p>
         * The name of the schema to restore the table to.
         * </p>
         * 
         * @param targetSchemaName
         *        The name of the schema to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSchemaName(String targetSchemaName);

        /**
         * <p>
         * The workgroup to restore the table to.
         * </p>
         * 
         * @param workgroupName
         *        The workgroup to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Boolean activateCaseSensitiveIdentifier;

        private String namespaceName;

        private String newTableName;

        private String snapshotName;

        private String sourceDatabaseName;

        private String sourceSchemaName;

        private String sourceTableName;

        private String targetDatabaseName;

        private String targetSchemaName;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromSnapshotRequest model) {
            super(model);
            activateCaseSensitiveIdentifier(model.activateCaseSensitiveIdentifier);
            namespaceName(model.namespaceName);
            newTableName(model.newTableName);
            snapshotName(model.snapshotName);
            sourceDatabaseName(model.sourceDatabaseName);
            sourceSchemaName(model.sourceSchemaName);
            sourceTableName(model.sourceTableName);
            targetDatabaseName(model.targetDatabaseName);
            targetSchemaName(model.targetSchemaName);
            workgroupName(model.workgroupName);
        }

        public final Boolean getActivateCaseSensitiveIdentifier() {
            return activateCaseSensitiveIdentifier;
        }

        public final void setActivateCaseSensitiveIdentifier(Boolean activateCaseSensitiveIdentifier) {
            this.activateCaseSensitiveIdentifier = activateCaseSensitiveIdentifier;
        }

        @Override
        public final Builder activateCaseSensitiveIdentifier(Boolean activateCaseSensitiveIdentifier) {
            this.activateCaseSensitiveIdentifier = activateCaseSensitiveIdentifier;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getNewTableName() {
            return newTableName;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSourceDatabaseName() {
            return sourceDatabaseName;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final String getSourceSchemaName() {
            return sourceSchemaName;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getTargetDatabaseName() {
            return targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetSchemaName() {
            return targetSchemaName;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromSnapshotRequest build() {
            return new RestoreTableFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
