/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteNamespaceRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<DeleteNamespaceRequest.Builder, DeleteNamespaceRequest> {
    private static final SdkField<String> FINAL_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("finalSnapshotName").getter(getter(DeleteNamespaceRequest::finalSnapshotName))
            .setter(setter(Builder::finalSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalSnapshotName").build()).build();

    private static final SdkField<Integer> FINAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("finalSnapshotRetentionPeriod")
            .getter(getter(DeleteNamespaceRequest::finalSnapshotRetentionPeriod))
            .setter(setter(Builder::finalSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(DeleteNamespaceRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINAL_SNAPSHOT_NAME_FIELD,
            FINAL_SNAPSHOT_RETENTION_PERIOD_FIELD, NAMESPACE_NAME_FIELD));

    private final String finalSnapshotName;

    private final Integer finalSnapshotRetentionPeriod;

    private final String namespaceName;

    private DeleteNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.finalSnapshotName = builder.finalSnapshotName;
        this.finalSnapshotRetentionPeriod = builder.finalSnapshotRetentionPeriod;
        this.namespaceName = builder.namespaceName;
    }

    /**
     * <p>
     * The name of the snapshot to be created before the namespace is deleted.
     * </p>
     * 
     * @return The name of the snapshot to be created before the namespace is deleted.
     */
    public final String finalSnapshotName() {
        return finalSnapshotName;
    }

    /**
     * <p>
     * How long to retain the final snapshot.
     * </p>
     * 
     * @return How long to retain the final snapshot.
     */
    public final Integer finalSnapshotRetentionPeriod() {
        return finalSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The name of the namespace to delete.
     * </p>
     * 
     * @return The name of the namespace to delete.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(finalSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(finalSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNamespaceRequest)) {
            return false;
        }
        DeleteNamespaceRequest other = (DeleteNamespaceRequest) obj;
        return Objects.equals(finalSnapshotName(), other.finalSnapshotName())
                && Objects.equals(finalSnapshotRetentionPeriod(), other.finalSnapshotRetentionPeriod())
                && Objects.equals(namespaceName(), other.namespaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteNamespaceRequest").add("FinalSnapshotName", finalSnapshotName())
                .add("FinalSnapshotRetentionPeriod", finalSnapshotRetentionPeriod()).add("NamespaceName", namespaceName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "finalSnapshotName":
            return Optional.ofNullable(clazz.cast(finalSnapshotName()));
        case "finalSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(finalSnapshotRetentionPeriod()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNamespaceRequest, T> g) {
        return obj -> g.apply((DeleteNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteNamespaceRequest> {
        /**
         * <p>
         * The name of the snapshot to be created before the namespace is deleted.
         * </p>
         * 
         * @param finalSnapshotName
         *        The name of the snapshot to be created before the namespace is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalSnapshotName(String finalSnapshotName);

        /**
         * <p>
         * How long to retain the final snapshot.
         * </p>
         * 
         * @param finalSnapshotRetentionPeriod
         *        How long to retain the final snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalSnapshotRetentionPeriod(Integer finalSnapshotRetentionPeriod);

        /**
         * <p>
         * The name of the namespace to delete.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String finalSnapshotName;

        private Integer finalSnapshotRetentionPeriod;

        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNamespaceRequest model) {
            super(model);
            finalSnapshotName(model.finalSnapshotName);
            finalSnapshotRetentionPeriod(model.finalSnapshotRetentionPeriod);
            namespaceName(model.namespaceName);
        }

        public final String getFinalSnapshotName() {
            return finalSnapshotName;
        }

        public final void setFinalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
        }

        @Override
        public final Builder finalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        public final Integer getFinalSnapshotRetentionPeriod() {
            return finalSnapshotRetentionPeriod;
        }

        public final void setFinalSnapshotRetentionPeriod(Integer finalSnapshotRetentionPeriod) {
            this.finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod;
        }

        @Override
        public final Builder finalSnapshotRetentionPeriod(Integer finalSnapshotRetentionPeriod) {
            this.finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNamespaceRequest build() {
            return new DeleteNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
