/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshiftserverless.DefaultRedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.DefaultRedshiftServerlessBaseClientBuilder;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClientBuilder;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessServiceClientConfiguration;
import software.amazon.awssdk.services.redshiftserverless.endpoints.RedshiftServerlessEndpointProvider;

@SdkInternalApi
final class DefaultRedshiftServerlessAsyncClientBuilder
extends DefaultRedshiftServerlessBaseClientBuilder<RedshiftServerlessAsyncClientBuilder, RedshiftServerlessAsyncClient>
implements RedshiftServerlessAsyncClientBuilder {
    DefaultRedshiftServerlessAsyncClientBuilder() {
    }

    @Override
    public DefaultRedshiftServerlessAsyncClientBuilder endpointProvider(RedshiftServerlessEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RedshiftServerlessAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRedshiftServerlessAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RedshiftServerlessServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRedshiftServerlessAsyncClient client = new DefaultRedshiftServerlessAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RedshiftServerlessServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RedshiftServerlessServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

