/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimit;

public class ListUsageLimitsIterable
implements SdkIterable<ListUsageLimitsResponse> {
    private final RedshiftServerlessClient client;
    private final ListUsageLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsageLimitsIterable(RedshiftServerlessClient client, ListUsageLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUsageLimitsResponseFetcher();
    }

    public Iterator<ListUsageLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsageLimit> usageLimits() {
        Function<ListUsageLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.usageLimits() != null) {
                return response.usageLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUsageLimitsResponseFetcher
    implements SyncPageFetcher<ListUsageLimitsResponse> {
        private ListUsageLimitsResponseFetcher() {
        }

        public boolean hasNextPage(ListUsageLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsageLimitsResponse nextPage(ListUsageLimitsResponse previousPage) {
            if (previousPage == null) {
                return ListUsageLimitsIterable.this.client.listUsageLimits(ListUsageLimitsIterable.this.firstRequest);
            }
            return ListUsageLimitsIterable.this.client.listUsageLimits((ListUsageLimitsRequest)((Object)ListUsageLimitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

