/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SQL statement to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatementData implements SdkPojo, Serializable, ToCopyableBuilder<StatementData.Builder, StatementData> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(StatementData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(StatementData::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<List<String>> QUERY_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryStrings")
            .getter(getter(StatementData::queryStrings))
            .setter(setter(Builder::queryStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(StatementData::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StatementData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(StatementData::statementName)).setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(StatementData::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(StatementData::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<List<SqlParameter>> QUERY_PARAMETERS_FIELD = SdkField
            .<List<SqlParameter>> builder(MarshallingType.LIST)
            .memberName("QueryParameters")
            .getter(getter(StatementData::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_BATCH_STATEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsBatchStatement").getter(getter(StatementData::isBatchStatement))
            .setter(setter(Builder::isBatchStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsBatchStatement").build()).build();

    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultFormat").getter(getter(StatementData::resultFormatAsString)).setter(setter(Builder::resultFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(StatementData::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, QUERY_STRING_FIELD,
            QUERY_STRINGS_FIELD, SECRET_ARN_FIELD, STATUS_FIELD, STATEMENT_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            QUERY_PARAMETERS_FIELD, IS_BATCH_STATEMENT_FIELD, RESULT_FORMAT_FIELD, SESSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String queryString;

    private final List<String> queryStrings;

    private final String secretArn;

    private final String status;

    private final String statementName;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<SqlParameter> queryParameters;

    private final Boolean isBatchStatement;

    private final String resultFormat;

    private final String sessionId;

    private StatementData(BuilderImpl builder) {
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.queryStrings = builder.queryStrings;
        this.secretArn = builder.secretArn;
        this.status = builder.status;
        this.statementName = builder.statementName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.queryParameters = builder.queryParameters;
        this.isBatchStatement = builder.isBatchStatement;
        this.resultFormat = builder.resultFormat;
        this.sessionId = builder.sessionId;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @return The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *         Redshift Data API.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The SQL statement.
     * </p>
     * 
     * @return The SQL statement.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryStrings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryStrings() {
        return queryStrings != null && !(queryStrings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryStrings} method.
     * </p>
     * 
     * @return One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch
     *         query request.
     */
    public final List<String> queryStrings() {
        return queryStrings;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatusString
     */
    public final StatusString status() {
        return StatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatusString
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the SQL statement.
     * </p>
     * 
     * @return The name of the SQL statement.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @return The date and time (UTC) the statement was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @return The date and time (UTC) that the statement metadata was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameters} method.
     * </p>
     * 
     * @return The parameters used in a SQL statement.
     */
    public final List<SqlParameter> queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     * 
     * @return A value that indicates whether the statement is a batch query request.
     */
    public final Boolean isBatchStatement() {
        return isBatchStatement;
    }

    /**
     * <p>
     * The data format of the result of the SQL statement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormatString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The data format of the result of the SQL statement.
     * @see ResultFormatString
     */
    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(resultFormat);
    }

    /**
     * <p>
     * The data format of the result of the SQL statement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormatString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The data format of the result of the SQL statement.
     * @see ResultFormatString
     */
    public final String resultFormatAsString() {
        return resultFormat;
    }

    /**
     * <p>
     * The session identifier of the query.
     * </p>
     * 
     * @return The session identifier of the query.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryStrings() ? queryStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isBatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementData)) {
            return false;
        }
        StatementData other = (StatementData) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(queryString(), other.queryString())
                && hasQueryStrings() == other.hasQueryStrings() && Objects.equals(queryStrings(), other.queryStrings())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statementName(), other.statementName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters())
                && Objects.equals(isBatchStatement(), other.isBatchStatement())
                && Objects.equals(resultFormatAsString(), other.resultFormatAsString())
                && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatementData").add("Id", id()).add("QueryString", queryString())
                .add("QueryStrings", hasQueryStrings() ? queryStrings() : null).add("SecretArn", secretArn())
                .add("Status", statusAsString()).add("StatementName", statementName()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("QueryParameters", hasQueryParameters() ? queryParameters() : null)
                .add("IsBatchStatement", isBatchStatement()).add("ResultFormat", resultFormatAsString())
                .add("SessionId", sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "QueryStrings":
            return Optional.ofNullable(clazz.cast(queryStrings()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "QueryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "IsBatchStatement":
            return Optional.ofNullable(clazz.cast(isBatchStatement()));
        case "ResultFormat":
            return Optional.ofNullable(clazz.cast(resultFormatAsString()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("QueryStrings", QUERY_STRINGS_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatementName", STATEMENT_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("IsBatchStatement", IS_BATCH_STATEMENT_FIELD);
        map.put("ResultFormat", RESULT_FORMAT_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatementData, T> g) {
        return obj -> g.apply((StatementData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatementData> {
        /**
         * <p>
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
         * Redshift Data API.
         * </p>
         * 
         * @param id
         *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
         *        Redshift Data API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The SQL statement.
         * </p>
         * 
         * @param queryString
         *        The SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
         * request.
         * </p>
         * 
         * @param queryStrings
         *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a
         *        batch query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStrings(Collection<String> queryStrings);

        /**
         * <p>
         * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
         * request.
         * </p>
         * 
         * @param queryStrings
         *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a
         *        batch query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStrings(String... queryStrings);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * </p>
         * 
         * @param secretArn
         *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The status of the SQL statement. An example is the that the SQL statement finished.
         * </p>
         * 
         * @param status
         *        The status of the SQL statement. An example is the that the SQL statement finished.
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SQL statement. An example is the that the SQL statement finished.
         * </p>
         * 
         * @param status
         *        The status of the SQL statement. An example is the that the SQL statement finished.
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(StatusString status);

        /**
         * <p>
         * The name of the SQL statement.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * The date and time (UTC) the statement was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time (UTC) the statement was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time (UTC) that the statement metadata was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time (UTC) that the statement metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The parameters used in a SQL statement.
         * </p>
         * 
         * @param queryParameters
         *        The parameters used in a SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Collection<SqlParameter> queryParameters);

        /**
         * <p>
         * The parameters used in a SQL statement.
         * </p>
         * 
         * @param queryParameters
         *        The parameters used in a SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(SqlParameter... queryParameters);

        /**
         * <p>
         * The parameters used in a SQL statement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #queryParameters(List<SqlParameter>)}.
         * 
         * @param queryParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryParameters(java.util.Collection<SqlParameter>)
         */
        Builder queryParameters(Consumer<SqlParameter.Builder>... queryParameters);

        /**
         * <p>
         * A value that indicates whether the statement is a batch query request.
         * </p>
         * 
         * @param isBatchStatement
         *        A value that indicates whether the statement is a batch query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isBatchStatement(Boolean isBatchStatement);

        /**
         * <p>
         * The data format of the result of the SQL statement.
         * </p>
         * 
         * @param resultFormat
         *        The data format of the result of the SQL statement.
         * @see ResultFormatString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormatString
         */
        Builder resultFormat(String resultFormat);

        /**
         * <p>
         * The data format of the result of the SQL statement.
         * </p>
         * 
         * @param resultFormat
         *        The data format of the result of the SQL statement.
         * @see ResultFormatString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormatString
         */
        Builder resultFormat(ResultFormatString resultFormat);

        /**
         * <p>
         * The session identifier of the query.
         * </p>
         * 
         * @param sessionId
         *        The session identifier of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String queryString;

        private List<String> queryStrings = DefaultSdkAutoConstructList.getInstance();

        private String secretArn;

        private String status;

        private String statementName;

        private Instant createdAt;

        private Instant updatedAt;

        private List<SqlParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private Boolean isBatchStatement;

        private String resultFormat;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StatementData model) {
            id(model.id);
            queryString(model.queryString);
            queryStrings(model.queryStrings);
            secretArn(model.secretArn);
            status(model.status);
            statementName(model.statementName);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            queryParameters(model.queryParameters);
            isBatchStatement(model.isBatchStatement);
            resultFormat(model.resultFormat);
            sessionId(model.sessionId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getQueryStrings() {
            if (queryStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return queryStrings;
        }

        public final void setQueryStrings(Collection<String> queryStrings) {
            this.queryStrings = StatementStringListCopier.copy(queryStrings);
        }

        @Override
        public final Builder queryStrings(Collection<String> queryStrings) {
            this.queryStrings = StatementStringListCopier.copy(queryStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryStrings(String... queryStrings) {
            queryStrings(Arrays.asList(queryStrings));
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<SqlParameter.Builder> getQueryParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<SqlParameter.BuilderImpl> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copyFromBuilder(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<SqlParameter> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(SqlParameter... queryParameters) {
            queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(Consumer<SqlParameter.Builder>... queryParameters) {
            queryParameters(Stream.of(queryParameters).map(c -> SqlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsBatchStatement() {
            return isBatchStatement;
        }

        public final void setIsBatchStatement(Boolean isBatchStatement) {
            this.isBatchStatement = isBatchStatement;
        }

        @Override
        public final Builder isBatchStatement(Boolean isBatchStatement) {
            this.isBatchStatement = isBatchStatement;
            return this;
        }

        public final String getResultFormat() {
            return resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public StatementData build() {
            return new StatementData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
