/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftdata.model.Field;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;

public class GetStatementResultPublisher
implements SdkPublisher<GetStatementResultResponse> {
    private final RedshiftDataAsyncClient client;
    private final GetStatementResultRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetStatementResultPublisher(RedshiftDataAsyncClient client, GetStatementResultRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetStatementResultPublisher(RedshiftDataAsyncClient client, GetStatementResultRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetStatementResultResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetStatementResultResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<List<Field>> records() {
        Function<GetStatementResultResponse, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetStatementResultResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetStatementResultResponseFetcher
    implements AsyncPageFetcher<GetStatementResultResponse> {
        private GetStatementResultResponseFetcher() {
        }

        public boolean hasNextPage(GetStatementResultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetStatementResultResponse> nextPage(GetStatementResultResponse previousPage) {
            if (previousPage == null) {
                return GetStatementResultPublisher.this.client.getStatementResult(GetStatementResultPublisher.this.firstRequest);
            }
            return GetStatementResultPublisher.this.client.getStatementResult((GetStatementResultRequest)((Object)GetStatementResultPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

