/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.services.redshiftdata.model.TableListCopier;
import software.amazon.awssdk.services.redshiftdata.model.TableMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, ListTablesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTablesResponse.getter(ListTablesResponse::nextToken)).setter(ListTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TableMember>> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tables").getter(ListTablesResponse.getter(ListTablesResponse::tables)).setter(ListTablesResponse.setter(Builder::tables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TABLES_FIELD));
    private final String nextToken;
    private final List<TableMember> tables;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tables = builder.tables;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTables() {
        return this.tables != null && !(this.tables instanceof SdkAutoConstructList);
    }

    public final List<TableMember> tables() {
        return this.tables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTables() ? this.tables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTables() == other.hasTables() && Objects.equals(this.tables(), other.tables());
    }

    public final String toString() {
        return ToString.builder((String)"ListTablesResponse").add("NextToken", (Object)this.nextToken()).add("Tables", this.hasTables() ? this.tables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TableMember> tables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.tables(model.tables);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<TableMember.Builder> getTables() {
            if (this.tables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tables != null ? (Collection)this.tables.stream().map(TableMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tables(Collection<TableMember> tables) {
            this.tables = TableListCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(TableMember ... tables) {
            this.tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<TableMember.Builder> ... tables) {
            this.tables(Stream.of(tables).map(c -> (TableMember)((TableMember.Builder)TableMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTables(Collection<TableMember.BuilderImpl> tables) {
            this.tables = TableListCopier.copyFromBuilder(tables);
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTablesResponse> {
        public Builder nextToken(String var1);

        public Builder tables(Collection<TableMember> var1);

        public Builder tables(TableMember ... var1);

        public Builder tables(Consumer<TableMember.Builder> ... var1);
    }
}

