/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesRequest
extends RedshiftDataRequest
implements ToCopyableBuilder<Builder, ListTablesRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ListTablesRequest.getter(ListTablesRequest::clusterIdentifier)).setter(ListTablesRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(ListTablesRequest.getter(ListTablesRequest::database)).setter(ListTablesRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(ListTablesRequest.getter(ListTablesRequest::dbUser)).setter(ListTablesRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTablesRequest.getter(ListTablesRequest::maxResults)).setter(ListTablesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTablesRequest.getter(ListTablesRequest::nextToken)).setter(ListTablesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SCHEMA_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaPattern").getter(ListTablesRequest.getter(ListTablesRequest::schemaPattern)).setter(ListTablesRequest.setter(Builder::schemaPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaPattern").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(ListTablesRequest.getter(ListTablesRequest::secretArn)).setter(ListTablesRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> TABLE_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TablePattern").getter(ListTablesRequest.getter(ListTablesRequest::tablePattern)).setter(ListTablesRequest.setter(Builder::tablePattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePattern").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, DATABASE_FIELD, DB_USER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCHEMA_PATTERN_FIELD, SECRET_ARN_FIELD, TABLE_PATTERN_FIELD));
    private final String clusterIdentifier;
    private final String database;
    private final String dbUser;
    private final Integer maxResults;
    private final String nextToken;
    private final String schemaPattern;
    private final String secretArn;
    private final String tablePattern;

    private ListTablesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.schemaPattern = builder.schemaPattern;
        this.secretArn = builder.secretArn;
        this.tablePattern = builder.tablePattern;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String database() {
        return this.database;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String schemaPattern() {
        return this.schemaPattern;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String tablePattern() {
        return this.tablePattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablePattern());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.schemaPattern(), other.schemaPattern()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.tablePattern(), other.tablePattern());
    }

    public final String toString() {
        return ToString.builder((String)"ListTablesRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SchemaPattern", (Object)this.schemaPattern()).add("SecretArn", (Object)this.secretArn()).add("TablePattern", (Object)this.tablePattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SchemaPattern": {
                return Optional.ofNullable(clazz.cast(this.schemaPattern()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "TablePattern": {
                return Optional.ofNullable(clazz.cast(this.tablePattern()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesRequest, T> g) {
        return obj -> g.apply((ListTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String database;
        private String dbUser;
        private Integer maxResults;
        private String nextToken;
        private String schemaPattern;
        private String secretArn;
        private String tablePattern;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.schemaPattern(model.schemaPattern);
            this.secretArn(model.secretArn);
            this.tablePattern(model.tablePattern);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSchemaPattern() {
            return this.schemaPattern;
        }

        @Override
        public final Builder schemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
            return this;
        }

        public final void setSchemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getTablePattern() {
            return this.tablePattern;
        }

        @Override
        public final Builder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public final void setTablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTablesRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder schemaPattern(String var1);

        public Builder secretArn(String var1);

        public Builder tablePattern(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

