/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer;
import software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuerListCopier;
import software.amazon.awssdk.services.redshift.model.ServiceIntegrationListCopier;
import software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftIdcApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftIdcApplication> {
    private static final SdkField<String> IDC_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcInstanceArn").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::idcInstanceArn)).setter(RedshiftIdcApplication.setter(Builder::idcInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcInstanceArn").build()}).build();
    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftIdcApplicationName").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::redshiftIdcApplicationName)).setter(RedshiftIdcApplication.setter(Builder::redshiftIdcApplicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationName").build()}).build();
    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftIdcApplicationArn").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::redshiftIdcApplicationArn)).setter(RedshiftIdcApplication.setter(Builder::redshiftIdcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationArn").build()}).build();
    private static final SdkField<String> IDENTITY_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityNamespace").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::identityNamespace)).setter(RedshiftIdcApplication.setter(Builder::identityNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityNamespace").build()}).build();
    private static final SdkField<String> IDC_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcDisplayName").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::idcDisplayName)).setter(RedshiftIdcApplication.setter(Builder::idcDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcDisplayName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::iamRoleArn)).setter(RedshiftIdcApplication.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> IDC_MANAGED_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcManagedApplicationArn").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::idcManagedApplicationArn)).setter(RedshiftIdcApplication.setter(Builder::idcManagedApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcManagedApplicationArn").build()}).build();
    private static final SdkField<String> IDC_ONBOARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcOnboardStatus").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::idcOnboardStatus)).setter(RedshiftIdcApplication.setter(Builder::idcOnboardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcOnboardStatus").build()}).build();
    private static final SdkField<List<AuthorizedTokenIssuer>> AUTHORIZED_TOKEN_ISSUER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTokenIssuerList").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::authorizedTokenIssuerList)).setter(RedshiftIdcApplication.setter(Builder::authorizedTokenIssuerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTokenIssuerList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedTokenIssuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceIntegrationsUnion>> SERVICE_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceIntegrations").getter(RedshiftIdcApplication.getter(RedshiftIdcApplication::serviceIntegrations)).setter(RedshiftIdcApplication.setter(Builder::serviceIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIntegrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceIntegrationsUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDC_INSTANCE_ARN_FIELD, REDSHIFT_IDC_APPLICATION_NAME_FIELD, REDSHIFT_IDC_APPLICATION_ARN_FIELD, IDENTITY_NAMESPACE_FIELD, IDC_DISPLAY_NAME_FIELD, IAM_ROLE_ARN_FIELD, IDC_MANAGED_APPLICATION_ARN_FIELD, IDC_ONBOARD_STATUS_FIELD, AUTHORIZED_TOKEN_ISSUER_LIST_FIELD, SERVICE_INTEGRATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftIdcApplication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String idcInstanceArn;
    private final String redshiftIdcApplicationName;
    private final String redshiftIdcApplicationArn;
    private final String identityNamespace;
    private final String idcDisplayName;
    private final String iamRoleArn;
    private final String idcManagedApplicationArn;
    private final String idcOnboardStatus;
    private final List<AuthorizedTokenIssuer> authorizedTokenIssuerList;
    private final List<ServiceIntegrationsUnion> serviceIntegrations;

    private RedshiftIdcApplication(BuilderImpl builder) {
        this.idcInstanceArn = builder.idcInstanceArn;
        this.redshiftIdcApplicationName = builder.redshiftIdcApplicationName;
        this.redshiftIdcApplicationArn = builder.redshiftIdcApplicationArn;
        this.identityNamespace = builder.identityNamespace;
        this.idcDisplayName = builder.idcDisplayName;
        this.iamRoleArn = builder.iamRoleArn;
        this.idcManagedApplicationArn = builder.idcManagedApplicationArn;
        this.idcOnboardStatus = builder.idcOnboardStatus;
        this.authorizedTokenIssuerList = builder.authorizedTokenIssuerList;
        this.serviceIntegrations = builder.serviceIntegrations;
    }

    public final String idcInstanceArn() {
        return this.idcInstanceArn;
    }

    public final String redshiftIdcApplicationName() {
        return this.redshiftIdcApplicationName;
    }

    public final String redshiftIdcApplicationArn() {
        return this.redshiftIdcApplicationArn;
    }

    public final String identityNamespace() {
        return this.identityNamespace;
    }

    public final String idcDisplayName() {
        return this.idcDisplayName;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String idcManagedApplicationArn() {
        return this.idcManagedApplicationArn;
    }

    public final String idcOnboardStatus() {
        return this.idcOnboardStatus;
    }

    public final boolean hasAuthorizedTokenIssuerList() {
        return this.authorizedTokenIssuerList != null && !(this.authorizedTokenIssuerList instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedTokenIssuer> authorizedTokenIssuerList() {
        return this.authorizedTokenIssuerList;
    }

    public final boolean hasServiceIntegrations() {
        return this.serviceIntegrations != null && !(this.serviceIntegrations instanceof SdkAutoConstructList);
    }

    public final List<ServiceIntegrationsUnion> serviceIntegrations() {
        return this.serviceIntegrations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.idcInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftIdcApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcManagedApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcOnboardStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTokenIssuerList() ? this.authorizedTokenIssuerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceIntegrations() ? this.serviceIntegrations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftIdcApplication)) {
            return false;
        }
        RedshiftIdcApplication other = (RedshiftIdcApplication)obj;
        return Objects.equals(this.idcInstanceArn(), other.idcInstanceArn()) && Objects.equals(this.redshiftIdcApplicationName(), other.redshiftIdcApplicationName()) && Objects.equals(this.redshiftIdcApplicationArn(), other.redshiftIdcApplicationArn()) && Objects.equals(this.identityNamespace(), other.identityNamespace()) && Objects.equals(this.idcDisplayName(), other.idcDisplayName()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.idcManagedApplicationArn(), other.idcManagedApplicationArn()) && Objects.equals(this.idcOnboardStatus(), other.idcOnboardStatus()) && this.hasAuthorizedTokenIssuerList() == other.hasAuthorizedTokenIssuerList() && Objects.equals(this.authorizedTokenIssuerList(), other.authorizedTokenIssuerList()) && this.hasServiceIntegrations() == other.hasServiceIntegrations() && Objects.equals(this.serviceIntegrations(), other.serviceIntegrations());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftIdcApplication").add("IdcInstanceArn", (Object)this.idcInstanceArn()).add("RedshiftIdcApplicationName", (Object)this.redshiftIdcApplicationName()).add("RedshiftIdcApplicationArn", (Object)this.redshiftIdcApplicationArn()).add("IdentityNamespace", (Object)this.identityNamespace()).add("IdcDisplayName", (Object)this.idcDisplayName()).add("IamRoleArn", (Object)this.iamRoleArn()).add("IdcManagedApplicationArn", (Object)this.idcManagedApplicationArn()).add("IdcOnboardStatus", (Object)this.idcOnboardStatus()).add("AuthorizedTokenIssuerList", this.hasAuthorizedTokenIssuerList() ? this.authorizedTokenIssuerList() : null).add("ServiceIntegrations", this.hasServiceIntegrations() ? this.serviceIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdcInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.idcInstanceArn()));
            }
            case "RedshiftIdcApplicationName": {
                return Optional.ofNullable(clazz.cast(this.redshiftIdcApplicationName()));
            }
            case "RedshiftIdcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.redshiftIdcApplicationArn()));
            }
            case "IdentityNamespace": {
                return Optional.ofNullable(clazz.cast(this.identityNamespace()));
            }
            case "IdcDisplayName": {
                return Optional.ofNullable(clazz.cast(this.idcDisplayName()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "IdcManagedApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.idcManagedApplicationArn()));
            }
            case "IdcOnboardStatus": {
                return Optional.ofNullable(clazz.cast(this.idcOnboardStatus()));
            }
            case "AuthorizedTokenIssuerList": {
                return Optional.ofNullable(clazz.cast(this.authorizedTokenIssuerList()));
            }
            case "ServiceIntegrations": {
                return Optional.ofNullable(clazz.cast(this.serviceIntegrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdcInstanceArn", IDC_INSTANCE_ARN_FIELD);
        map.put("RedshiftIdcApplicationName", REDSHIFT_IDC_APPLICATION_NAME_FIELD);
        map.put("RedshiftIdcApplicationArn", REDSHIFT_IDC_APPLICATION_ARN_FIELD);
        map.put("IdentityNamespace", IDENTITY_NAMESPACE_FIELD);
        map.put("IdcDisplayName", IDC_DISPLAY_NAME_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("IdcManagedApplicationArn", IDC_MANAGED_APPLICATION_ARN_FIELD);
        map.put("IdcOnboardStatus", IDC_ONBOARD_STATUS_FIELD);
        map.put("AuthorizedTokenIssuerList", AUTHORIZED_TOKEN_ISSUER_LIST_FIELD);
        map.put("ServiceIntegrations", SERVICE_INTEGRATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftIdcApplication, T> g) {
        return obj -> g.apply((RedshiftIdcApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String idcInstanceArn;
        private String redshiftIdcApplicationName;
        private String redshiftIdcApplicationArn;
        private String identityNamespace;
        private String idcDisplayName;
        private String iamRoleArn;
        private String idcManagedApplicationArn;
        private String idcOnboardStatus;
        private List<AuthorizedTokenIssuer> authorizedTokenIssuerList = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceIntegrationsUnion> serviceIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftIdcApplication model) {
            this.idcInstanceArn(model.idcInstanceArn);
            this.redshiftIdcApplicationName(model.redshiftIdcApplicationName);
            this.redshiftIdcApplicationArn(model.redshiftIdcApplicationArn);
            this.identityNamespace(model.identityNamespace);
            this.idcDisplayName(model.idcDisplayName);
            this.iamRoleArn(model.iamRoleArn);
            this.idcManagedApplicationArn(model.idcManagedApplicationArn);
            this.idcOnboardStatus(model.idcOnboardStatus);
            this.authorizedTokenIssuerList(model.authorizedTokenIssuerList);
            this.serviceIntegrations(model.serviceIntegrations);
        }

        public final String getIdcInstanceArn() {
            return this.idcInstanceArn;
        }

        public final void setIdcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
        }

        @Override
        public final Builder idcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
            return this;
        }

        public final String getRedshiftIdcApplicationName() {
            return this.redshiftIdcApplicationName;
        }

        public final void setRedshiftIdcApplicationName(String redshiftIdcApplicationName) {
            this.redshiftIdcApplicationName = redshiftIdcApplicationName;
        }

        @Override
        public final Builder redshiftIdcApplicationName(String redshiftIdcApplicationName) {
            this.redshiftIdcApplicationName = redshiftIdcApplicationName;
            return this;
        }

        public final String getRedshiftIdcApplicationArn() {
            return this.redshiftIdcApplicationArn;
        }

        public final void setRedshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
        }

        @Override
        public final Builder redshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
            return this;
        }

        public final String getIdentityNamespace() {
            return this.identityNamespace;
        }

        public final void setIdentityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
        }

        @Override
        public final Builder identityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
            return this;
        }

        public final String getIdcDisplayName() {
            return this.idcDisplayName;
        }

        public final void setIdcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
        }

        @Override
        public final Builder idcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIdcManagedApplicationArn() {
            return this.idcManagedApplicationArn;
        }

        public final void setIdcManagedApplicationArn(String idcManagedApplicationArn) {
            this.idcManagedApplicationArn = idcManagedApplicationArn;
        }

        @Override
        public final Builder idcManagedApplicationArn(String idcManagedApplicationArn) {
            this.idcManagedApplicationArn = idcManagedApplicationArn;
            return this;
        }

        public final String getIdcOnboardStatus() {
            return this.idcOnboardStatus;
        }

        public final void setIdcOnboardStatus(String idcOnboardStatus) {
            this.idcOnboardStatus = idcOnboardStatus;
        }

        @Override
        public final Builder idcOnboardStatus(String idcOnboardStatus) {
            this.idcOnboardStatus = idcOnboardStatus;
            return this;
        }

        public final List<AuthorizedTokenIssuer.Builder> getAuthorizedTokenIssuerList() {
            List<AuthorizedTokenIssuer.Builder> result = AuthorizedTokenIssuerListCopier.copyToBuilder(this.authorizedTokenIssuerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedTokenIssuerList(Collection<AuthorizedTokenIssuer.BuilderImpl> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copyFromBuilder(authorizedTokenIssuerList);
        }

        @Override
        public final Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copy(authorizedTokenIssuerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(AuthorizedTokenIssuer ... authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList(Arrays.asList(authorizedTokenIssuerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder> ... authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList(Stream.of(authorizedTokenIssuerList).map(c -> (AuthorizedTokenIssuer)((AuthorizedTokenIssuer.Builder)AuthorizedTokenIssuer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceIntegrationsUnion.Builder> getServiceIntegrations() {
            List<ServiceIntegrationsUnion.Builder> result = ServiceIntegrationListCopier.copyToBuilder(this.serviceIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIntegrations(Collection<ServiceIntegrationsUnion.BuilderImpl> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copyFromBuilder(serviceIntegrations);
        }

        @Override
        public final Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copy(serviceIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(ServiceIntegrationsUnion ... serviceIntegrations) {
            this.serviceIntegrations(Arrays.asList(serviceIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder> ... serviceIntegrations) {
            this.serviceIntegrations(Stream.of(serviceIntegrations).map(c -> (ServiceIntegrationsUnion)((ServiceIntegrationsUnion.Builder)ServiceIntegrationsUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RedshiftIdcApplication build() {
            return new RedshiftIdcApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftIdcApplication> {
        public Builder idcInstanceArn(String var1);

        public Builder redshiftIdcApplicationName(String var1);

        public Builder redshiftIdcApplicationArn(String var1);

        public Builder identityNamespace(String var1);

        public Builder idcDisplayName(String var1);

        public Builder iamRoleArn(String var1);

        public Builder idcManagedApplicationArn(String var1);

        public Builder idcOnboardStatus(String var1);

        public Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> var1);

        public Builder authorizedTokenIssuerList(AuthorizedTokenIssuer ... var1);

        public Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder> ... var1);

        public Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> var1);

        public Builder serviceIntegrations(ServiceIntegrationsUnion ... var1);

        public Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder> ... var1);
    }
}

