/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySnapshotCopyRetentionPeriodRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifySnapshotCopyRetentionPeriodRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifySnapshotCopyRetentionPeriodRequest.getter(ModifySnapshotCopyRetentionPeriodRequest::clusterIdentifier)).setter(ModifySnapshotCopyRetentionPeriodRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriod").getter(ModifySnapshotCopyRetentionPeriodRequest.getter(ModifySnapshotCopyRetentionPeriodRequest::retentionPeriod)).setter(ModifySnapshotCopyRetentionPeriodRequest.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<Boolean> MANUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Manual").getter(ModifySnapshotCopyRetentionPeriodRequest.getter(ModifySnapshotCopyRetentionPeriodRequest::manual)).setter(ModifySnapshotCopyRetentionPeriodRequest.setter(Builder::manual)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manual").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, RETENTION_PERIOD_FIELD, MANUAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifySnapshotCopyRetentionPeriodRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final Integer retentionPeriod;
    private final Boolean manual;

    private ModifySnapshotCopyRetentionPeriodRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.retentionPeriod = builder.retentionPeriod;
        this.manual = builder.manual;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final Boolean manual() {
        return this.manual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.manual());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotCopyRetentionPeriodRequest)) {
            return false;
        }
        ModifySnapshotCopyRetentionPeriodRequest other = (ModifySnapshotCopyRetentionPeriodRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.manual(), other.manual());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySnapshotCopyRetentionPeriodRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("Manual", (Object)this.manual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "Manual": {
                return Optional.ofNullable(clazz.cast(this.manual()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("Manual", MANUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotCopyRetentionPeriodRequest, T> g) {
        return obj -> g.apply((ModifySnapshotCopyRetentionPeriodRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Integer retentionPeriod;
        private Boolean manual;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotCopyRetentionPeriodRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.retentionPeriod(model.retentionPeriod);
            this.manual(model.manual);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getManual() {
            return this.manual;
        }

        public final void setManual(Boolean manual) {
            this.manual = manual;
        }

        @Override
        public final Builder manual(Boolean manual) {
            this.manual = manual;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotCopyRetentionPeriodRequest build() {
            return new ModifySnapshotCopyRetentionPeriodRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySnapshotCopyRetentionPeriodRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder retentionPeriod(Integer var1);

        public Builder manual(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

