/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetClusterParameterGroupResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, ResetClusterParameterGroupResponse> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(ResetClusterParameterGroupResponse.getter(ResetClusterParameterGroupResponse::parameterGroupName)).setter(ResetClusterParameterGroupResponse.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupStatus").getter(ResetClusterParameterGroupResponse.getter(ResetClusterParameterGroupResponse::parameterGroupStatus)).setter(ResetClusterParameterGroupResponse.setter(Builder::parameterGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD, PARAMETER_GROUP_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResetClusterParameterGroupResponse.memberNameToFieldInitializer();
    private final String parameterGroupName;
    private final String parameterGroupStatus;

    private ResetClusterParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterGroupStatus = builder.parameterGroupStatus;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final String parameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetClusterParameterGroupResponse)) {
            return false;
        }
        ResetClusterParameterGroupResponse other = (ResetClusterParameterGroupResponse)((Object)obj);
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterGroupStatus(), other.parameterGroupStatus());
    }

    public final String toString() {
        return ToString.builder((String)"ResetClusterParameterGroupResponse").add("ParameterGroupName", (Object)this.parameterGroupName()).add("ParameterGroupStatus", (Object)this.parameterGroupStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
        map.put("ParameterGroupStatus", PARAMETER_GROUP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetClusterParameterGroupResponse, T> g) {
        return obj -> g.apply((ResetClusterParameterGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private String parameterGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetClusterParameterGroupResponse model) {
            super(model);
            this.parameterGroupName(model.parameterGroupName);
            this.parameterGroupStatus(model.parameterGroupStatus);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getParameterGroupStatus() {
            return this.parameterGroupStatus;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        @Override
        public ResetClusterParameterGroupResponse build() {
            return new ResetClusterParameterGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetClusterParameterGroupResponse> {
        public Builder parameterGroupName(String var1);

        public Builder parameterGroupStatus(String var1);
    }
}

