/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ScheduledActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScheduledActionRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateScheduledActionRequest> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledActionName").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::scheduledActionName)).setter(CreateScheduledActionRequest.setter(Builder::scheduledActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build()}).build();
    private static final SdkField<ScheduledActionType> TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetAction").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::targetAction)).setter(CreateScheduledActionRequest.setter(Builder::targetAction)).constructor(ScheduledActionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAction").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::schedule)).setter(CreateScheduledActionRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRole").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::iamRole)).setter(CreateScheduledActionRequest.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledActionDescription").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::scheduledActionDescription)).setter(CreateScheduledActionRequest.setter(Builder::scheduledActionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionDescription").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::startTime)).setter(CreateScheduledActionRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::endTime)).setter(CreateScheduledActionRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enable").getter(CreateScheduledActionRequest.getter(CreateScheduledActionRequest::enable)).setter(CreateScheduledActionRequest.setter(Builder::enable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD, TARGET_ACTION_FIELD, SCHEDULE_FIELD, IAM_ROLE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD, START_TIME_FIELD, END_TIME_FIELD, ENABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScheduledActionRequest.memberNameToFieldInitializer();
    private final String scheduledActionName;
    private final ScheduledActionType targetAction;
    private final String schedule;
    private final String iamRole;
    private final String scheduledActionDescription;
    private final Instant startTime;
    private final Instant endTime;
    private final Boolean enable;

    private CreateScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledActionName = builder.scheduledActionName;
        this.targetAction = builder.targetAction;
        this.schedule = builder.schedule;
        this.iamRole = builder.iamRole;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.enable = builder.enable;
    }

    public final String scheduledActionName() {
        return this.scheduledActionName;
    }

    public final ScheduledActionType targetAction() {
        return this.targetAction;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final String scheduledActionDescription() {
        return this.scheduledActionDescription;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Boolean enable() {
        return this.enable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledActionRequest)) {
            return false;
        }
        CreateScheduledActionRequest other = (CreateScheduledActionRequest)((Object)obj);
        return Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.targetAction(), other.targetAction()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.scheduledActionDescription(), other.scheduledActionDescription()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.enable(), other.enable());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScheduledActionRequest").add("ScheduledActionName", (Object)this.scheduledActionName()).add("TargetAction", (Object)this.targetAction()).add("Schedule", (Object)this.schedule()).add("IamRole", (Object)this.iamRole()).add("ScheduledActionDescription", (Object)this.scheduledActionDescription()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Enable", (Object)this.enable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "TargetAction": {
                return Optional.ofNullable(clazz.cast(this.targetAction()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "ScheduledActionDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionDescription()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduledActionName", SCHEDULED_ACTION_NAME_FIELD);
        map.put("TargetAction", TARGET_ACTION_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("IamRole", IAM_ROLE_FIELD);
        map.put("ScheduledActionDescription", SCHEDULED_ACTION_DESCRIPTION_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Enable", ENABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledActionRequest, T> g) {
        return obj -> g.apply((CreateScheduledActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String scheduledActionName;
        private ScheduledActionType targetAction;
        private String schedule;
        private String iamRole;
        private String scheduledActionDescription;
        private Instant startTime;
        private Instant endTime;
        private Boolean enable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledActionRequest model) {
            super(model);
            this.scheduledActionName(model.scheduledActionName);
            this.targetAction(model.targetAction);
            this.schedule(model.schedule);
            this.iamRole(model.iamRole);
            this.scheduledActionDescription(model.scheduledActionDescription);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.enable(model.enable);
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final ScheduledActionType.Builder getTargetAction() {
            return this.targetAction != null ? this.targetAction.toBuilder() : null;
        }

        public final void setTargetAction(ScheduledActionType.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        @Override
        public final Builder targetAction(ScheduledActionType targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final String getScheduledActionDescription() {
            return this.scheduledActionDescription;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledActionRequest build() {
            return new CreateScheduledActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScheduledActionRequest> {
        public Builder scheduledActionName(String var1);

        public Builder targetAction(ScheduledActionType var1);

        default public Builder targetAction(Consumer<ScheduledActionType.Builder> targetAction) {
            return this.targetAction((ScheduledActionType)((ScheduledActionType.Builder)ScheduledActionType.builder().applyMutation(targetAction)).build());
        }

        public Builder schedule(String var1);

        public Builder iamRole(String var1);

        public Builder scheduledActionDescription(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder enable(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

