/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplication;

public class DescribeRedshiftIdcApplicationsPublisher
implements SdkPublisher<DescribeRedshiftIdcApplicationsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeRedshiftIdcApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRedshiftIdcApplicationsPublisher(RedshiftAsyncClient client, DescribeRedshiftIdcApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRedshiftIdcApplicationsPublisher(RedshiftAsyncClient client, DescribeRedshiftIdcApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRedshiftIdcApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRedshiftIdcApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RedshiftIdcApplication> redshiftIdcApplications() {
        Function<DescribeRedshiftIdcApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.redshiftIdcApplications() != null) {
                return response.redshiftIdcApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRedshiftIdcApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRedshiftIdcApplicationsResponseFetcher
    implements AsyncPageFetcher<DescribeRedshiftIdcApplicationsResponse> {
        private DescribeRedshiftIdcApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRedshiftIdcApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeRedshiftIdcApplicationsResponse> nextPage(DescribeRedshiftIdcApplicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRedshiftIdcApplicationsPublisher.this.client.describeRedshiftIdcApplications(DescribeRedshiftIdcApplicationsPublisher.this.firstRequest);
            }
            return DescribeRedshiftIdcApplicationsPublisher.this.client.describeRedshiftIdcApplications((DescribeRedshiftIdcApplicationsRequest)((Object)DescribeRedshiftIdcApplicationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

