/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClusterCredentialsWithIamRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, GetClusterCredentialsWithIamRequest> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbName").getter(GetClusterCredentialsWithIamRequest.getter(GetClusterCredentialsWithIamRequest::dbName)).setter(GetClusterCredentialsWithIamRequest.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbName").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(GetClusterCredentialsWithIamRequest.getter(GetClusterCredentialsWithIamRequest::clusterIdentifier)).setter(GetClusterCredentialsWithIamRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationSeconds").getter(GetClusterCredentialsWithIamRequest.getter(GetClusterCredentialsWithIamRequest::durationSeconds)).setter(GetClusterCredentialsWithIamRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomainName").getter(GetClusterCredentialsWithIamRequest.getter(GetClusterCredentialsWithIamRequest::customDomainName)).setter(GetClusterCredentialsWithIamRequest.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD, CLUSTER_IDENTIFIER_FIELD, DURATION_SECONDS_FIELD, CUSTOM_DOMAIN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetClusterCredentialsWithIamRequest.memberNameToFieldInitializer();
    private final String dbName;
    private final String clusterIdentifier;
    private final Integer durationSeconds;
    private final String customDomainName;

    private GetClusterCredentialsWithIamRequest(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.durationSeconds = builder.durationSeconds;
        this.customDomainName = builder.customDomainName;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsWithIamRequest)) {
            return false;
        }
        GetClusterCredentialsWithIamRequest other = (GetClusterCredentialsWithIamRequest)((Object)obj);
        return Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.customDomainName(), other.customDomainName());
    }

    public final String toString() {
        return ToString.builder((String)"GetClusterCredentialsWithIamRequest").add("DbName", (Object)this.dbName()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("DurationSeconds", (Object)this.durationSeconds()).add("CustomDomainName", (Object)this.customDomainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "CustomDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DbName", DB_NAME_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("DurationSeconds", DURATION_SECONDS_FIELD);
        map.put("CustomDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsWithIamRequest, T> g) {
        return obj -> g.apply((GetClusterCredentialsWithIamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String dbName;
        private String clusterIdentifier;
        private Integer durationSeconds;
        private String customDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsWithIamRequest model) {
            super(model);
            this.dbName(model.dbName);
            this.clusterIdentifier(model.clusterIdentifier);
            this.durationSeconds(model.durationSeconds);
            this.customDomainName(model.customDomainName);
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetClusterCredentialsWithIamRequest build() {
            return new GetClusterCredentialsWithIamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClusterCredentialsWithIamRequest> {
        public Builder dbName(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder customDomainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

