/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ScheduledActionState;
import software.amazon.awssdk.services.redshift.model.ScheduledActionTimeListCopier;
import software.amazon.awssdk.services.redshift.model.ScheduledActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScheduledActionResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, CreateScheduledActionResponse> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledActionName").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::scheduledActionName)).setter(CreateScheduledActionResponse.setter(Builder::scheduledActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build()}).build();
    private static final SdkField<ScheduledActionType> TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetAction").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::targetAction)).setter(CreateScheduledActionResponse.setter(Builder::targetAction)).constructor(ScheduledActionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAction").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::schedule)).setter(CreateScheduledActionResponse.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRole").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::iamRole)).setter(CreateScheduledActionResponse.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledActionDescription").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::scheduledActionDescription)).setter(CreateScheduledActionResponse.setter(Builder::scheduledActionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionDescription").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::stateAsString)).setter(CreateScheduledActionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NextInvocations").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::nextInvocations)).setter(CreateScheduledActionResponse.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build(), ListTrait.builder().memberLocationName("ScheduledActionTime").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionTime").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::startTime)).setter(CreateScheduledActionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CreateScheduledActionResponse.getter(CreateScheduledActionResponse::endTime)).setter(CreateScheduledActionResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD, TARGET_ACTION_FIELD, SCHEDULE_FIELD, IAM_ROLE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD, STATE_FIELD, NEXT_INVOCATIONS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScheduledActionResponse.memberNameToFieldInitializer();
    private final String scheduledActionName;
    private final ScheduledActionType targetAction;
    private final String schedule;
    private final String iamRole;
    private final String scheduledActionDescription;
    private final String state;
    private final List<Instant> nextInvocations;
    private final Instant startTime;
    private final Instant endTime;

    private CreateScheduledActionResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledActionName = builder.scheduledActionName;
        this.targetAction = builder.targetAction;
        this.schedule = builder.schedule;
        this.iamRole = builder.iamRole;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.state = builder.state;
        this.nextInvocations = builder.nextInvocations;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String scheduledActionName() {
        return this.scheduledActionName;
    }

    public final ScheduledActionType targetAction() {
        return this.targetAction;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final String scheduledActionDescription() {
        return this.scheduledActionDescription;
    }

    public final ScheduledActionState state() {
        return ScheduledActionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasNextInvocations() {
        return this.nextInvocations != null && !(this.nextInvocations instanceof SdkAutoConstructList);
    }

    public final List<Instant> nextInvocations() {
        return this.nextInvocations;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextInvocations() ? this.nextInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledActionResponse)) {
            return false;
        }
        CreateScheduledActionResponse other = (CreateScheduledActionResponse)((Object)obj);
        return Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.targetAction(), other.targetAction()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.scheduledActionDescription(), other.scheduledActionDescription()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasNextInvocations() == other.hasNextInvocations() && Objects.equals(this.nextInvocations(), other.nextInvocations()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScheduledActionResponse").add("ScheduledActionName", (Object)this.scheduledActionName()).add("TargetAction", (Object)this.targetAction()).add("Schedule", (Object)this.schedule()).add("IamRole", (Object)this.iamRole()).add("ScheduledActionDescription", (Object)this.scheduledActionDescription()).add("State", (Object)this.stateAsString()).add("NextInvocations", this.hasNextInvocations() ? this.nextInvocations() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "TargetAction": {
                return Optional.ofNullable(clazz.cast(this.targetAction()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "ScheduledActionDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionDescription()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "NextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduledActionName", SCHEDULED_ACTION_NAME_FIELD);
        map.put("TargetAction", TARGET_ACTION_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("IamRole", IAM_ROLE_FIELD);
        map.put("ScheduledActionDescription", SCHEDULED_ACTION_DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("NextInvocations", NEXT_INVOCATIONS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledActionResponse, T> g) {
        return obj -> g.apply((CreateScheduledActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String scheduledActionName;
        private ScheduledActionType targetAction;
        private String schedule;
        private String iamRole;
        private String scheduledActionDescription;
        private String state;
        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledActionResponse model) {
            super(model);
            this.scheduledActionName(model.scheduledActionName);
            this.targetAction(model.targetAction);
            this.schedule(model.schedule);
            this.iamRole(model.iamRole);
            this.scheduledActionDescription(model.scheduledActionDescription);
            this.state(model.state);
            this.nextInvocations(model.nextInvocations);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final ScheduledActionType.Builder getTargetAction() {
            return this.targetAction != null ? this.targetAction.toBuilder() : null;
        }

        public final void setTargetAction(ScheduledActionType.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        @Override
        public final Builder targetAction(ScheduledActionType targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final String getScheduledActionDescription() {
            return this.scheduledActionDescription;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledActionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<Instant> getNextInvocations() {
            if (this.nextInvocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nextInvocations;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledActionTimeListCopier.copy(nextInvocations);
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledActionTimeListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant ... nextInvocations) {
            this.nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public CreateScheduledActionResponse build() {
            return new CreateScheduledActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScheduledActionResponse> {
        public Builder scheduledActionName(String var1);

        public Builder targetAction(ScheduledActionType var1);

        default public Builder targetAction(Consumer<ScheduledActionType.Builder> targetAction) {
            return this.targetAction((ScheduledActionType)((ScheduledActionType.Builder)ScheduledActionType.builder().applyMutation(targetAction)).build());
        }

        public Builder schedule(String var1);

        public Builder iamRole(String var1);

        public Builder scheduledActionDescription(String var1);

        public Builder state(String var1);

        public Builder state(ScheduledActionState var1);

        public Builder nextInvocations(Collection<Instant> var1);

        public Builder nextInvocations(Instant ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

