/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeStorageResponse> {
    private static final SdkField<Double> TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalBackupSizeInMegaBytes").getter(DescribeStorageResponse.getter(DescribeStorageResponse::totalBackupSizeInMegaBytes)).setter(DescribeStorageResponse.setter(Builder::totalBackupSizeInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBackupSizeInMegaBytes").build()}).build();
    private static final SdkField<Double> TOTAL_PROVISIONED_STORAGE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalProvisionedStorageInMegaBytes").getter(DescribeStorageResponse.getter(DescribeStorageResponse::totalProvisionedStorageInMegaBytes)).setter(DescribeStorageResponse.setter(Builder::totalProvisionedStorageInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalProvisionedStorageInMegaBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD, TOTAL_PROVISIONED_STORAGE_IN_MEGA_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStorageResponse.memberNameToFieldInitializer();
    private final Double totalBackupSizeInMegaBytes;
    private final Double totalProvisionedStorageInMegaBytes;

    private DescribeStorageResponse(BuilderImpl builder) {
        super(builder);
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
        this.totalProvisionedStorageInMegaBytes = builder.totalProvisionedStorageInMegaBytes;
    }

    public final Double totalBackupSizeInMegaBytes() {
        return this.totalBackupSizeInMegaBytes;
    }

    public final Double totalProvisionedStorageInMegaBytes() {
        return this.totalProvisionedStorageInMegaBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalProvisionedStorageInMegaBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageResponse)) {
            return false;
        }
        DescribeStorageResponse other = (DescribeStorageResponse)((Object)obj);
        return Objects.equals(this.totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes()) && Objects.equals(this.totalProvisionedStorageInMegaBytes(), other.totalProvisionedStorageInMegaBytes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageResponse").add("TotalBackupSizeInMegaBytes", (Object)this.totalBackupSizeInMegaBytes()).add("TotalProvisionedStorageInMegaBytes", (Object)this.totalProvisionedStorageInMegaBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalBackupSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalBackupSizeInMegaBytes()));
            }
            case "TotalProvisionedStorageInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalProvisionedStorageInMegaBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Double>> map = new HashMap<String, SdkField<Double>>();
        map.put("TotalBackupSizeInMegaBytes", TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD);
        map.put("TotalProvisionedStorageInMegaBytes", TOTAL_PROVISIONED_STORAGE_IN_MEGA_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageResponse, T> g) {
        return obj -> g.apply((DescribeStorageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private Double totalBackupSizeInMegaBytes;
        private Double totalProvisionedStorageInMegaBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageResponse model) {
            super(model);
            this.totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
            this.totalProvisionedStorageInMegaBytes(model.totalProvisionedStorageInMegaBytes);
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return this.totalBackupSizeInMegaBytes;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public final Double getTotalProvisionedStorageInMegaBytes() {
            return this.totalProvisionedStorageInMegaBytes;
        }

        public final void setTotalProvisionedStorageInMegaBytes(Double totalProvisionedStorageInMegaBytes) {
            this.totalProvisionedStorageInMegaBytes = totalProvisionedStorageInMegaBytes;
        }

        @Override
        public final Builder totalProvisionedStorageInMegaBytes(Double totalProvisionedStorageInMegaBytes) {
            this.totalProvisionedStorageInMegaBytes = totalProvisionedStorageInMegaBytes;
            return this;
        }

        @Override
        public DescribeStorageResponse build() {
            return new DescribeStorageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageResponse> {
        public Builder totalBackupSizeInMegaBytes(Double var1);

        public Builder totalProvisionedStorageInMegaBytes(Double var1);
    }
}

