/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.VpcIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeEndpointAccessRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, AuthorizeEndpointAccessRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(AuthorizeEndpointAccessRequest.getter(AuthorizeEndpointAccessRequest::clusterIdentifier)).setter(AuthorizeEndpointAccessRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Account").getter(AuthorizeEndpointAccessRequest.getter(AuthorizeEndpointAccessRequest::account)).setter(AuthorizeEndpointAccessRequest.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<List<String>> VPC_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcIds").getter(AuthorizeEndpointAccessRequest.getter(AuthorizeEndpointAccessRequest::vpcIds)).setter(AuthorizeEndpointAccessRequest.setter(Builder::vpcIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIds").build(), ListTrait.builder().memberLocationName("VpcIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIdentifier").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, ACCOUNT_FIELD, VPC_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizeEndpointAccessRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String account;
    private final List<String> vpcIds;

    private AuthorizeEndpointAccessRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.account = builder.account;
        this.vpcIds = builder.vpcIds;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String account() {
        return this.account;
    }

    public final boolean hasVpcIds() {
        return this.vpcIds != null && !(this.vpcIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcIds() {
        return this.vpcIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcIds() ? this.vpcIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeEndpointAccessRequest)) {
            return false;
        }
        AuthorizeEndpointAccessRequest other = (AuthorizeEndpointAccessRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.account(), other.account()) && this.hasVpcIds() == other.hasVpcIds() && Objects.equals(this.vpcIds(), other.vpcIds());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeEndpointAccessRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("Account", (Object)this.account()).add("VpcIds", this.hasVpcIds() ? this.vpcIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "VpcIds": {
                return Optional.ofNullable(clazz.cast(this.vpcIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("Account", ACCOUNT_FIELD);
        map.put("VpcIds", VPC_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeEndpointAccessRequest, T> g) {
        return obj -> g.apply((AuthorizeEndpointAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String account;
        private List<String> vpcIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeEndpointAccessRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.account(model.account);
            this.vpcIds(model.vpcIds);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Collection<String> getVpcIds() {
            if (this.vpcIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcIds;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcIdentifierListCopier.copy(vpcIds);
        }

        @Override
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcIdentifierListCopier.copy(vpcIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIds(String ... vpcIds) {
            this.vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeEndpointAccessRequest build() {
            return new AuthorizeEndpointAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeEndpointAccessRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder account(String var1);

        public Builder vpcIds(Collection<String> var1);

        public Builder vpcIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

