/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a usage limit object for a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyUsageLimitResponse extends RedshiftResponse implements
        ToCopyableBuilder<ModifyUsageLimitResponse.Builder, ModifyUsageLimitResponse> {
    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageLimitId").getter(getter(ModifyUsageLimitResponse::usageLimitId))
            .setter(setter(Builder::usageLimitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageLimitId").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyUsageLimitResponse::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureType").getter(getter(ModifyUsageLimitResponse::featureTypeAsString))
            .setter(setter(Builder::featureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()).build();

    private static final SdkField<String> LIMIT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LimitType").getter(getter(ModifyUsageLimitResponse::limitTypeAsString))
            .setter(setter(Builder::limitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitType").build()).build();

    private static final SdkField<Long> AMOUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Amount")
            .getter(getter(ModifyUsageLimitResponse::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Period")
            .getter(getter(ModifyUsageLimitResponse::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BreachAction").getter(getter(ModifyUsageLimitResponse::breachActionAsString))
            .setter(setter(Builder::breachAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreachAction").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ModifyUsageLimitResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_LIMIT_ID_FIELD,
            CLUSTER_IDENTIFIER_FIELD, FEATURE_TYPE_FIELD, LIMIT_TYPE_FIELD, AMOUNT_FIELD, PERIOD_FIELD, BREACH_ACTION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String usageLimitId;

    private final String clusterIdentifier;

    private final String featureType;

    private final String limitType;

    private final Long amount;

    private final String period;

    private final String breachAction;

    private final List<Tag> tags;

    private ModifyUsageLimitResponse(BuilderImpl builder) {
        super(builder);
        this.usageLimitId = builder.usageLimitId;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.featureType = builder.featureType;
        this.limitType = builder.limitType;
        this.amount = builder.amount;
        this.period = builder.period;
        this.breachAction = builder.breachAction;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the usage limit.
     * </p>
     * 
     * @return The identifier of the usage limit.
     */
    public final String usageLimitId() {
        return usageLimitId;
    }

    /**
     * <p>
     * The identifier of the cluster with a usage limit.
     * </p>
     * 
     * @return The identifier of the cluster with a usage limit.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Redshift feature to which the limit applies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureType} will
     * return {@link UsageLimitFeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureTypeAsString}.
     * </p>
     * 
     * @return The Amazon Redshift feature to which the limit applies.
     * @see UsageLimitFeatureType
     */
    public final UsageLimitFeatureType featureType() {
        return UsageLimitFeatureType.fromValue(featureType);
    }

    /**
     * <p>
     * The Amazon Redshift feature to which the limit applies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureType} will
     * return {@link UsageLimitFeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureTypeAsString}.
     * </p>
     * 
     * @return The Amazon Redshift feature to which the limit applies.
     * @see UsageLimitFeatureType
     */
    public final String featureTypeAsString() {
        return featureType;
    }

    /**
     * <p>
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limitType} will
     * return {@link UsageLimitLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #limitTypeAsString}.
     * </p>
     * 
     * @return The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     * @see UsageLimitLimitType
     */
    public final UsageLimitLimitType limitType() {
        return UsageLimitLimitType.fromValue(limitType);
    }

    /**
     * <p>
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limitType} will
     * return {@link UsageLimitLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #limitTypeAsString}.
     * </p>
     * 
     * @return The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     * @see UsageLimitLimitType
     */
    public final String limitTypeAsString() {
        return limitType;
    }

    /**
     * <p>
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
     * </p>
     * 
     * @return The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes
     *         (TB).
     */
    public final Long amount() {
        return amount;
    }

    /**
     * <p>
     * The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is
     * <code>monthly</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link UsageLimitPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is
     *         <code>monthly</code>.
     * @see UsageLimitPeriod
     */
    public final UsageLimitPeriod period() {
        return UsageLimitPeriod.fromValue(period);
    }

    /**
     * <p>
     * The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is
     * <code>monthly</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link UsageLimitPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is
     *         <code>monthly</code>.
     * @see UsageLimitPeriod
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The action that Amazon Redshift takes when the limit is reached. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>log</b> - To log an event in a system table. The default is log.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>emit-metric</b> - To emit CloudWatch metrics.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>disable</b> - To disable the feature until the next usage period begins.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>log</b> - To log an event in a system table. The default is log.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>emit-metric</b> - To emit CloudWatch metrics.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>disable</b> - To disable the feature until the next usage period begins.
     *         </p>
     *         </li>
     * @see UsageLimitBreachAction
     */
    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(breachAction);
    }

    /**
     * <p>
     * The action that Amazon Redshift takes when the limit is reached. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>log</b> - To log an event in a system table. The default is log.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>emit-metric</b> - To emit CloudWatch metrics.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>disable</b> - To disable the feature until the next usage period begins.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>log</b> - To log an event in a system table. The default is log.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>emit-metric</b> - To emit CloudWatch metrics.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>disable</b> - To disable the feature until the next usage period begins.
     *         </p>
     *         </li>
     * @see UsageLimitBreachAction
     */
    public final String breachActionAsString() {
        return breachAction;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tag instances.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageLimitId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(featureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUsageLimitResponse)) {
            return false;
        }
        ModifyUsageLimitResponse other = (ModifyUsageLimitResponse) obj;
        return Objects.equals(usageLimitId(), other.usageLimitId())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(featureTypeAsString(), other.featureTypeAsString())
                && Objects.equals(limitTypeAsString(), other.limitTypeAsString()) && Objects.equals(amount(), other.amount())
                && Objects.equals(periodAsString(), other.periodAsString())
                && Objects.equals(breachActionAsString(), other.breachActionAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyUsageLimitResponse").add("UsageLimitId", usageLimitId())
                .add("ClusterIdentifier", clusterIdentifier()).add("FeatureType", featureTypeAsString())
                .add("LimitType", limitTypeAsString()).add("Amount", amount()).add("Period", periodAsString())
                .add("BreachAction", breachActionAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageLimitId":
            return Optional.ofNullable(clazz.cast(usageLimitId()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "FeatureType":
            return Optional.ofNullable(clazz.cast(featureTypeAsString()));
        case "LimitType":
            return Optional.ofNullable(clazz.cast(limitTypeAsString()));
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "BreachAction":
            return Optional.ofNullable(clazz.cast(breachActionAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsageLimitId", USAGE_LIMIT_ID_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("FeatureType", FEATURE_TYPE_FIELD);
        map.put("LimitType", LIMIT_TYPE_FIELD);
        map.put("Amount", AMOUNT_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("BreachAction", BREACH_ACTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyUsageLimitResponse, T> g) {
        return obj -> g.apply((ModifyUsageLimitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyUsageLimitResponse> {
        /**
         * <p>
         * The identifier of the usage limit.
         * </p>
         * 
         * @param usageLimitId
         *        The identifier of the usage limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimitId(String usageLimitId);

        /**
         * <p>
         * The identifier of the cluster with a usage limit.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster with a usage limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The Amazon Redshift feature to which the limit applies.
         * </p>
         * 
         * @param featureType
         *        The Amazon Redshift feature to which the limit applies.
         * @see UsageLimitFeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitFeatureType
         */
        Builder featureType(String featureType);

        /**
         * <p>
         * The Amazon Redshift feature to which the limit applies.
         * </p>
         * 
         * @param featureType
         *        The Amazon Redshift feature to which the limit applies.
         * @see UsageLimitFeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitFeatureType
         */
        Builder featureType(UsageLimitFeatureType featureType);

        /**
         * <p>
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         * </p>
         * 
         * @param limitType
         *        The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         * @see UsageLimitLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitLimitType
         */
        Builder limitType(String limitType);

        /**
         * <p>
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         * </p>
         * 
         * @param limitType
         *        The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         * @see UsageLimitLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitLimitType
         */
        Builder limitType(UsageLimitLimitType limitType);

        /**
         * <p>
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
         * </p>
         * 
         * @param amount
         *        The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes
         *        (TB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Long amount);

        /**
         * <p>
         * The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is
         * <code>monthly</code>.
         * </p>
         * 
         * @param period
         *        The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default
         *        is <code>monthly</code>.
         * @see UsageLimitPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitPeriod
         */
        Builder period(String period);

        /**
         * <p>
         * The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is
         * <code>monthly</code>.
         * </p>
         * 
         * @param period
         *        The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default
         *        is <code>monthly</code>.
         * @see UsageLimitPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitPeriod
         */
        Builder period(UsageLimitPeriod period);

        /**
         * <p>
         * The action that Amazon Redshift takes when the limit is reached. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>log</b> - To log an event in a system table. The default is log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>emit-metric</b> - To emit CloudWatch metrics.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>disable</b> - To disable the feature until the next usage period begins.
         * </p>
         * </li>
         * </ul>
         * 
         * @param breachAction
         *        The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>log</b> - To log an event in a system table. The default is log.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>emit-metric</b> - To emit CloudWatch metrics.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>disable</b> - To disable the feature until the next usage period begins.
         *        </p>
         *        </li>
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(String breachAction);

        /**
         * <p>
         * The action that Amazon Redshift takes when the limit is reached. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>log</b> - To log an event in a system table. The default is log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>emit-metric</b> - To emit CloudWatch metrics.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>disable</b> - To disable the feature until the next usage period begins.
         * </p>
         * </li>
         * </ul>
         * 
         * @param breachAction
         *        The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>log</b> - To log an event in a system table. The default is log.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>emit-metric</b> - To emit CloudWatch metrics.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>disable</b> - To disable the feature until the next usage period begins.
         *        </p>
         *        </li>
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(UsageLimitBreachAction breachAction);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * 
         * @param tags
         *        A list of tag instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * 
         * @param tags
         *        A list of tag instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.redshift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String usageLimitId;

        private String clusterIdentifier;

        private String featureType;

        private String limitType;

        private Long amount;

        private String period;

        private String breachAction;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUsageLimitResponse model) {
            super(model);
            usageLimitId(model.usageLimitId);
            clusterIdentifier(model.clusterIdentifier);
            featureType(model.featureType);
            limitType(model.limitType);
            amount(model.amount);
            period(model.period);
            breachAction(model.breachAction);
            tags(model.tags);
        }

        public final String getUsageLimitId() {
            return usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getFeatureType() {
            return featureType;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(UsageLimitFeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public final String getLimitType() {
            return limitType;
        }

        public final void setLimitType(String limitType) {
            this.limitType = limitType;
        }

        @Override
        public final Builder limitType(String limitType) {
            this.limitType = limitType;
            return this;
        }

        @Override
        public final Builder limitType(UsageLimitLimitType limitType) {
            this.limitType(limitType == null ? null : limitType.toString());
            return this;
        }

        public final Long getAmount() {
            return amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(UsageLimitPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getBreachAction() {
            return breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModifyUsageLimitResponse build() {
            return new ModifyUsageLimitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
