/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCustomDomainAssociationResponse extends RedshiftResponse implements
        ToCopyableBuilder<ModifyCustomDomainAssociationResponse.Builder, ModifyCustomDomainAssociationResponse> {
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainName").getter(getter(ModifyCustomDomainAssociationResponse::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainName").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainCertificateArn")
            .getter(getter(ModifyCustomDomainAssociationResponse::customDomainCertificateArn))
            .setter(setter(Builder::customDomainCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateArn").build())
            .build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyCustomDomainAssociationResponse::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_CERT_EXPIRY_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainCertExpiryTime")
            .getter(getter(ModifyCustomDomainAssociationResponse::customDomainCertExpiryTime))
            .setter(setter(Builder::customDomainCertExpiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertExpiryTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DOMAIN_NAME_FIELD,
            CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CLUSTER_IDENTIFIER_FIELD, CUSTOM_DOMAIN_CERT_EXPIRY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customDomainName;

    private final String customDomainCertificateArn;

    private final String clusterIdentifier;

    private final String customDomainCertExpiryTime;

    private ModifyCustomDomainAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.customDomainName = builder.customDomainName;
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.customDomainCertExpiryTime = builder.customDomainCertExpiryTime;
    }

    /**
     * <p>
     * The custom domain name associated with the result for the changed custom domain association.
     * </p>
     * 
     * @return The custom domain name associated with the result for the changed custom domain association.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The certificate Amazon Resource Name (ARN) associated with the result for the changed custom domain association.
     * </p>
     * 
     * @return The certificate Amazon Resource Name (ARN) associated with the result for the changed custom domain
     *         association.
     */
    public final String customDomainCertificateArn() {
        return customDomainCertificateArn;
    }

    /**
     * <p>
     * The identifier of the cluster associated with the result for the changed custom domain association.
     * </p>
     * 
     * @return The identifier of the cluster associated with the result for the changed custom domain association.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The certificate expiration time associated with the result for the changed custom domain association.
     * </p>
     * 
     * @return The certificate expiration time associated with the result for the changed custom domain association.
     */
    public final String customDomainCertExpiryTime() {
        return customDomainCertExpiryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertExpiryTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCustomDomainAssociationResponse)) {
            return false;
        }
        ModifyCustomDomainAssociationResponse other = (ModifyCustomDomainAssociationResponse) obj;
        return Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(customDomainCertificateArn(), other.customDomainCertificateArn())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(customDomainCertExpiryTime(), other.customDomainCertExpiryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCustomDomainAssociationResponse").add("CustomDomainName", customDomainName())
                .add("CustomDomainCertificateArn", customDomainCertificateArn()).add("ClusterIdentifier", clusterIdentifier())
                .add("CustomDomainCertExpiryTime", customDomainCertExpiryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "CustomDomainCertificateArn":
            return Optional.ofNullable(clazz.cast(customDomainCertificateArn()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "CustomDomainCertExpiryTime":
            return Optional.ofNullable(clazz.cast(customDomainCertExpiryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("CustomDomainCertificateArn", CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("CustomDomainCertExpiryTime", CUSTOM_DOMAIN_CERT_EXPIRY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCustomDomainAssociationResponse, T> g) {
        return obj -> g.apply((ModifyCustomDomainAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCustomDomainAssociationResponse> {
        /**
         * <p>
         * The custom domain name associated with the result for the changed custom domain association.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name associated with the result for the changed custom domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The certificate Amazon Resource Name (ARN) associated with the result for the changed custom domain
         * association.
         * </p>
         * 
         * @param customDomainCertificateArn
         *        The certificate Amazon Resource Name (ARN) associated with the result for the changed custom domain
         *        association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateArn(String customDomainCertificateArn);

        /**
         * <p>
         * The identifier of the cluster associated with the result for the changed custom domain association.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster associated with the result for the changed custom domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The certificate expiration time associated with the result for the changed custom domain association.
         * </p>
         * 
         * @param customDomainCertExpiryTime
         *        The certificate expiration time associated with the result for the changed custom domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertExpiryTime(String customDomainCertExpiryTime);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String customDomainName;

        private String customDomainCertificateArn;

        private String clusterIdentifier;

        private String customDomainCertExpiryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCustomDomainAssociationResponse model) {
            super(model);
            customDomainName(model.customDomainName);
            customDomainCertificateArn(model.customDomainCertificateArn);
            clusterIdentifier(model.clusterIdentifier);
            customDomainCertExpiryTime(model.customDomainCertExpiryTime);
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getCustomDomainCertificateArn() {
            return customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getCustomDomainCertExpiryTime() {
            return customDomainCertExpiryTime;
        }

        public final void setCustomDomainCertExpiryTime(String customDomainCertExpiryTime) {
            this.customDomainCertExpiryTime = customDomainCertExpiryTime;
        }

        @Override
        public final Builder customDomainCertExpiryTime(String customDomainCertExpiryTime) {
            this.customDomainCertExpiryTime = customDomainCertExpiryTime;
            return this;
        }

        @Override
        public ModifyCustomDomainAssociationResponse build() {
            return new ModifyCustomDomainAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
