/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyAuthenticationProfileResponse extends RedshiftResponse implements
        ToCopyableBuilder<ModifyAuthenticationProfileResponse.Builder, ModifyAuthenticationProfileResponse> {
    private static final SdkField<String> AUTHENTICATION_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationProfileName")
            .getter(getter(ModifyAuthenticationProfileResponse::authenticationProfileName))
            .setter(setter(Builder::authenticationProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProfileName").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_PROFILE_CONTENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationProfileContent")
            .getter(getter(ModifyAuthenticationProfileResponse::authenticationProfileContent))
            .setter(setter(Builder::authenticationProfileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProfileContent")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHENTICATION_PROFILE_NAME_FIELD, AUTHENTICATION_PROFILE_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationProfileName;

    private final String authenticationProfileContent;

    private ModifyAuthenticationProfileResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationProfileName = builder.authenticationProfileName;
        this.authenticationProfileContent = builder.authenticationProfileContent;
    }

    /**
     * <p>
     * The name of the authentication profile that was replaced.
     * </p>
     * 
     * @return The name of the authentication profile that was replaced.
     */
    public final String authenticationProfileName() {
        return authenticationProfileName;
    }

    /**
     * <p>
     * The updated content of the authentication profile in JSON format.
     * </p>
     * 
     * @return The updated content of the authentication profile in JSON format.
     */
    public final String authenticationProfileContent() {
        return authenticationProfileContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationProfileContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyAuthenticationProfileResponse)) {
            return false;
        }
        ModifyAuthenticationProfileResponse other = (ModifyAuthenticationProfileResponse) obj;
        return Objects.equals(authenticationProfileName(), other.authenticationProfileName())
                && Objects.equals(authenticationProfileContent(), other.authenticationProfileContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyAuthenticationProfileResponse")
                .add("AuthenticationProfileName", authenticationProfileName())
                .add("AuthenticationProfileContent", authenticationProfileContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationProfileName":
            return Optional.ofNullable(clazz.cast(authenticationProfileName()));
        case "AuthenticationProfileContent":
            return Optional.ofNullable(clazz.cast(authenticationProfileContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationProfileName", AUTHENTICATION_PROFILE_NAME_FIELD);
        map.put("AuthenticationProfileContent", AUTHENTICATION_PROFILE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyAuthenticationProfileResponse, T> g) {
        return obj -> g.apply((ModifyAuthenticationProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyAuthenticationProfileResponse> {
        /**
         * <p>
         * The name of the authentication profile that was replaced.
         * </p>
         * 
         * @param authenticationProfileName
         *        The name of the authentication profile that was replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProfileName(String authenticationProfileName);

        /**
         * <p>
         * The updated content of the authentication profile in JSON format.
         * </p>
         * 
         * @param authenticationProfileContent
         *        The updated content of the authentication profile in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProfileContent(String authenticationProfileContent);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String authenticationProfileName;

        private String authenticationProfileContent;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyAuthenticationProfileResponse model) {
            super(model);
            authenticationProfileName(model.authenticationProfileName);
            authenticationProfileContent(model.authenticationProfileContent);
        }

        public final String getAuthenticationProfileName() {
            return authenticationProfileName;
        }

        public final void setAuthenticationProfileName(String authenticationProfileName) {
            this.authenticationProfileName = authenticationProfileName;
        }

        @Override
        public final Builder authenticationProfileName(String authenticationProfileName) {
            this.authenticationProfileName = authenticationProfileName;
            return this;
        }

        public final String getAuthenticationProfileContent() {
            return authenticationProfileContent;
        }

        public final void setAuthenticationProfileContent(String authenticationProfileContent) {
            this.authenticationProfileContent = authenticationProfileContent;
        }

        @Override
        public final Builder authenticationProfileContent(String authenticationProfileContent) {
            this.authenticationProfileContent = authenticationProfileContent;
            return this;
        }

        @Override
        public ModifyAuthenticationProfileResponse build() {
            return new ModifyAuthenticationProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
