/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of changes to HSM settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HsmStatus implements SdkPojo, Serializable, ToCopyableBuilder<HsmStatus.Builder, HsmStatus> {
    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HsmClientCertificateIdentifier")
            .getter(getter(HsmStatus::hsmClientCertificateIdentifier))
            .setter(setter(Builder::hsmClientCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier")
                    .build()).build();

    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HsmConfigurationIdentifier")
            .getter(getter(HsmStatus::hsmConfigurationIdentifier))
            .setter(setter(Builder::hsmConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(HsmStatus::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hsmClientCertificateIdentifier;

    private final String hsmConfigurationIdentifier;

    private final String status;

    private HsmStatus(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption
     * keys stored in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
     *         encryption keys stored in an HSM.
     */
    public final String hsmClientCertificateIdentifier() {
        return hsmClientCertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to
     * retrieve and store keys in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can
     *         use to retrieve and store keys in an HSM.
     */
    public final String hsmConfigurationIdentifier() {
        return hsmConfigurationIdentifier;
    }

    /**
     * <p>
     * Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify
     * cluster command.
     * </p>
     * <p>
     * Values: active, applying
     * </p>
     * 
     * @return Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a
     *         modify cluster command.</p>
     *         <p>
     *         Values: active, applying
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmStatus)) {
            return false;
        }
        HsmStatus other = (HsmStatus) obj;
        return Objects.equals(hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier())
                && Objects.equals(hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HsmStatus").add("HsmClientCertificateIdentifier", hsmClientCertificateIdentifier())
                .add("HsmConfigurationIdentifier", hsmConfigurationIdentifier()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmClientCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(hsmClientCertificateIdentifier()));
        case "HsmConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(hsmConfigurationIdentifier()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HsmClientCertificateIdentifier", HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("HsmConfigurationIdentifier", HSM_CONFIGURATION_IDENTIFIER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HsmStatus, T> g) {
        return obj -> g.apply((HsmStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HsmStatus> {
        /**
         * <p>
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         * encryption keys stored in an HSM.
         * </p>
         * 
         * @param hsmClientCertificateIdentifier
         *        Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         *        encryption keys stored in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier);

        /**
         * <p>
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use
         * to retrieve and store keys in an HSM.
         * </p>
         * 
         * @param hsmConfigurationIdentifier
         *        Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster
         *        can use to retrieve and store keys in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier);

        /**
         * <p>
         * Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a
         * modify cluster command.
         * </p>
         * <p>
         * Values: active, applying
         * </p>
         * 
         * @param status
         *        Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified
         *        in a modify cluster command.</p>
         *        <p>
         *        Values: active, applying
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String hsmClientCertificateIdentifier;

        private String hsmConfigurationIdentifier;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HsmStatus model) {
            hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            status(model.status);
        }

        public final String getHsmClientCertificateIdentifier() {
            return hsmClientCertificateIdentifier;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final String getHsmConfigurationIdentifier() {
            return hsmConfigurationIdentifier;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public HsmStatus build() {
            return new HsmStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
