/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterTracksResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterTracksResponse.Builder, DescribeClusterTracksResponse> {
    private static final SdkField<List<MaintenanceTrack>> MAINTENANCE_TRACKS_FIELD = SdkField
            .<List<MaintenanceTrack>> builder(MarshallingType.LIST)
            .memberName("MaintenanceTracks")
            .getter(getter(DescribeClusterTracksResponse::maintenanceTracks))
            .setter(setter(Builder::maintenanceTracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("MaintenanceTrack")
                            .memberFieldInfo(
                                    SdkField.<MaintenanceTrack> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceTrack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("MaintenanceTrack").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeClusterTracksResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_TRACKS_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MaintenanceTrack> maintenanceTracks;

    private final String marker;

    private DescribeClusterTracksResponse(BuilderImpl builder) {
        super(builder);
        this.maintenanceTracks = builder.maintenanceTracks;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the MaintenanceTracks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMaintenanceTracks() {
        return maintenanceTracks != null && !(maintenanceTracks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMaintenanceTracks} method.
     * </p>
     * 
     * @return A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
     */
    public final List<MaintenanceTrack> maintenanceTracks() {
        return maintenanceTracks;
    }

    /**
     * <p>
     * The starting point to return a set of response tracklist records. You can retrieve the next set of response
     * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return The starting point to return a set of response tracklist records. You can retrieve the next set of
     *         response records by providing the returned marker value in the <code>Marker</code> parameter and retrying
     *         the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMaintenanceTracks() ? maintenanceTracks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterTracksResponse)) {
            return false;
        }
        DescribeClusterTracksResponse other = (DescribeClusterTracksResponse) obj;
        return hasMaintenanceTracks() == other.hasMaintenanceTracks()
                && Objects.equals(maintenanceTracks(), other.maintenanceTracks()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterTracksResponse")
                .add("MaintenanceTracks", hasMaintenanceTracks() ? maintenanceTracks() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceTracks":
            return Optional.ofNullable(clazz.cast(maintenanceTracks()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaintenanceTracks", MAINTENANCE_TRACKS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterTracksResponse, T> g) {
        return obj -> g.apply((DescribeClusterTracksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterTracksResponse> {
        /**
         * <p>
         * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * </p>
         * 
         * @param maintenanceTracks
         *        A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTracks(Collection<MaintenanceTrack> maintenanceTracks);

        /**
         * <p>
         * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * </p>
         * 
         * @param maintenanceTracks
         *        A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTracks(MaintenanceTrack... maintenanceTracks);

        /**
         * <p>
         * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.MaintenanceTrack.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.MaintenanceTrack#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.MaintenanceTrack.Builder#build()} is called immediately
         * and its result is passed to {@link #maintenanceTracks(List<MaintenanceTrack>)}.
         * 
         * @param maintenanceTracks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.MaintenanceTrack.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceTracks(java.util.Collection<MaintenanceTrack>)
         */
        Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder>... maintenanceTracks);

        /**
         * <p>
         * The starting point to return a set of response tracklist records. You can retrieve the next set of response
         * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        The starting point to return a set of response tracklist records. You can retrieve the next set of
         *        response records by providing the returned marker value in the <code>Marker</code> parameter and
         *        retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<MaintenanceTrack> maintenanceTracks = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterTracksResponse model) {
            super(model);
            maintenanceTracks(model.maintenanceTracks);
            marker(model.marker);
        }

        public final List<MaintenanceTrack.Builder> getMaintenanceTracks() {
            List<MaintenanceTrack.Builder> result = TrackListCopier.copyToBuilder(this.maintenanceTracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceTracks(Collection<MaintenanceTrack.BuilderImpl> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copyFromBuilder(maintenanceTracks);
        }

        @Override
        public final Builder maintenanceTracks(Collection<MaintenanceTrack> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copy(maintenanceTracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceTracks(MaintenanceTrack... maintenanceTracks) {
            maintenanceTracks(Arrays.asList(maintenanceTracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder>... maintenanceTracks) {
            maintenanceTracks(Stream.of(maintenanceTracks).map(c -> MaintenanceTrack.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeClusterTracksResponse build() {
            return new DescribeClusterTracksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
