/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.RedshiftServiceClientConfiguration;
import software.amazon.awssdk.services.redshift.internal.RedshiftServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse;
import software.amazon.awssdk.services.redshift.model.AccessToClusterDeniedException;
import software.amazon.awssdk.services.redshift.model.AccessToSnapshotDeniedException;
import software.amazon.awssdk.services.redshift.model.AddPartnerRequest;
import software.amazon.awssdk.services.redshift.model.AddPartnerResponse;
import software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest;
import software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerResponse;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteRequestSizeExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsLimitExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BucketNotFoundException;
import software.amazon.awssdk.services.redshift.model.CancelResizeRequest;
import software.amazon.awssdk.services.redshift.model.CancelResizeResponse;
import software.amazon.awssdk.services.redshift.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterOnLatestRevisionException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ConflictPolicyUpdateException;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CopyToRegionDisabledException;
import software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.redshift.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.redshift.model.CreateRedshiftIdcApplicationRequest;
import software.amazon.awssdk.services.redshift.model.CreateRedshiftIdcApplicationResponse;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.CreateTagsResponse;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.CustomCnameAssociationException;
import software.amazon.awssdk.services.redshift.model.CustomDomainAssociationNotFoundException;
import software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest;
import software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareResponse;
import software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.redshift.model.DeletePartnerRequest;
import software.amazon.awssdk.services.redshift.model.DeletePartnerResponse;
import software.amazon.awssdk.services.redshift.model.DeleteRedshiftIdcApplicationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteRedshiftIdcApplicationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshift.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;
import software.amazon.awssdk.services.redshift.model.DeleteTagsResponse;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.DependentServiceAccessDeniedException;
import software.amazon.awssdk.services.redshift.model.DependentServiceRequestThrottlingException;
import software.amazon.awssdk.services.redshift.model.DependentServiceUnavailableException;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribePartnersRequest;
import software.amazon.awssdk.services.redshift.model.DescribePartnersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;
import software.amazon.awssdk.services.redshift.model.DescribeResizeResponse;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeStorageRequest;
import software.amazon.awssdk.services.redshift.model.DescribeStorageResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTagsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.DisableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerResponse;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.EnableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationsPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.EndpointNotFoundException;
import software.amazon.awssdk.services.redshift.model.EndpointsPerAuthorizationLimitExceededException;
import software.amazon.awssdk.services.redshift.model.EndpointsPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeRequest;
import software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.InProgressTableRestoreQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IncompatibleOrderableOptionsException;
import software.amazon.awssdk.services.redshift.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.redshift.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.redshift.model.IntegrationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.IntegrationConflictOperationException;
import software.amazon.awssdk.services.redshift.model.IntegrationConflictStateException;
import software.amazon.awssdk.services.redshift.model.IntegrationNotFoundException;
import software.amazon.awssdk.services.redshift.model.IntegrationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IntegrationSourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.IntegrationTargetNotFoundException;
import software.amazon.awssdk.services.redshift.model.InvalidAuthenticationProfileRequestException;
import software.amazon.awssdk.services.redshift.model.InvalidAuthorizationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterParameterGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSecurityGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotScheduleStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterTrackException;
import software.amazon.awssdk.services.redshift.model.InvalidDataShareException;
import software.amazon.awssdk.services.redshift.model.InvalidElasticIpException;
import software.amazon.awssdk.services.redshift.model.InvalidEndpointStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmClientCertificateStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmConfigurationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidNamespaceException;
import software.amazon.awssdk.services.redshift.model.InvalidPolicyException;
import software.amazon.awssdk.services.redshift.model.InvalidReservedNodeStateException;
import software.amazon.awssdk.services.redshift.model.InvalidRestoreException;
import software.amazon.awssdk.services.redshift.model.InvalidRetentionPeriodException;
import software.amazon.awssdk.services.redshift.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.redshift.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduleException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduledActionException;
import software.amazon.awssdk.services.redshift.model.InvalidSnapshotCopyGrantStateException;
import software.amazon.awssdk.services.redshift.model.InvalidSubnetException;
import software.amazon.awssdk.services.redshift.model.InvalidSubscriptionStateException;
import software.amazon.awssdk.services.redshift.model.InvalidTableRestoreArgumentException;
import software.amazon.awssdk.services.redshift.model.InvalidTagException;
import software.amazon.awssdk.services.redshift.model.InvalidUsageLimitException;
import software.amazon.awssdk.services.redshift.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.redshift.model.Ipv6CidrBlockNotFoundException;
import software.amazon.awssdk.services.redshift.model.LimitExceededException;
import software.amazon.awssdk.services.redshift.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.redshift.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyIntegrationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyIntegrationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyRedshiftIdcApplicationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyRedshiftIdcApplicationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.PartnerNotFoundException;
import software.amazon.awssdk.services.redshift.model.PauseClusterRequest;
import software.amazon.awssdk.services.redshift.model.PauseClusterResponse;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse;
import software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.services.redshift.model.RebootClusterResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftException;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationNotExistsException;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.RejectDataShareRequest;
import software.amazon.awssdk.services.redshift.model.RejectDataShareResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyMigratedException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResizeClusterResponse;
import software.amazon.awssdk.services.redshift.model.ResizeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ResumeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResumeClusterResponse;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionNotFoundException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyEnabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleUpdateInProgressException;
import software.amazon.awssdk.services.redshift.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.redshift.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.redshift.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.redshift.model.SourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.redshift.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.redshift.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionEventIdNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionSeverityNotFoundException;
import software.amazon.awssdk.services.redshift.model.TableLimitExceededException;
import software.amazon.awssdk.services.redshift.model.TableRestoreNotFoundException;
import software.amazon.awssdk.services.redshift.model.TagLimitExceededException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedPartnerIntegrationException;
import software.amazon.awssdk.services.redshift.model.UnknownSnapshotCopyRegionException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOperationException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOptionException;
import software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest;
import software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse;
import software.amazon.awssdk.services.redshift.model.UsageLimitAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.UsageLimitNotFoundException;
import software.amazon.awssdk.services.redshift.transform.AcceptReservedNodeExchangeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AddPartnerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AssociateDataShareConsumerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeDataShareRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchDeleteClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchModifyClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CancelResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CopyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateRedshiftIdcApplicationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeauthorizeDataShareRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeletePartnerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteRedshiftIdcApplicationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeAuthenticationProfilesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterDbRevisionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterTracksRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterVersionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeCustomDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDataSharesForConsumerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDataSharesForProducerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDataSharesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEndpointAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeInboundIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeLoggingStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeNodeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeOrderableClusterOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribePartnersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeRedshiftIdcApplicationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodeExchangeStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotCopyGrantsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotSchedulesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeStorageRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeUsageLimitsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisassociateDataShareConsumerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.FailoverPrimaryComputeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetClusterCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetClusterCredentialsWithIamRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetReservedNodeExchangeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetReservedNodeExchangeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyAquaConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterDbRevisionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterIamRolesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyIntegrationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyRedshiftIdcApplicationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotCopyRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PauseClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PurchaseReservedNodeOfferingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RebootClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RejectDataShareRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResetClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResizeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreTableFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResumeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RotateEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.UpdatePartnerStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.waiters.RedshiftAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultRedshiftAsyncClient
implements RedshiftAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedshiftAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.QUERY).build();
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultRedshiftAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AcceptReservedNodeExchangeResponse> acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptReservedNodeExchangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, acceptReservedNodeExchangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptReservedNodeExchange");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AcceptReservedNodeExchangeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptReservedNodeExchange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AcceptReservedNodeExchangeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)acceptReservedNodeExchangeRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$acceptReservedNodeExchange$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$acceptReservedNodeExchange$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddPartnerResponse> addPartner(AddPartnerRequest addPartnerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addPartnerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, addPartnerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddPartner");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddPartnerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddPartner").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddPartnerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addPartnerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$addPartner$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$addPartner$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateDataShareConsumerResponse> associateDataShareConsumer(AssociateDataShareConsumerRequest associateDataShareConsumerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateDataShareConsumerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, associateDataShareConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateDataShareConsumer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssociateDataShareConsumerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDataShareConsumer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateDataShareConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateDataShareConsumerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$associateDataShareConsumer$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$associateDataShareConsumer$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)authorizeClusterSecurityGroupIngressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, authorizeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeClusterSecurityGroupIngress");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeClusterSecurityGroupIngressResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeClusterSecurityGroupIngress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AuthorizeClusterSecurityGroupIngressRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)authorizeClusterSecurityGroupIngressRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$authorizeClusterSecurityGroupIngress$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$authorizeClusterSecurityGroupIngress$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeDataShareResponse> authorizeDataShare(AuthorizeDataShareRequest authorizeDataShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)authorizeDataShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, authorizeDataShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeDataShare");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeDataShareResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeDataShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AuthorizeDataShareRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)authorizeDataShareRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$authorizeDataShare$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$authorizeDataShare$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeEndpointAccessResponse> authorizeEndpointAccess(AuthorizeEndpointAccessRequest authorizeEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)authorizeEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, authorizeEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeEndpointAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeEndpointAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AuthorizeEndpointAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)authorizeEndpointAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$authorizeEndpointAccess$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$authorizeEndpointAccess$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeSnapshotAccessResponse> authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)authorizeSnapshotAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, authorizeSnapshotAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeSnapshotAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeSnapshotAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeSnapshotAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AuthorizeSnapshotAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)authorizeSnapshotAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$authorizeSnapshotAccess$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$authorizeSnapshotAccess$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteClusterSnapshotsResponse> batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest batchDeleteClusterSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteClusterSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, batchDeleteClusterSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteClusterSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDeleteClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteClusterSnapshotsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$batchDeleteClusterSnapshots$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$batchDeleteClusterSnapshots$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchModifyClusterSnapshotsResponse> batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest batchModifyClusterSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchModifyClusterSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, batchModifyClusterSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchModifyClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchModifyClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchModifyClusterSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchModifyClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchModifyClusterSnapshotsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$batchModifyClusterSnapshots$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$batchModifyClusterSnapshots$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelResizeResponse> cancelResize(CancelResizeRequest cancelResizeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelResizeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, cancelResizeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelResize");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CancelResizeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelResize").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelResizeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelResizeRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$cancelResize$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$cancelResize$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(CopyClusterSnapshotRequest copyClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copyClusterSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, copyClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyClusterSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CopyClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copyClusterSnapshotRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$copyClusterSnapshot$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$copyClusterSnapshot$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAuthenticationProfileResponse> createAuthenticationProfile(CreateAuthenticationProfileRequest createAuthenticationProfileRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAuthenticationProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createAuthenticationProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAuthenticationProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAuthenticationProfileResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAuthenticationProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAuthenticationProfileRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAuthenticationProfileRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createAuthenticationProfile$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createAuthenticationProfile$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createCluster$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createCluster$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterParameterGroupResponse> createClusterParameterGroup(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterParameterGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createClusterParameterGroup$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createClusterParameterGroup$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterSecurityGroupResponse> createClusterSecurityGroup(CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSecurityGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSecurityGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterSecurityGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createClusterSecurityGroup$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createClusterSecurityGroup$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterSnapshotRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createClusterSnapshot$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createClusterSnapshot$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterSubnetGroupResponse> createClusterSubnetGroup(CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterSubnetGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createClusterSubnetGroup$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createClusterSubnetGroup$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(CreateCustomDomainAssociationRequest createCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomDomainAssociation");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCustomDomainAssociationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomDomainAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomDomainAssociationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomDomainAssociationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createCustomDomainAssociation$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createCustomDomainAssociation$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(CreateEndpointAccessRequest createEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpointAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEndpointAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEndpointAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEndpointAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createEndpointAccess$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createEndpointAccess$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEventSubscriptionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createEventSubscription$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createEventSubscription$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHsmClientCertificateResponse> createHsmClientCertificate(CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHsmClientCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createHsmClientCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHsmClientCertificate");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHsmClientCertificateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsmClientCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateHsmClientCertificateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createHsmClientCertificateRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createHsmClientCertificate$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createHsmClientCertificate$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHsmConfigurationResponse> createHsmConfiguration(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHsmConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createHsmConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHsmConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHsmConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsmConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateHsmConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createHsmConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createHsmConfiguration$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createHsmConfiguration$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateIntegrationResponse> createIntegration(CreateIntegrationRequest createIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIntegration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateIntegrationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateIntegrationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createIntegrationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createIntegration$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createIntegration$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRedshiftIdcApplicationResponse> createRedshiftIdcApplication(CreateRedshiftIdcApplicationRequest createRedshiftIdcApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRedshiftIdcApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createRedshiftIdcApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRedshiftIdcApplication");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateRedshiftIdcApplicationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRedshiftIdcApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRedshiftIdcApplicationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRedshiftIdcApplicationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createRedshiftIdcApplication$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createRedshiftIdcApplication$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateScheduledActionResponse> createScheduledAction(CreateScheduledActionRequest createScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScheduledAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createScheduledActionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createScheduledAction$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createScheduledAction$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotCopyGrantResponse> createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotCopyGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotCopyGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshotCopyGrant");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotCopyGrantResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotCopyGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotCopyGrantRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotCopyGrantRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createSnapshotCopyGrant$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createSnapshotCopyGrant$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotScheduleResponse> createSnapshotSchedule(CreateSnapshotScheduleRequest createSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotScheduleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createSnapshotSchedule$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createSnapshotSchedule$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTagsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createTags$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createTags$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUsageLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, createUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUsageLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateUsageLimitResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUsageLimit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUsageLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUsageLimitRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$createUsageLimit$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$createUsageLimit$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeauthorizeDataShareResponse> deauthorizeDataShare(DeauthorizeDataShareRequest deauthorizeDataShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deauthorizeDataShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deauthorizeDataShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeauthorizeDataShare");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeauthorizeDataShareResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeauthorizeDataShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeauthorizeDataShareRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deauthorizeDataShareRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deauthorizeDataShare$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deauthorizeDataShare$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAuthenticationProfileResponse> deleteAuthenticationProfile(DeleteAuthenticationProfileRequest deleteAuthenticationProfileRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAuthenticationProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAuthenticationProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAuthenticationProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAuthenticationProfileResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAuthenticationProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAuthenticationProfileRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAuthenticationProfileRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteAuthenticationProfile$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteAuthenticationProfile$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteCluster$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteCluster$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterParameterGroupResponse> deleteClusterParameterGroup(DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterParameterGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteClusterParameterGroup$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteClusterParameterGroup$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterSecurityGroupResponse> deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSecurityGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSecurityGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterSecurityGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteClusterSecurityGroup$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteClusterSecurityGroup$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterSnapshotRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteClusterSnapshot$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteClusterSnapshot$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterSubnetGroupResponse> deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterSubnetGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteClusterSubnetGroup$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteClusterSubnetGroup$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(DeleteCustomDomainAssociationRequest deleteCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomDomainAssociation");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCustomDomainAssociationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomDomainAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomDomainAssociationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomDomainAssociationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteCustomDomainAssociation$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteCustomDomainAssociation$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(DeleteEndpointAccessRequest deleteEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpointAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEndpointAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEndpointAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEndpointAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteEndpointAccess$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteEndpointAccess$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEventSubscriptionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteEventSubscription$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteEventSubscription$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHsmClientCertificateResponse> deleteHsmClientCertificate(DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteHsmClientCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteHsmClientCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHsmClientCertificate");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHsmClientCertificateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsmClientCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteHsmClientCertificateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteHsmClientCertificateRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteHsmClientCertificate$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteHsmClientCertificate$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHsmConfigurationResponse> deleteHsmConfiguration(DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteHsmConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteHsmConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHsmConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHsmConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsmConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteHsmConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteHsmConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteHsmConfiguration$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteHsmConfiguration$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIntegration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIntegrationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIntegrationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIntegrationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteIntegration$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteIntegration$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePartnerResponse> deletePartner(DeletePartnerRequest deletePartnerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePartnerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deletePartnerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePartner");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePartnerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePartner").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePartnerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePartnerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deletePartner$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deletePartner$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRedshiftIdcApplicationResponse> deleteRedshiftIdcApplication(DeleteRedshiftIdcApplicationRequest deleteRedshiftIdcApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRedshiftIdcApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRedshiftIdcApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRedshiftIdcApplication");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteRedshiftIdcApplicationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRedshiftIdcApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRedshiftIdcApplicationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRedshiftIdcApplicationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteRedshiftIdcApplication$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteRedshiftIdcApplication$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteResourcePolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteResourcePolicy$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteResourcePolicy$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteScheduledActionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteScheduledAction$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteScheduledAction$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotCopyGrantResponse> deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotCopyGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotCopyGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshotCopyGrant");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotCopyGrantResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotCopyGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSnapshotCopyGrantRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotCopyGrantRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteSnapshotCopyGrant$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteSnapshotCopyGrant$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotScheduleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteSnapshotSchedule$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteSnapshotSchedule$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTagsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteTags$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteTags$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUsageLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, deleteUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUsageLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteUsageLimitResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUsageLimit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteUsageLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteUsageLimitRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$deleteUsageLimit$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$deleteUsageLimit$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountAttributes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAccountAttributesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeAccountAttributes$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeAccountAttributes$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAuthenticationProfilesResponse> describeAuthenticationProfiles(DescribeAuthenticationProfilesRequest describeAuthenticationProfilesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAuthenticationProfilesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeAuthenticationProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAuthenticationProfiles");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAuthenticationProfilesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAuthenticationProfiles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAuthenticationProfilesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAuthenticationProfilesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeAuthenticationProfiles$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeAuthenticationProfiles$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterDbRevisionsResponse> describeClusterDbRevisions(DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterDbRevisionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterDbRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterDbRevisions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterDbRevisionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterDbRevisions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterDbRevisionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterDbRevisionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterDbRevisions$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterDbRevisions$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterParameterGroupsResponse> describeClusterParameterGroups(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterParameterGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterParameterGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterParameterGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterParameterGroupsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterParameterGroups$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterParameterGroups$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterParametersResponse> describeClusterParameters(DescribeClusterParametersRequest describeClusterParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterParametersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterParameters$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterParameters$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterSecurityGroupsResponse> describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterSecurityGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterSecurityGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSecurityGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSecurityGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterSecurityGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterSecurityGroupsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterSecurityGroups$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterSecurityGroups$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterSnapshotsResponse> describeClusterSnapshots(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterSnapshotsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterSnapshots$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterSnapshots$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterSubnetGroupsResponse> describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterSubnetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterSubnetGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSubnetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSubnetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterSubnetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterSubnetGroupsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterSubnetGroups$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterSubnetGroups$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterTracksResponse> describeClusterTracks(DescribeClusterTracksRequest describeClusterTracksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterTracksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterTracksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterTracks");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterTracksResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterTracks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterTracksRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterTracksRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterTracks$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterTracks$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterVersionsResponse> describeClusterVersions(DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterVersions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterVersionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusterVersions$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusterVersions$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClustersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClustersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeClusters$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeClusters$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomDomainAssociationsResponse> describeCustomDomainAssociations(DescribeCustomDomainAssociationsRequest describeCustomDomainAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomDomainAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomDomainAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomDomainAssociations");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCustomDomainAssociationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomDomainAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomDomainAssociationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomDomainAssociationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeCustomDomainAssociations$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeCustomDomainAssociations$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataSharesResponse> describeDataShares(DescribeDataSharesRequest describeDataSharesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataShares");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDataSharesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataShares").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataSharesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataSharesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeDataShares$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeDataShares$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataSharesForConsumerResponse> describeDataSharesForConsumer(DescribeDataSharesForConsumerRequest describeDataSharesForConsumerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataSharesForConsumerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataSharesForConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataSharesForConsumer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDataSharesForConsumerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataSharesForConsumer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataSharesForConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataSharesForConsumerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeDataSharesForConsumer$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeDataSharesForConsumer$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataSharesForProducerResponse> describeDataSharesForProducer(DescribeDataSharesForProducerRequest describeDataSharesForProducerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataSharesForProducerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataSharesForProducerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataSharesForProducer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDataSharesForProducerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataSharesForProducer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataSharesForProducerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataSharesForProducerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeDataSharesForProducer$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeDataSharesForProducer$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDefaultClusterParametersResponse> describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDefaultClusterParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDefaultClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDefaultClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDefaultClusterParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDefaultClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDefaultClusterParametersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeDefaultClusterParameters$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeDefaultClusterParameters$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointAccessResponse> describeEndpointAccess(DescribeEndpointAccessRequest describeEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEndpointAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeEndpointAccess$199(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeEndpointAccess$200((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointAuthorizationResponse> describeEndpointAuthorization(DescribeEndpointAuthorizationRequest describeEndpointAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointAuthorizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointAuthorization");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEndpointAuthorizationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointAuthorization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointAuthorizationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointAuthorizationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeEndpointAuthorization$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeEndpointAuthorization$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventCategoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventCategoriesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeEventCategories$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeEventCategories$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSubscriptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventSubscriptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventSubscriptionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeEventSubscriptions$208(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeEventSubscriptions$209((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeEvents$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeEvents$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeHsmClientCertificatesResponse> describeHsmClientCertificates(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeHsmClientCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeHsmClientCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHsmClientCertificates");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeHsmClientCertificatesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsmClientCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeHsmClientCertificatesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeHsmClientCertificatesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeHsmClientCertificates$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeHsmClientCertificates$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeHsmConfigurationsResponse> describeHsmConfigurations(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeHsmConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeHsmConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHsmConfigurations");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeHsmConfigurationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsmConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeHsmConfigurationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeHsmConfigurationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeHsmConfigurations$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeHsmConfigurations$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeInboundIntegrationsResponse> describeInboundIntegrations(DescribeInboundIntegrationsRequest describeInboundIntegrationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInboundIntegrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeInboundIntegrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInboundIntegrations");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInboundIntegrationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInboundIntegrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeInboundIntegrationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeInboundIntegrationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeInboundIntegrations$220(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeInboundIntegrations$221((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIntegrationsResponse> describeIntegrations(DescribeIntegrationsRequest describeIntegrationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIntegrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeIntegrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIntegrations");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeIntegrationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIntegrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeIntegrationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeIntegrationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeIntegrations$223(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeIntegrations$224((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoggingStatusResponse> describeLoggingStatus(DescribeLoggingStatusRequest describeLoggingStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoggingStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeLoggingStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoggingStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoggingStatusResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLoggingStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLoggingStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeLoggingStatus$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeLoggingStatus$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNodeConfigurationOptionsResponse> describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNodeConfigurationOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeNodeConfigurationOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNodeConfigurationOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNodeConfigurationOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodeConfigurationOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeNodeConfigurationOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeNodeConfigurationOptionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeNodeConfigurationOptions$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeNodeConfigurationOptions$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrderableClusterOptionsResponse> describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrderableClusterOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeOrderableClusterOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableClusterOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableClusterOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableClusterOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeOrderableClusterOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeOrderableClusterOptionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeOrderableClusterOptions$232(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeOrderableClusterOptions$233((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribePartnersResponse> describePartners(DescribePartnersRequest describePartnersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePartnersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describePartnersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePartners");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePartnersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePartners").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribePartnersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describePartnersRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describePartners$235(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describePartners$236((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRedshiftIdcApplicationsResponse> describeRedshiftIdcApplications(DescribeRedshiftIdcApplicationsRequest describeRedshiftIdcApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRedshiftIdcApplicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeRedshiftIdcApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRedshiftIdcApplications");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeRedshiftIdcApplicationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRedshiftIdcApplications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRedshiftIdcApplicationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRedshiftIdcApplicationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeRedshiftIdcApplications$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeRedshiftIdcApplications$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservedNodeExchangeStatusResponse> describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusRequest describeReservedNodeExchangeStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodeExchangeStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeReservedNodeExchangeStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodeExchangeStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodeExchangeStatusResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodeExchangeStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReservedNodeExchangeStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReservedNodeExchangeStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeReservedNodeExchangeStatus$241(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeReservedNodeExchangeStatus$242((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservedNodeOfferingsResponse> describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodeOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeReservedNodeOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodeOfferings");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodeOfferingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodeOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReservedNodeOfferingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReservedNodeOfferingsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeReservedNodeOfferings$244(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeReservedNodeOfferings$245((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeReservedNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReservedNodesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReservedNodesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeReservedNodes$247(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeReservedNodes$248((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResizeResponse> describeResize(DescribeResizeRequest describeResizeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResizeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeResizeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResize");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeResizeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResize").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResizeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResizeRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeResize$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeResize$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScheduledActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeScheduledActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledActions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScheduledActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeScheduledActionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeScheduledActions$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeScheduledActions$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotCopyGrantsResponse> describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotCopyGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeSnapshotCopyGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshotCopyGrants");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotCopyGrantsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotCopyGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSnapshotCopyGrantsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSnapshotCopyGrantsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeSnapshotCopyGrants$256(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeSnapshotCopyGrants$257((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotSchedulesResponse> describeSnapshotSchedules(DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotSchedulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeSnapshotSchedulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshotSchedules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotSchedulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotSchedules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSnapshotSchedulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSnapshotSchedulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeSnapshotSchedules$259(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeSnapshotSchedules$260((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStorageResponse> describeStorage(DescribeStorageRequest describeStorageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStorage");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStorageResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStorageRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStorageRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeStorage$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeStorage$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableRestoreStatusResponse> describeTableRestoreStatus(DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableRestoreStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeTableRestoreStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableRestoreStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTableRestoreStatusResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableRestoreStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTableRestoreStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTableRestoreStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeTableRestoreStatus$265(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeTableRestoreStatus$266((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTagsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeTags$268(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeTags$269((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUsageLimitsResponse> describeUsageLimits(DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUsageLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, describeUsageLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUsageLimits");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeUsageLimitsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUsageLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeUsageLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeUsageLimitsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$describeUsageLimits$271(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$describeUsageLimits$272((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableLoggingResponse> disableLogging(DisableLoggingRequest disableLoggingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, disableLoggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableLogging");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableLoggingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLogging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableLoggingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableLoggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$disableLogging$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$disableLogging$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableSnapshotCopyResponse> disableSnapshotCopy(DisableSnapshotCopyRequest disableSnapshotCopyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableSnapshotCopyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, disableSnapshotCopyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableSnapshotCopy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableSnapshotCopyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSnapshotCopy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableSnapshotCopyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableSnapshotCopyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$disableSnapshotCopy$277(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$disableSnapshotCopy$278((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateDataShareConsumerResponse> disassociateDataShareConsumer(DisassociateDataShareConsumerRequest disassociateDataShareConsumerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateDataShareConsumerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateDataShareConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateDataShareConsumer");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisassociateDataShareConsumerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDataShareConsumer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateDataShareConsumerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateDataShareConsumerRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$disassociateDataShareConsumer$280(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$disassociateDataShareConsumer$281((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableLoggingResponse> enableLogging(EnableLoggingRequest enableLoggingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, enableLoggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableLogging");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableLoggingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLogging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableLoggingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableLoggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$enableLogging$283(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$enableLogging$284((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableSnapshotCopyResponse> enableSnapshotCopy(EnableSnapshotCopyRequest enableSnapshotCopyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableSnapshotCopyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, enableSnapshotCopyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSnapshotCopy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableSnapshotCopyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSnapshotCopy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableSnapshotCopyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableSnapshotCopyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$enableSnapshotCopy$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$enableSnapshotCopy$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<FailoverPrimaryComputeResponse> failoverPrimaryCompute(FailoverPrimaryComputeRequest failoverPrimaryComputeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)failoverPrimaryComputeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, failoverPrimaryComputeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverPrimaryCompute");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverPrimaryComputeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverPrimaryCompute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new FailoverPrimaryComputeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)failoverPrimaryComputeRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$failoverPrimaryCompute$289(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$failoverPrimaryCompute$290((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetClusterCredentialsResponse> getClusterCredentials(GetClusterCredentialsRequest getClusterCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getClusterCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, getClusterCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClusterCredentials");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetClusterCredentialsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClusterCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetClusterCredentialsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getClusterCredentialsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$getClusterCredentials$292(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$getClusterCredentials$293((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetClusterCredentialsWithIamResponse> getClusterCredentialsWithIAM(GetClusterCredentialsWithIamRequest getClusterCredentialsWithIamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getClusterCredentialsWithIamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, getClusterCredentialsWithIamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClusterCredentialsWithIAM");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetClusterCredentialsWithIamResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClusterCredentialsWithIAM").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetClusterCredentialsWithIamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getClusterCredentialsWithIamRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$getClusterCredentialsWithIAM$295(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$getClusterCredentialsWithIAM$296((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> getReservedNodeExchangeConfigurationOptions(GetReservedNodeExchangeConfigurationOptionsRequest getReservedNodeExchangeConfigurationOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservedNodeExchangeConfigurationOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, getReservedNodeExchangeConfigurationOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservedNodeExchangeConfigurationOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetReservedNodeExchangeConfigurationOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservedNodeExchangeConfigurationOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReservedNodeExchangeConfigurationOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReservedNodeExchangeConfigurationOptionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$getReservedNodeExchangeConfigurationOptions$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$getReservedNodeExchangeConfigurationOptions$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservedNodeExchangeOfferingsResponse> getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservedNodeExchangeOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, getReservedNodeExchangeOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservedNodeExchangeOfferings");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetReservedNodeExchangeOfferingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservedNodeExchangeOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReservedNodeExchangeOfferingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReservedNodeExchangeOfferingsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$getReservedNodeExchangeOfferings$301(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$getReservedNodeExchangeOfferings$302((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetResourcePolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$getResourcePolicy$304(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$getResourcePolicy$305((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRecommendationsResponse> listRecommendations(ListRecommendationsRequest listRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRecommendationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, listRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendations");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListRecommendationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRecommendationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRecommendationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$listRecommendations$307(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$listRecommendations$308((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyAquaConfigurationResponse> modifyAquaConfiguration(ModifyAquaConfigurationRequest modifyAquaConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyAquaConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyAquaConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyAquaConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyAquaConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyAquaConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyAquaConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyAquaConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyAquaConfiguration$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyAquaConfiguration$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyAuthenticationProfileResponse> modifyAuthenticationProfile(ModifyAuthenticationProfileRequest modifyAuthenticationProfileRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyAuthenticationProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyAuthenticationProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyAuthenticationProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyAuthenticationProfileResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyAuthenticationProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyAuthenticationProfileRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyAuthenticationProfileRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyAuthenticationProfile$313(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyAuthenticationProfile$314((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterResponse> modifyCluster(ModifyClusterRequest modifyClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyCluster$316(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyCluster$317((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterDbRevisionResponse> modifyClusterDbRevision(ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterDbRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterDbRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterDbRevision");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterDbRevisionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterDbRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterDbRevisionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterDbRevisionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterDbRevision$319(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterDbRevision$320((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterIamRolesResponse> modifyClusterIamRoles(ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterIamRolesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterIamRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterIamRoles");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterIamRolesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterIamRoles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterIamRolesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterIamRolesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterIamRoles$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterIamRoles$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterMaintenanceResponse> modifyClusterMaintenance(ModifyClusterMaintenanceRequest modifyClusterMaintenanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterMaintenanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterMaintenanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterMaintenance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterMaintenanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterMaintenance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterMaintenanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterMaintenanceRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterMaintenance$325(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterMaintenance$326((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterParameterGroupResponse> modifyClusterParameterGroup(ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterParameterGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterParameterGroup$328(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterParameterGroup$329((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterSnapshotResponse> modifyClusterSnapshot(ModifyClusterSnapshotRequest modifyClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterSnapshotRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterSnapshot$331(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterSnapshot$332((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterSnapshotScheduleResponse> modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest modifyClusterSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterSnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterSnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterSnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterSnapshotScheduleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterSnapshotSchedule$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterSnapshotSchedule$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterSubnetGroupResponse> modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterSubnetGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyClusterSubnetGroup$337(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyClusterSubnetGroup$338((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyCustomDomainAssociationResponse> modifyCustomDomainAssociation(ModifyCustomDomainAssociationRequest modifyCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyCustomDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyCustomDomainAssociation");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCustomDomainAssociationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCustomDomainAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyCustomDomainAssociationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyCustomDomainAssociationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyCustomDomainAssociation$340(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyCustomDomainAssociation$341((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyEndpointAccessResponse> modifyEndpointAccess(ModifyEndpointAccessRequest modifyEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEndpointAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEndpointAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyEndpointAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyEndpointAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyEndpointAccess$343(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyEndpointAccess$344((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyEventSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyEventSubscriptionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyEventSubscription$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyEventSubscription$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyIntegrationResponse> modifyIntegration(ModifyIntegrationRequest modifyIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyIntegrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyIntegration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyIntegrationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyIntegration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyIntegrationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyIntegrationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyIntegration$349(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyIntegration$350((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyRedshiftIdcApplicationResponse> modifyRedshiftIdcApplication(ModifyRedshiftIdcApplicationRequest modifyRedshiftIdcApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyRedshiftIdcApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyRedshiftIdcApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyRedshiftIdcApplication");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyRedshiftIdcApplicationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyRedshiftIdcApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyRedshiftIdcApplicationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyRedshiftIdcApplicationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyRedshiftIdcApplication$352(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyRedshiftIdcApplication$353((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyScheduledActionResponse> modifyScheduledAction(ModifyScheduledActionRequest modifyScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyScheduledAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyScheduledActionRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyScheduledAction$355(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyScheduledAction$356((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifySnapshotCopyRetentionPeriodResponse> modifySnapshotCopyRetentionPeriod(ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifySnapshotCopyRetentionPeriodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifySnapshotCopyRetentionPeriodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifySnapshotCopyRetentionPeriod");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifySnapshotCopyRetentionPeriodResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySnapshotCopyRetentionPeriod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifySnapshotCopyRetentionPeriodRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifySnapshotCopyRetentionPeriodRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifySnapshotCopyRetentionPeriod$358(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifySnapshotCopyRetentionPeriod$359((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifySnapshotScheduleResponse> modifySnapshotSchedule(ModifySnapshotScheduleRequest modifySnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifySnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifySnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifySnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifySnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifySnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifySnapshotScheduleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifySnapshotSchedule$361(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifySnapshotSchedule$362((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyUsageLimitResponse> modifyUsageLimit(ModifyUsageLimitRequest modifyUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyUsageLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, modifyUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyUsageLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyUsageLimitResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyUsageLimit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyUsageLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyUsageLimitRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$modifyUsageLimit$364(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$modifyUsageLimit$365((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PauseClusterResponse> pauseCluster(PauseClusterRequest pauseClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pauseClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, pauseClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PauseCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PauseClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PauseCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PauseClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)pauseClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$pauseCluster$367(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$pauseCluster$368((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PurchaseReservedNodeOfferingResponse> purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseReservedNodeOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, purchaseReservedNodeOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseReservedNodeOffering");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PurchaseReservedNodeOfferingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedNodeOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PurchaseReservedNodeOfferingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)purchaseReservedNodeOfferingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$purchaseReservedNodeOffering$370(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$purchaseReservedNodeOffering$371((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutResourcePolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$putResourcePolicy$373(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$putResourcePolicy$374((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootClusterResponse> rebootCluster(RebootClusterRequest rebootClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, rebootClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RebootClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rebootClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$rebootCluster$376(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$rebootCluster$377((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RejectDataShareResponse> rejectDataShare(RejectDataShareRequest rejectDataShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectDataShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, rejectDataShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectDataShare");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RejectDataShareResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectDataShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RejectDataShareRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rejectDataShareRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$rejectDataShare$379(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$rejectDataShare$380((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetClusterParameterGroupResponse> resetClusterParameterGroup(ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetClusterParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, resetClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetClusterParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResetClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetClusterParameterGroupRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$resetClusterParameterGroup$382(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$resetClusterParameterGroup$383((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResizeClusterResponse> resizeCluster(ResizeClusterRequest resizeClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resizeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, resizeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResizeCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResizeClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResizeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResizeClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resizeClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$resizeCluster$385(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$resizeCluster$386((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreFromClusterSnapshotResponse> restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreFromClusterSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, restoreFromClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreFromClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreFromClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromClusterSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreFromClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restoreFromClusterSnapshotRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$restoreFromClusterSnapshot$388(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$restoreFromClusterSnapshot$389((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreTableFromClusterSnapshotResponse> restoreTableFromClusterSnapshot(RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreTableFromClusterSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, restoreTableFromClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreTableFromClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromClusterSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreTableFromClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restoreTableFromClusterSnapshotRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$restoreTableFromClusterSnapshot$391(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$restoreTableFromClusterSnapshot$392((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResumeClusterResponse> resumeCluster(ResumeClusterRequest resumeClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resumeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, resumeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResumeClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResumeClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resumeClusterRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$resumeCluster$394(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$resumeCluster$395((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeClusterSecurityGroupIngressResponse> revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeClusterSecurityGroupIngressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, revokeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeClusterSecurityGroupIngress");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeClusterSecurityGroupIngressResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeClusterSecurityGroupIngress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeClusterSecurityGroupIngressRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeClusterSecurityGroupIngressRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$revokeClusterSecurityGroupIngress$397(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$revokeClusterSecurityGroupIngress$398((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeEndpointAccessResponse> revokeEndpointAccess(RevokeEndpointAccessRequest revokeEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, revokeEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeEndpointAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeEndpointAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeEndpointAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeEndpointAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$revokeEndpointAccess$400(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$revokeEndpointAccess$401((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeSnapshotAccessResponse> revokeSnapshotAccess(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeSnapshotAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, revokeSnapshotAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeSnapshotAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeSnapshotAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeSnapshotAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeSnapshotAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeSnapshotAccessRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$revokeSnapshotAccess$403(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$revokeSnapshotAccess$404((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RotateEncryptionKeyResponse> rotateEncryptionKey(RotateEncryptionKeyRequest rotateEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rotateEncryptionKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, rotateEncryptionKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RotateEncryptionKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RotateEncryptionKeyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RotateEncryptionKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RotateEncryptionKeyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rotateEncryptionKeyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$rotateEncryptionKey$406(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$rotateEncryptionKey$407((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePartnerStatusResponse> updatePartnerStatus(UpdatePartnerStatusRequest updatePartnerStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePartnerStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(clientConfiguration, updatePartnerStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePartnerStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdatePartnerStatusResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePartnerStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePartnerStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePartnerStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultRedshiftAsyncClient.lambda$updatePartnerStatus$409(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftAsyncClient.lambda$updatePartnerStatus$410((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public RedshiftAsyncWaiter waiter() {
        return RedshiftAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final RedshiftServiceClientConfiguration serviceClientConfiguration() {
        return new RedshiftServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "redshift";
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHsmConfigurationStateFault").exceptionBuilderSupplier(InvalidHsmConfigurationStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleAlreadyExists").exceptionBuilderSupplier(SnapshotScheduleAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleQuotaExceeded").exceptionBuilderSupplier(SnapshotScheduleQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubscriptionStateFault").exceptionBuilderSupplier(InvalidSubscriptionStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedPartnerIntegration").exceptionBuilderSupplier(UnauthorizedPartnerIntegrationException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidUsageLimit").exceptionBuilderSupplier(InvalidUsageLimitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault").exceptionBuilderSupplier(IntegrationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestore").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(406)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyDisabledFault").exceptionBuilderSupplier(SnapshotCopyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeExchangeNotFond").exceptionBuilderSupplier(ReservedNodeExchangeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RedshiftIdcApplicationQuotaExceeded").exceptionBuilderSupplier(RedshiftIdcApplicationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupQuotaExceeded").exceptionBuilderSupplier(ClusterSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundFault").exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSchedule").exceptionBuilderSupplier(InvalidScheduleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceRequestThrottlingFault").exceptionBuilderSupplier(DependentServiceRequestThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RedshiftIdcApplicationNotExists").exceptionBuilderSupplier(RedshiftIdcApplicationNotExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketNotFoundFault").exceptionBuilderSupplier(BucketNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededFault").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointAlreadyExists").exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PartnerNotFound").exceptionBuilderSupplier(PartnerNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionQuotaExceeded").exceptionBuilderSupplier(ScheduledActionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTableRestoreArgument").exceptionBuilderSupplier(InvalidTableRestoreArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantAlreadyExistsFault").exceptionBuilderSupplier(SnapshotCopyGrantAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantQuotaExceededFault").exceptionBuilderSupplier(SnapshotCopyGrantQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterNotFound").exceptionBuilderSupplier(ClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterQuotaExceeded").exceptionBuilderSupplier(ClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault").exceptionBuilderSupplier(IntegrationConflictOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionAlreadyExists").exceptionBuilderSupplier(ScheduledActionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterState").exceptionBuilderSupplier(InvalidClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetQuotaExceededFault").exceptionBuilderSupplier(ClusterSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterParameterGroupState").exceptionBuilderSupplier(InvalidClusterParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupNotFoundFault").exceptionBuilderSupplier(ClusterSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyDisabledFault").exceptionBuilderSupplier(SnapshotCopyAlreadyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotQuotaExceeded").exceptionBuilderSupplier(ClusterSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceAccessDenied").exceptionBuilderSupplier(DependentServiceAccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointAuthorizationAlreadyExists").exceptionBuilderSupplier(EndpointAuthorizationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterAlreadyExists").exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictPolicyUpdateFault").exceptionBuilderSupplier(ConflictPolicyUpdateException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound").exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfNodesQuotaExceeded").exceptionBuilderSupplier(NumberOfNodesQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSecurityGroupAlreadyExists").exceptionBuilderSupplier(ClusterSecurityGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationQuotaExceeded").exceptionBuilderSupplier(AuthorizationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeOfferingNotFound").exceptionBuilderSupplier(ReservedNodeOfferingNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointNotFound").exceptionBuilderSupplier(EndpointNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InProgressTableRestoreQuotaExceededFault").exceptionBuilderSupplier(InProgressTableRestoreQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessToSnapshotDenied").exceptionBuilderSupplier(AccessToSnapshotDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidElasticIpFault").exceptionBuilderSupplier(InvalidElasticIpException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResizeNotFound").exceptionBuilderSupplier(ResizeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduleDefinitionTypeUnsupported").exceptionBuilderSupplier(ScheduleDefinitionTypeUnsupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagFault").exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateAlreadyExistsFault").exceptionBuilderSupplier(HsmClientCertificateAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionTypeUnsupported").exceptionBuilderSupplier(ScheduledActionTypeUnsupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupQuotaExceeded").exceptionBuilderSupplier(ClusterParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPolicyFault").exceptionBuilderSupplier(InvalidPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedOperation").exceptionBuilderSupplier(UnauthorizedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthenticationProfileNotFoundFault").exceptionBuilderSupplier(AuthenticationProfileNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleNotFound").exceptionBuilderSupplier(SnapshotScheduleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExists").exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameFault").exceptionBuilderSupplier(InvalidS3BucketNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOptionFault").exceptionBuilderSupplier(UnsupportedOptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacity").exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupAlreadyExists").exceptionBuilderSupplier(ClusterSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceededFault").exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotState").exceptionBuilderSupplier(InvalidClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyFault").exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchDeleteRequestSizeExceeded").exceptionBuilderSupplier(BatchDeleteRequestSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixFault").exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationSourceNotFoundFault").exceptionBuilderSupplier(IntegrationSourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionNotFound").exceptionBuilderSupplier(ScheduledActionNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionEventIdNotFound").exceptionBuilderSupplier(SubscriptionEventIdNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotScheduleState").exceptionBuilderSupplier(InvalidClusterSnapshotScheduleStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointAuthorizationNotFound").exceptionBuilderSupplier(EndpointAuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterTrack").exceptionBuilderSupplier(InvalidClusterTrackException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionSeverityNotFound").exceptionBuilderSupplier(SubscriptionSeverityNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNamespaceFault").exceptionBuilderSupplier(InvalidNamespaceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessToClusterDenied").exceptionBuilderSupplier(AccessToClusterDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CopyToRegionDisabledFault").exceptionBuilderSupplier(CopyToRegionDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound").exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault").exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointState").exceptionBuilderSupplier(InvalidEndpointStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownSnapshotCopyRegionFault").exceptionBuilderSupplier(UnknownSnapshotCopyRegionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableRestoreNotFoundFault").exceptionBuilderSupplier(TableRestoreNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationQuotaExceededFault").exceptionBuilderSupplier(HsmConfigurationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantNotFoundFault").exceptionBuilderSupplier(SnapshotCopyGrantNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyMigrated").exceptionBuilderSupplier(ReservedNodeAlreadyMigratedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateNotFoundFault").exceptionBuilderSupplier(HsmClientCertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyEnabledFault").exceptionBuilderSupplier(SnapshotCopyAlreadyEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationAlreadyExistsFault").exceptionBuilderSupplier(HsmConfigurationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomCnameAssociationFault").exceptionBuilderSupplier(CustomCnameAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionNotFound").exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationTargetNotFoundFault").exceptionBuilderSupplier(IntegrationTargetNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReservedNodeState").exceptionBuilderSupplier(InvalidReservedNodeStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomDomainAssociationNotFoundFault").exceptionBuilderSupplier(CustomDomainAssociationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceUnavailableFault").exceptionBuilderSupplier(DependentServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationConflictStateFault").exceptionBuilderSupplier(IntegrationConflictStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IntegrationAlreadyExistsFault").exceptionBuilderSupplier(IntegrationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorizationState").exceptionBuilderSupplier(InvalidAuthorizationStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSecurityGroupNotFound").exceptionBuilderSupplier(ClusterSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationNotFoundFault").exceptionBuilderSupplier(HsmConfigurationNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfNodesPerClusterLimitExceeded").exceptionBuilderSupplier(NumberOfNodesPerClusterLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthenticationProfileQuotaExceededFault").exceptionBuilderSupplier(AuthenticationProfileQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointAuthorizationsPerClusterLimitExceeded").exceptionBuilderSupplier(EndpointAuthorizationsPerClusterLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotAlreadyExists").exceptionBuilderSupplier(ClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRetentionPeriodFault").exceptionBuilderSupplier(InvalidRetentionPeriodException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthenticationProfileAlreadyExistsFault").exceptionBuilderSupplier(AuthenticationProfileAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointsPerAuthorizationLimitExceeded").exceptionBuilderSupplier(EndpointsPerAuthorizationLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UsageLimitNotFound").exceptionBuilderSupplier(UsageLimitNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableLimitExceeded").exceptionBuilderSupplier(TableLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleUpdateInProgress").exceptionBuilderSupplier(SnapshotScheduleUpdateInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnapshotCopyGrantStateFault").exceptionBuilderSupplier(InvalidSnapshotCopyGrantStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopic").exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHsmClientCertificateStateFault").exceptionBuilderSupplier(InvalidHsmClientCertificateStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSubnetGroupStateFault").exceptionBuilderSupplier(InvalidClusterSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterOnLatestRevision").exceptionBuilderSupplier(ClusterOnLatestRevisionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotNotFound").exceptionBuilderSupplier(ClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDataShareFault").exceptionBuilderSupplier(InvalidDataShareException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchModifyClusterSnapshotsLimitExceededFault").exceptionBuilderSupplier(BatchModifyClusterSnapshotsLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateQuotaExceededFault").exceptionBuilderSupplier(HsmClientCertificateQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSecurityGroupState").exceptionBuilderSupplier(InvalidClusterSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceeded").exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthenticationProfileRequestFault").exceptionBuilderSupplier(InvalidAuthenticationProfileRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorization").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSubnetStateFault").exceptionBuilderSupplier(InvalidClusterSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist").exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeNotFound").exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheduledAction").exceptionBuilderSupplier(InvalidScheduledActionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleOrderableOptions").exceptionBuilderSupplier(IncompatibleOrderableOptionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RedshiftIdcApplicationAlreadyExists").exceptionBuilderSupplier(RedshiftIdcApplicationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointsPerClusterLimitExceeded").exceptionBuilderSupplier(EndpointsPerClusterLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UsageLimitAlreadyExists").exceptionBuilderSupplier(UsageLimitAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceNotFound").exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupNotFound").exceptionBuilderSupplier(ClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceeded.ClusterSecurityGroup").exceptionBuilderSupplier(ClusterSecurityGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded").exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists").exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupAlreadyExists").exceptionBuilderSupplier(ClusterParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RedshiftException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        RedshiftServiceClientConfigurationBuilder serviceConfigBuilder = new RedshiftServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePartnerStatus$410(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePartnerStatus$409(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePartnerStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rotateEncryptionKey$407(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rotateEncryptionKey$406(List metricPublishers, MetricCollector apiCallMetricCollector, RotateEncryptionKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeSnapshotAccess$404(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeSnapshotAccess$403(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeSnapshotAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeEndpointAccess$401(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeEndpointAccess$400(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeEndpointAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeClusterSecurityGroupIngress$398(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeClusterSecurityGroupIngress$397(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeClusterSecurityGroupIngressResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resumeCluster$395(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeCluster$394(List metricPublishers, MetricCollector apiCallMetricCollector, ResumeClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreTableFromClusterSnapshot$392(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableFromClusterSnapshot$391(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreTableFromClusterSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreFromClusterSnapshot$389(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreFromClusterSnapshot$388(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreFromClusterSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resizeCluster$386(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resizeCluster$385(List metricPublishers, MetricCollector apiCallMetricCollector, ResizeClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetClusterParameterGroup$383(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetClusterParameterGroup$382(List metricPublishers, MetricCollector apiCallMetricCollector, ResetClusterParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rejectDataShare$380(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectDataShare$379(List metricPublishers, MetricCollector apiCallMetricCollector, RejectDataShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rebootCluster$377(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootCluster$376(List metricPublishers, MetricCollector apiCallMetricCollector, RebootClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$374(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$373(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$purchaseReservedNodeOffering$371(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseReservedNodeOffering$370(List metricPublishers, MetricCollector apiCallMetricCollector, PurchaseReservedNodeOfferingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$pauseCluster$368(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pauseCluster$367(List metricPublishers, MetricCollector apiCallMetricCollector, PauseClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyUsageLimit$365(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyUsageLimit$364(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyUsageLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifySnapshotSchedule$362(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifySnapshotSchedule$361(List metricPublishers, MetricCollector apiCallMetricCollector, ModifySnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifySnapshotCopyRetentionPeriod$359(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifySnapshotCopyRetentionPeriod$358(List metricPublishers, MetricCollector apiCallMetricCollector, ModifySnapshotCopyRetentionPeriodResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyScheduledAction$356(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyScheduledAction$355(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyScheduledActionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyRedshiftIdcApplication$353(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyRedshiftIdcApplication$352(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyRedshiftIdcApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyIntegration$350(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyIntegration$349(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyIntegrationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyEventSubscription$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyEventSubscription$346(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyEventSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyEndpointAccess$344(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyEndpointAccess$343(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyEndpointAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyCustomDomainAssociation$341(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyCustomDomainAssociation$340(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyCustomDomainAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterSubnetGroup$338(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterSubnetGroup$337(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterSnapshotSchedule$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterSnapshotSchedule$334(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterSnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterSnapshot$332(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterSnapshot$331(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterParameterGroup$329(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterParameterGroup$328(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterMaintenance$326(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterMaintenance$325(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterMaintenanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterIamRoles$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterIamRoles$322(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterIamRolesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyClusterDbRevision$320(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClusterDbRevision$319(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterDbRevisionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyCluster$317(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyCluster$316(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyAuthenticationProfile$314(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyAuthenticationProfile$313(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyAuthenticationProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyAquaConfiguration$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyAquaConfiguration$310(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyAquaConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRecommendations$308(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendations$307(List metricPublishers, MetricCollector apiCallMetricCollector, ListRecommendationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicy$305(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$304(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReservedNodeExchangeOfferings$302(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservedNodeExchangeOfferings$301(List metricPublishers, MetricCollector apiCallMetricCollector, GetReservedNodeExchangeOfferingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReservedNodeExchangeConfigurationOptions$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservedNodeExchangeConfigurationOptions$298(List metricPublishers, MetricCollector apiCallMetricCollector, GetReservedNodeExchangeConfigurationOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getClusterCredentialsWithIAM$296(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClusterCredentialsWithIAM$295(List metricPublishers, MetricCollector apiCallMetricCollector, GetClusterCredentialsWithIamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getClusterCredentials$293(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClusterCredentials$292(List metricPublishers, MetricCollector apiCallMetricCollector, GetClusterCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$failoverPrimaryCompute$290(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$failoverPrimaryCompute$289(List metricPublishers, MetricCollector apiCallMetricCollector, FailoverPrimaryComputeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableSnapshotCopy$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableSnapshotCopy$286(List metricPublishers, MetricCollector apiCallMetricCollector, EnableSnapshotCopyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableLogging$284(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableLogging$283(List metricPublishers, MetricCollector apiCallMetricCollector, EnableLoggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateDataShareConsumer$281(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateDataShareConsumer$280(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateDataShareConsumerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableSnapshotCopy$278(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableSnapshotCopy$277(List metricPublishers, MetricCollector apiCallMetricCollector, DisableSnapshotCopyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableLogging$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableLogging$274(List metricPublishers, MetricCollector apiCallMetricCollector, DisableLoggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeUsageLimits$272(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUsageLimits$271(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeUsageLimitsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTags$269(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$268(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTableRestoreStatus$266(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableRestoreStatus$265(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableRestoreStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStorage$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStorage$262(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStorageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSnapshotSchedules$260(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshotSchedules$259(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSnapshotSchedulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSnapshotCopyGrants$257(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshotCopyGrants$256(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSnapshotCopyGrantsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeScheduledActions$254(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScheduledActions$253(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeScheduledActionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResize$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResize$250(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResizeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReservedNodes$248(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodes$247(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReservedNodesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReservedNodeOfferings$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodeOfferings$244(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReservedNodeOfferingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReservedNodeExchangeStatus$242(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodeExchangeStatus$241(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReservedNodeExchangeStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRedshiftIdcApplications$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRedshiftIdcApplications$238(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRedshiftIdcApplicationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describePartners$236(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePartners$235(List metricPublishers, MetricCollector apiCallMetricCollector, DescribePartnersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeOrderableClusterOptions$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrderableClusterOptions$232(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeOrderableClusterOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeNodeConfigurationOptions$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNodeConfigurationOptions$229(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeNodeConfigurationOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLoggingStatus$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoggingStatus$226(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLoggingStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeIntegrations$224(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIntegrations$223(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeIntegrationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeInboundIntegrations$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInboundIntegrations$220(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeInboundIntegrationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeHsmConfigurations$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeHsmConfigurations$217(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeHsmConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeHsmClientCertificates$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeHsmClientCertificates$214(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeHsmClientCertificatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEvents$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$211(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEventSubscriptions$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventSubscriptions$208(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEventSubscriptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEventCategories$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventCategories$205(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEventCategoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpointAuthorization$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpointAuthorization$202(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointAuthorizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpointAccess$200(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpointAccess$199(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDefaultClusterParameters$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDefaultClusterParameters$196(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDefaultClusterParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataSharesForProducer$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataSharesForProducer$193(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataSharesForProducerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataSharesForConsumer$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataSharesForConsumer$190(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataSharesForConsumerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataShares$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataShares$187(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataSharesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomDomainAssociations$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomDomainAssociations$184(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomDomainAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusters$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$181(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterVersions$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterVersions$178(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterTracks$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterTracks$175(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterTracksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterSubnetGroups$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterSubnetGroups$172(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterSubnetGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterSnapshots$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterSnapshots$169(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterSecurityGroups$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterSecurityGroups$166(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterSecurityGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterParameters$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterParameters$163(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterParameterGroups$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterParameterGroups$160(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterParameterGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusterDbRevisions$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusterDbRevisions$157(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterDbRevisionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAuthenticationProfiles$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAuthenticationProfiles$154(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAuthenticationProfilesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAccountAttributes$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountAttributes$151(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAccountAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteUsageLimit$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUsageLimit$148(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteUsageLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTags$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$145(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSnapshotSchedule$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshotSchedule$142(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSnapshotCopyGrant$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshotCopyGrant$139(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSnapshotCopyGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteScheduledAction$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScheduledAction$136(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteScheduledActionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$133(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRedshiftIdcApplication$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRedshiftIdcApplication$130(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRedshiftIdcApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePartner$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePartner$127(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePartnerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteIntegration$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIntegration$124(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteIntegrationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteHsmConfiguration$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHsmConfiguration$121(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteHsmConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteHsmClientCertificate$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHsmClientCertificate$118(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteHsmClientCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEventSubscription$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventSubscription$115(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEventSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEndpointAccess$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpointAccess$112(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEndpointAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomDomainAssociation$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomDomainAssociation$109(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomDomainAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteClusterSubnetGroup$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClusterSubnetGroup$106(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteClusterSnapshot$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClusterSnapshot$103(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteClusterSecurityGroup$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClusterSecurityGroup$100(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterSecurityGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteClusterParameterGroup$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClusterParameterGroup$97(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCluster$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$94(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAuthenticationProfile$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAuthenticationProfile$91(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAuthenticationProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deauthorizeDataShare$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deauthorizeDataShare$88(List metricPublishers, MetricCollector apiCallMetricCollector, DeauthorizeDataShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUsageLimit$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUsageLimit$85(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUsageLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTags$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$82(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSnapshotSchedule$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshotSchedule$79(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSnapshotCopyGrant$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshotCopyGrant$76(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSnapshotCopyGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createScheduledAction$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScheduledAction$73(List metricPublishers, MetricCollector apiCallMetricCollector, CreateScheduledActionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRedshiftIdcApplication$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRedshiftIdcApplication$70(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRedshiftIdcApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createIntegration$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIntegration$67(List metricPublishers, MetricCollector apiCallMetricCollector, CreateIntegrationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHsmConfiguration$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHsmConfiguration$64(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHsmConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHsmClientCertificate$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHsmClientCertificate$61(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHsmClientCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEventSubscription$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventSubscription$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEventSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEndpointAccess$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpointAccess$55(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEndpointAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomDomainAssociation$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomDomainAssociation$52(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomDomainAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createClusterSubnetGroup$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createClusterSubnetGroup$49(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createClusterSnapshot$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createClusterSnapshot$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createClusterSecurityGroup$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createClusterSecurityGroup$43(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterSecurityGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createClusterParameterGroup$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createClusterParameterGroup$40(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCluster$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAuthenticationProfile$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAuthenticationProfile$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAuthenticationProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copyClusterSnapshot$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyClusterSnapshot$31(List metricPublishers, MetricCollector apiCallMetricCollector, CopyClusterSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelResize$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelResize$28(List metricPublishers, MetricCollector apiCallMetricCollector, CancelResizeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchModifyClusterSnapshots$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchModifyClusterSnapshots$25(List metricPublishers, MetricCollector apiCallMetricCollector, BatchModifyClusterSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteClusterSnapshots$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteClusterSnapshots$22(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteClusterSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$authorizeSnapshotAccess$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeSnapshotAccess$19(List metricPublishers, MetricCollector apiCallMetricCollector, AuthorizeSnapshotAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$authorizeEndpointAccess$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeEndpointAccess$16(List metricPublishers, MetricCollector apiCallMetricCollector, AuthorizeEndpointAccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$authorizeDataShare$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeDataShare$13(List metricPublishers, MetricCollector apiCallMetricCollector, AuthorizeDataShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$authorizeClusterSecurityGroupIngress$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeClusterSecurityGroupIngress$10(List metricPublishers, MetricCollector apiCallMetricCollector, AuthorizeClusterSecurityGroupIngressResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateDataShareConsumer$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateDataShareConsumer$7(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateDataShareConsumerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addPartner$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addPartner$4(List metricPublishers, MetricCollector apiCallMetricCollector, AddPartnerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$acceptReservedNodeExchange$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptReservedNodeExchange$1(List metricPublishers, MetricCollector apiCallMetricCollector, AcceptReservedNodeExchangeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

