/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyUsageLimitRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyUsageLimitRequest> {
    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageLimitId").getter(ModifyUsageLimitRequest.getter(ModifyUsageLimitRequest::usageLimitId)).setter(ModifyUsageLimitRequest.setter(Builder::usageLimitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageLimitId").build()}).build();
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Amount").getter(ModifyUsageLimitRequest.getter(ModifyUsageLimitRequest::amount)).setter(ModifyUsageLimitRequest.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BreachAction").getter(ModifyUsageLimitRequest.getter(ModifyUsageLimitRequest::breachActionAsString)).setter(ModifyUsageLimitRequest.setter(Builder::breachAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreachAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_LIMIT_ID_FIELD, AMOUNT_FIELD, BREACH_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UsageLimitId", USAGE_LIMIT_ID_FIELD);
            this.put("Amount", AMOUNT_FIELD);
            this.put("BreachAction", BREACH_ACTION_FIELD);
        }
    });
    private final String usageLimitId;
    private final Long amount;
    private final String breachAction;

    private ModifyUsageLimitRequest(BuilderImpl builder) {
        super(builder);
        this.usageLimitId = builder.usageLimitId;
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
    }

    public final String usageLimitId() {
        return this.usageLimitId;
    }

    public final Long amount() {
        return this.amount;
    }

    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(this.breachAction);
    }

    public final String breachActionAsString() {
        return this.breachAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.usageLimitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUsageLimitRequest)) {
            return false;
        }
        ModifyUsageLimitRequest other = (ModifyUsageLimitRequest)((Object)obj);
        return Objects.equals(this.usageLimitId(), other.usageLimitId()) && Objects.equals(this.amount(), other.amount()) && Objects.equals(this.breachActionAsString(), other.breachActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyUsageLimitRequest").add("UsageLimitId", (Object)this.usageLimitId()).add("Amount", (Object)this.amount()).add("BreachAction", (Object)this.breachActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageLimitId": {
                return Optional.ofNullable(clazz.cast(this.usageLimitId()));
            }
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "BreachAction": {
                return Optional.ofNullable(clazz.cast(this.breachActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyUsageLimitRequest, T> g) {
        return obj -> g.apply((ModifyUsageLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String usageLimitId;
        private Long amount;
        private String breachAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUsageLimitRequest model) {
            super(model);
            this.usageLimitId(model.usageLimitId);
            this.amount(model.amount);
            this.breachAction(model.breachAction);
        }

        public final String getUsageLimitId() {
            return this.usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        public final Long getAmount() {
            return this.amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return this.breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyUsageLimitRequest build() {
            return new ModifyUsageLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyUsageLimitRequest> {
        public Builder usageLimitId(String var1);

        public Builder amount(Long var1);

        public Builder breachAction(String var1);

        public Builder breachAction(UsageLimitBreachAction var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

