/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOptionsListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrderableClusterOptionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
    private static final SdkField<List<OrderableClusterOption>> ORDERABLE_CLUSTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderableClusterOptions").getter(DescribeOrderableClusterOptionsResponse.getter(DescribeOrderableClusterOptionsResponse::orderableClusterOptions)).setter(DescribeOrderableClusterOptionsResponse.setter(Builder::orderableClusterOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableClusterOptions").build(), ListTrait.builder().memberLocationName("OrderableClusterOption").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderableClusterOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableClusterOption").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeOrderableClusterOptionsResponse.getter(DescribeOrderableClusterOptionsResponse::marker)).setter(DescribeOrderableClusterOptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERABLE_CLUSTER_OPTIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrderableClusterOptions", ORDERABLE_CLUSTER_OPTIONS_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final List<OrderableClusterOption> orderableClusterOptions;
    private final String marker;

    private DescribeOrderableClusterOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableClusterOptions = builder.orderableClusterOptions;
        this.marker = builder.marker;
    }

    public final boolean hasOrderableClusterOptions() {
        return this.orderableClusterOptions != null && !(this.orderableClusterOptions instanceof SdkAutoConstructList);
    }

    public final List<OrderableClusterOption> orderableClusterOptions() {
        return this.orderableClusterOptions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderableClusterOptions() ? this.orderableClusterOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableClusterOptionsResponse)) {
            return false;
        }
        DescribeOrderableClusterOptionsResponse other = (DescribeOrderableClusterOptionsResponse)((Object)obj);
        return this.hasOrderableClusterOptions() == other.hasOrderableClusterOptions() && Objects.equals(this.orderableClusterOptions(), other.orderableClusterOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrderableClusterOptionsResponse").add("OrderableClusterOptions", this.hasOrderableClusterOptions() ? this.orderableClusterOptions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableClusterOptions": {
                return Optional.ofNullable(clazz.cast(this.orderableClusterOptions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableClusterOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOrderableClusterOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<OrderableClusterOption> orderableClusterOptions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableClusterOptionsResponse model) {
            super(model);
            this.orderableClusterOptions(model.orderableClusterOptions);
            this.marker(model.marker);
        }

        public final List<OrderableClusterOption.Builder> getOrderableClusterOptions() {
            List<OrderableClusterOption.Builder> result = OrderableClusterOptionsListCopier.copyToBuilder(this.orderableClusterOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderableClusterOptions(Collection<OrderableClusterOption.BuilderImpl> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copyFromBuilder(orderableClusterOptions);
        }

        @Override
        public final Builder orderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copy(orderableClusterOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(OrderableClusterOption ... orderableClusterOptions) {
            this.orderableClusterOptions(Arrays.asList(orderableClusterOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(Consumer<OrderableClusterOption.Builder> ... orderableClusterOptions) {
            this.orderableClusterOptions(Stream.of(orderableClusterOptions).map(c -> (OrderableClusterOption)((OrderableClusterOption.Builder)OrderableClusterOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeOrderableClusterOptionsResponse build() {
            return new DescribeOrderableClusterOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
        public Builder orderableClusterOptions(Collection<OrderableClusterOption> var1);

        public Builder orderableClusterOptions(OrderableClusterOption ... var1);

        public Builder orderableClusterOptions(Consumer<OrderableClusterOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

